/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.container;

import mcjty.lib.container.InventoryHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class InventoryLocator {
    private BlockPos inventoryCoordinate = null;
    private EnumFacing inventorySide = null;

    private IItemHandler getItemHandlerAtDirection(World worldObj, BlockPos thisCoordinate, EnumFacing direction) {
        if (direction == null) {
            if (this.inventoryCoordinate != null) {
                return this.getItemHandlerAtCoordinate(worldObj, this.inventoryCoordinate, this.inventorySide);
            }
            return null;
        }
        TileEntity te = worldObj.func_175625_s(thisCoordinate);
        if (te != null && te.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, direction.func_176734_d())) {
            this.inventoryCoordinate = thisCoordinate.func_177972_a(direction);
            this.inventorySide = direction.func_176734_d();
            return this.getItemHandlerAtCoordinate(worldObj, this.inventoryCoordinate, this.inventorySide);
        }
        return null;
    }

    private IItemHandler getItemHandlerAtCoordinate(World worldObj, BlockPos c, EnumFacing direction) {
        TileEntity te = worldObj.func_175625_s(c);
        if (te != null && te.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, direction)) {
            return (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, direction);
        }
        return null;
    }

    private IInventory getInventoryAtDirection(World worldObj, BlockPos thisCoordinate, EnumFacing direction) {
        if (direction == null) {
            if (this.inventoryCoordinate != null) {
                return this.getInventoryAtCoordinate(worldObj, this.inventoryCoordinate);
            }
            return null;
        }
        this.inventoryCoordinate = thisCoordinate.func_177972_a(direction);
        this.inventorySide = direction.func_176734_d();
        return this.getInventoryAtCoordinate(worldObj, this.inventoryCoordinate);
    }

    private IInventory getInventoryAtCoordinate(World worldObj, BlockPos c) {
        TileEntity te = worldObj.func_175625_s(c);
        if (te instanceof IInventory) {
            return (IInventory)te;
        }
        return null;
    }

    public void ejectStack(World worldObj, BlockPos pos, ItemStack stack, BlockPos thisCoordinate, EnumFacing[] directions) {
        for (EnumFacing dir : directions) {
            IItemHandler handler = this.getItemHandlerAtDirection(worldObj, thisCoordinate, dir);
            if (stack == null) break;
            if (handler != null) {
                stack = ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)stack, (boolean)false);
                continue;
            }
            IInventory inventory = this.getInventoryAtDirection(worldObj, thisCoordinate, dir);
            if (inventory == null) continue;
            int amount = InventoryHelper.mergeItemStackSafe(inventory, false, this.getInventorySide(), stack, 0, inventory.func_70302_i_(), null);
            if (amount == 0) {
                stack = null;
                continue;
            }
            stack.field_77994_a = amount;
        }
        if (stack != null) {
            EntityItem entityItem = new EntityItem(worldObj, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), stack);
            worldObj.func_72838_d((Entity)entityItem);
        }
    }

    public EnumFacing getInventorySide() {
        return this.inventorySide;
    }
}

