/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.network;

import mcjty.lib.network.AbstractServerCommand;
import mcjty.lib.network.Argument;
import mcjty.lib.network.CommandHandler;
import mcjty.lib.varia.Logging;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketServerCommand
extends AbstractServerCommand {
    public PacketServerCommand() {
    }

    public PacketServerCommand(BlockPos pos, String command, Argument ... arguments) {
        super(pos, command, arguments);
        this.dimensionId = null;
    }

    public PacketServerCommand(BlockPos pos, Integer dimensionId, String command, Argument ... arguments) {
        super(pos, command, arguments);
        this.dimensionId = dimensionId;
    }

    public static class Handler
    implements IMessageHandler<PacketServerCommand, IMessage> {
        public IMessage onMessage(PacketServerCommand message, MessageContext ctx) {
            FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> this.handle(message, ctx));
            return null;
        }

        private void handle(PacketServerCommand message, MessageContext ctx) {
            EntityPlayerMP playerEntity = ctx.getServerHandler().field_147369_b;
            Object world = message.dimensionId == null ? playerEntity.field_70170_p : DimensionManager.getWorld((int)message.dimensionId);
            if (world == null) {
                return;
            }
            TileEntity te = world.func_175625_s(message.pos);
            if (!(te instanceof CommandHandler)) {
                Logging.log("createStartScanPacket: TileEntity is not a CommandHandler!");
                return;
            }
            CommandHandler commandHandler = (CommandHandler)te;
            if (!commandHandler.execute(playerEntity, message.command, message.args)) {
                Logging.log("Command " + message.command + " was not handled!");
            }
        }
    }
}

