/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.preferences;

import mcjty.lib.McJtyLib;
import mcjty.lib.gui.GuiStyle;
import mcjty.lib.network.PacketSendPreferencesToClient;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class PreferencesProperties {
    private static final int DEFAULT_BUFFX = 2;
    private static final int DEFAULT_BUFFY = 2;
    private static final GuiStyle DEFAULT_STYLE = GuiStyle.STYLE_FLAT_GRADIENT;
    private int buffX = 2;
    private int buffY = 2;
    private GuiStyle style = DEFAULT_STYLE;
    private boolean dirty = true;

    public void tick(EntityPlayerMP player) {
        if (this.dirty) {
            this.syncToClient(player);
        }
    }

    private void syncToClient(EntityPlayerMP player) {
        System.out.println("syncToClient: style = " + (Object)((Object)this.style));
        McJtyLib.networkHandler.sendTo((IMessage)new PacketSendPreferencesToClient(this.buffX, this.buffY, this.style), player);
        this.dirty = false;
    }

    public void saveNBTData(NBTTagCompound compound) {
        compound.func_74768_a("buffX", this.buffX);
        compound.func_74768_a("buffY", this.buffY);
        compound.func_74778_a("style", this.style.getStyle());
    }

    public void loadNBTData(NBTTagCompound compound) {
        this.buffX = compound.func_74762_e("buffX");
        this.buffY = compound.func_74762_e("buffY");
        String s = compound.func_74779_i("style");
        this.style = GuiStyle.getStyle(s);
        if (this.style == null) {
            this.style = DEFAULT_STYLE;
        }
        this.dirty = true;
    }

    public void reset() {
        this.buffX = 2;
        this.buffY = 2;
        this.style = DEFAULT_STYLE;
        this.dirty = true;
    }

    public boolean setStyle(String s) {
        GuiStyle st = GuiStyle.getStyle(s);
        if (st == null) {
            return false;
        }
        this.style = st;
        this.dirty = true;
        return true;
    }

    public boolean setStyle(GuiStyle st) {
        if (st == null) {
            return false;
        }
        this.style = st;
        this.dirty = true;
        return true;
    }

    public GuiStyle getStyle() {
        return this.style;
    }

    public void setBuffXY(int x, int y) {
        this.buffX = x;
        this.buffY = y;
        this.dirty = true;
    }

    public int getBuffX() {
        return this.buffX;
    }

    public int getBuffY() {
        return this.buffY;
    }
}

