/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.api.render;

import com.google.common.collect.Maps;
import gnu.trove.set.TLongSet;
import gnu.trove.set.hash.TLongHashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import team.chisel.api.render.IBlockRenderContext;
import team.chisel.api.render.IBlockRenderType;

@ParametersAreNonnullByDefault
public class RenderContextList {
    private final Map<IBlockRenderType, IBlockRenderContext> contextMap = Maps.newIdentityHashMap();
    private final TLongSet serialized = new TLongHashSet();

    public RenderContextList() {
    }

    public RenderContextList(List<IBlockRenderType> types, IBlockAccess world, BlockPos pos) {
        for (IBlockRenderType type : types) {
            IBlockRenderContext ctx = type.getBlockRenderContext(world, pos);
            if (ctx == null) continue;
            this.contextMap.put(type, ctx);
        }
        for (IBlockRenderContext ctx : this.contextMap.values()) {
            this.serialized.add(ctx.getCompressedData());
        }
    }

    @Nullable
    public IBlockRenderContext getRenderContext(IBlockRenderType type) {
        return this.contextMap.get(type);
    }

    public boolean contains(IBlockRenderType type) {
        return this.getRenderContext(type) != null;
    }

    public TLongSet serialized() {
        return this.serialized;
    }
}

