/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.client.gui;

import com.google.common.base.Optional;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.apache.commons.lang3.ArrayUtils;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GLContext;
import org.lwjgl.util.Rectangle;
import team.chisel.Chisel;
import team.chisel.client.ClientUtil;
import team.chisel.client.gui.GuiChisel;
import team.chisel.client.gui.PacketChiselButton;
import team.chisel.client.gui.PacketChiselNBT;
import team.chisel.client.gui.PreviewType;
import team.chisel.common.inventory.ContainerChiselHitech;
import team.chisel.common.inventory.InventoryChiselSelection;
import team.chisel.common.util.NBTUtil;

@ParametersAreNonnullByDefault
public class GuiHitechChisel
extends GuiChisel {
    private static final boolean scissorAvailable = GLContext.getCapabilities().OpenGL20;
    private static final Rectangle panel = new Rectangle(8, 14, 74, 74);
    private static final ResourceLocation TEXTURE = new ResourceLocation("chisel", "textures/chiselGuiHitech.png");
    private final ContainerChiselHitech containerHitech;
    private final FakeBlockAccess fakeworld = new FakeBlockAccess(this);
    private boolean panelClicked;
    private int clickButton;
    private long lastDragTime;
    private int clickX;
    private int clickY;
    private float initRotX;
    private float initRotY;
    private float initZoom;
    private float prevRotX;
    private float prevRotY;
    private float momentumX;
    private float momentumY;
    private float momentumDampening = 0.98f;
    private float rotX = -15.0f;
    private float rotY;
    private float zoom = 1.0f;
    private int scrollAcc;
    @Nullable
    private PreviewModeButton buttonPreview;
    @Nullable
    private GuiButton buttonChisel;
    @Nullable
    private RotateButton buttonRotate;

    public GuiHitechChisel(InventoryPlayer iinventory, InventoryChiselSelection menu, EnumHand hand) {
        super(iinventory, menu, hand);
        this.containerHitech = new ContainerChiselHitech(iinventory, menu, hand);
        this.field_147002_h = this.containerHitech;
        this.field_146999_f = 256;
        this.field_147000_g = 220;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        int x = this.field_147003_i + panel.getX() - 1;
        int y = this.field_147009_r + panel.getY() + panel.getHeight() + 3;
        int w = 76;
        int h = 20;
        int id = 0;
        this.buttonPreview = new PreviewModeButton(id++, x, y, w, h);
        this.field_146292_n.add(this.buttonPreview);
        this.buttonChisel = new GuiButton(id++, x, y += h + 2, w, h, "Chisel");
        this.field_146292_n.add(this.buttonChisel);
        this.buttonRotate = new RotateButton(id++, this.field_147003_i + panel.getX() + panel.getWidth() - 16, this.field_147009_r + panel.getY() + panel.getHeight() - 16);
        this.field_146292_n.add(this.buttonRotate);
        ItemStack chisel = this.containerHitech.getChisel();
        this.buttonPreview.setType(NBTUtil.getHitechType(chisel));
        this.buttonRotate.rotate = NBTUtil.getHitechRotate(chisel);
        this.func_73876_c();
    }

    public void func_73876_c() {
        super.func_73876_c();
        boolean bl = this.buttonChisel.field_146124_l = this.containerHitech.getSelection() != null && this.containerHitech.getSelection().func_75216_d() && this.containerHitech.getTarget() != null && this.containerHitech.getTarget().func_75216_d();
        if (!this.panelClicked) {
            this.initRotX = this.rotX;
            this.initRotY = this.rotY;
            this.initZoom = this.zoom;
        }
        this.buttonChisel.field_146126_j = this.isShiftDown() ? TextFormatting.YELLOW.toString() + "Chisel All" : "Chisel";
    }

    @Override
    public void func_146281_b() {
        super.func_146281_b();
        if (this.containerHitech.getChisel() == this.containerHitech.getInventoryChisel().func_70301_a(this.containerHitech.getChiselSlot())) {
            ItemStack stack = this.containerHitech.getChisel();
            NBTUtil.setHitechType(stack, this.buttonPreview.getType().ordinal());
            NBTUtil.setHitechSelection(stack, (Integer)Optional.fromNullable((Object)this.containerHitech.getSelection()).transform(s -> s.field_75222_d).or((Object)-1));
            NBTUtil.setHitechTarget(stack, (Integer)Optional.fromNullable((Object)this.containerHitech.getTarget()).transform(s -> s.field_75222_d).or((Object)-1));
            NBTUtil.setHitechRotate(stack, this.buttonRotate.rotate());
            Chisel.network.sendToServer((IMessage)new PacketChiselNBT(NBTUtil.getChiselTag(this.containerHitech.getChisel()), this.containerHitech.getChiselSlot()));
        }
    }

    private boolean isShiftDown() {
        return Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54);
    }

    @Override
    protected void func_146976_a(float f, int mx, int my) {
        Slot sel;
        this.func_146276_q_();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TEXTURE);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        if (this.containerHitech.getSelection() != null && (sel = this.containerHitech.getSelection()).func_75216_d()) {
            this.drawSlotHighlight(sel, 0);
            for (Slot s : this.containerHitech.getSelectionDuplicates()) {
                this.drawSlotHighlight(s, this.isShiftDown() ? 0 : 18);
            }
        }
        if (this.containerHitech.getTarget() != null && this.containerHitech.getTarget().func_75211_c() != null) {
            this.drawSlotHighlight(this.containerHitech.getTarget(), 36);
        }
        if (this.buttonRotate.rotate() && !this.panelClicked && System.currentTimeMillis() - this.lastDragTime > 2000L) {
            this.rotY = this.initRotY + f * 2.0f;
        }
        this.scrollAcc += Mouse.getDWheel();
        if (Math.abs(this.scrollAcc) >= 120) {
            int idx = -1;
            if (this.containerHitech.getTarget() != null) {
                idx = this.containerHitech.getTarget().getSlotIndex();
            }
            while (Math.abs(this.scrollAcc) >= 120) {
                if (this.scrollAcc > 0) {
                    --idx;
                    this.scrollAcc -= 120;
                    continue;
                }
                ++idx;
                this.scrollAcc += 120;
            }
            if (idx < 0) {
                for (int i = this.containerHitech.getInventoryChisel().size - 1; i >= 0; --i) {
                    if (this.containerHitech.func_75139_a(i).func_75216_d()) {
                        idx = i;
                        break;
                    }
                    if (i != 0) continue;
                    idx = 0;
                }
            } else if (idx >= this.containerHitech.getInventoryChisel().size || !this.containerHitech.func_75139_a(idx).func_75216_d()) {
                idx = 0;
            }
            this.containerHitech.setTarget(this.containerHitech.func_75139_a(idx));
        }
    }

    private void drawSlotHighlight(Slot slot, int u) {
        this.func_73729_b(this.field_147003_i + slot.field_75223_e - 1, this.field_147009_r + slot.field_75221_f - 1, u, 220, 18, 18);
    }

    @Override
    protected void func_146979_b(int j, int i) {
        boolean doMomentum = true;
        if (this.panelClicked) {
            if (this.clickButton == 0) {
                this.prevRotX = this.rotX;
                this.prevRotY = this.rotY;
                this.rotX = this.initRotX + (float)Mouse.getY() - (float)this.clickY;
                this.rotY = this.initRotY + (float)Mouse.getX() - (float)this.clickX;
                this.momentumX = this.rotX - this.prevRotX;
                this.momentumY = this.rotY - this.prevRotY;
                doMomentum = false;
            } else if (this.clickButton == 1 && scissorAvailable) {
                this.zoom = Math.max(1.0f, this.initZoom + (float)(this.clickY - Mouse.getY()));
            }
        }
        if (doMomentum) {
            this.rotX += this.momentumX;
            this.rotY += this.momentumY;
            this.momentumX *= this.momentumDampening;
            this.momentumY *= this.momentumDampening;
        }
        String s = "Preview";
        this.field_146289_q.func_78276_b("Preview", panel.getX() + panel.getWidth() / 2 - this.field_146289_q.func_78256_a(s) / 2, panel.getY() - 9, 0x404040);
        try {
            ItemStack stack;
            BlockRendererDispatcher brd = this.field_146297_k.func_175602_ab();
            if (this.containerHitech.getTarget() != null && (stack = this.containerHitech.getTarget().func_75211_c()) != null) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)(panel.getX() + panel.getWidth() / 2), (float)(panel.getY() + panel.getHeight() / 2), (float)100.0f);
                double sc = (double)this.buttonPreview.getType().getScale() * (Math.sqrt(this.zoom + 99.0f) - 9.0);
                GlStateManager.func_179139_a((double)(-sc), (double)(-sc), (double)(-sc));
                GlStateManager.func_179114_b((float)this.rotX, (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)this.rotY, (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179137_b((double)-1.5, (double)-2.5, (double)-0.5);
                Block block = Block.func_149634_a((Item)stack.func_77973_b());
                IBlockState state = block.func_176203_a(stack.func_77960_j());
                if (state instanceof IExtendedBlockState) {
                    state = ((IExtendedBlockState)state).getClean();
                }
                this.fakeworld.setState(state);
                Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
                Tessellator.func_178181_a().func_178180_c().func_181668_a(7, DefaultVertexFormats.field_176600_a);
                for (BlockPos pos : this.buttonPreview.getType().getPositions()) {
                    brd.func_175018_a(state, pos, (IBlockAccess)this.fakeworld, Tessellator.func_178181_a().func_178180_c());
                }
                if (scissorAvailable) {
                    ScaledResolution sr = new ScaledResolution(this.field_146297_k);
                    GL11.glEnable((int)3089);
                    GL11.glScissor((int)((this.field_147003_i + panel.getX()) * sr.func_78325_e()), (int)(this.field_146297_k.field_71440_d - (this.field_147009_r + panel.getY() + panel.getHeight()) * sr.func_78325_e()), (int)(panel.getWidth() * sr.func_78325_e()), (int)(panel.getHeight() * sr.func_78325_e()));
                }
                Tessellator.func_178181_a().func_78381_a();
                if (scissorAvailable) {
                    GL11.glDisable((int)3089);
                }
                GlStateManager.func_179121_F();
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        GlStateManager.func_179118_c();
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        if (!this.buttonRotate.func_146115_a() && panel.contains(mouseX - this.field_147003_i, mouseY - this.field_147009_r)) {
            this.clickButton = mouseButton;
            this.panelClicked = true;
            this.clickX = Mouse.getX();
            this.clickY = Mouse.getY();
        }
    }

    protected void func_146286_b(int mouseX, int mouseY, int state) {
        super.func_146286_b(mouseX, mouseY, state);
        if (this.panelClicked) {
            this.lastDragTime = System.currentTimeMillis();
        }
        this.panelClicked = false;
        this.initRotX = this.rotX;
        this.initRotY = this.rotY;
        this.initZoom = this.zoom;
    }

    protected void func_146273_a(int mouseX, int mouseY, int clickedMouseButton, long timeSinceLastClick) {
        super.func_146273_a(mouseX, mouseY, clickedMouseButton, timeSinceLastClick);
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        super.func_146284_a(button);
        if (button == this.buttonChisel) {
            Slot target = this.containerHitech.getTarget();
            Slot selected = this.containerHitech.getSelection();
            if (target != null && target.func_75216_d() && selected != null && selected.func_75216_d()) {
                if (ItemStack.func_179545_c((ItemStack)target.func_75211_c(), (ItemStack)selected.func_75211_c())) {
                    return;
                }
                ItemStack converted = target.func_75211_c().func_77946_l();
                converted.field_77994_a = selected.func_75211_c().field_77994_a;
                int[] slots = new int[]{selected.getSlotIndex()};
                if (this.isShiftDown()) {
                    slots = ArrayUtils.addAll((int[])slots, (int[])this.containerHitech.getSelectionDuplicates().stream().mapToInt(Slot::getSlotIndex).toArray());
                }
                Chisel.network.sendToServer((IMessage)new PacketChiselButton(converted, this.containerHitech.getChiselSlot(), slots));
                PacketChiselButton.chiselAll(this.player, this.containerHitech.getChiselSlot(), converted, slots);
                String sound = this.container.getCarving().getVariationSound(target.func_75211_c());
                ClientUtil.playSound(this.player.field_70170_p, MathHelper.func_76128_c((double)this.player.field_70165_t), MathHelper.func_76128_c((double)this.player.field_70163_u), MathHelper.func_76128_c((double)this.player.field_70161_v), sound, SoundCategory.BLOCKS);
                if (!this.isShiftDown()) {
                    List<Slot> dupes = this.containerHitech.getSelectionDuplicates();
                    Slot next = selected;
                    for (Slot s : dupes) {
                        if (s.field_75222_d <= selected.field_75222_d) continue;
                        next = s;
                        break;
                    }
                    if (next == selected && dupes.size() > 0) {
                        next = dupes.get(0);
                    }
                    this.containerHitech.setSelection(next);
                } else {
                    this.containerHitech.setSelection(selected);
                }
            }
        }
    }

    private static class FakeBlockAccess
    implements IBlockAccess {
        private final GuiHitechChisel gui;
        private IBlockState state = Blocks.field_150350_a.func_176223_P();

        @Nullable
        public TileEntity func_175625_s(BlockPos pos) {
            return null;
        }

        public int func_175626_b(BlockPos pos, int lightValue) {
            return 0xF000F0;
        }

        public IBlockState func_180495_p(BlockPos pos) {
            return this.gui.buttonPreview.getType().getPositions().contains(pos) ? this.state : Blocks.field_150350_a.func_176223_P();
        }

        public boolean func_175623_d(BlockPos pos) {
            return this.func_180495_p(pos).func_177230_c() == Blocks.field_150350_a;
        }

        public Biome func_180494_b(BlockPos pos) {
            return Biomes.field_76772_c;
        }

        public boolean func_72806_N() {
            return false;
        }

        public int func_175627_a(BlockPos pos, EnumFacing direction) {
            return 0;
        }

        public WorldType func_175624_G() {
            return WorldType.field_77137_b;
        }

        public boolean isSideSolid(BlockPos pos, EnumFacing side, boolean _default) {
            return this.func_180495_p(pos).isSideSolid((IBlockAccess)this, pos, side);
        }

        @ConstructorProperties(value={"gui"})
        public FakeBlockAccess(GuiHitechChisel gui) {
            this.gui = gui;
        }

        public void setState(IBlockState state) {
            this.state = state;
        }
    }

    private class RotateButton
    extends GuiButton {
        private boolean rotate;

        public RotateButton(int buttonId, int x, int y) {
            super(buttonId, x, y, 16, 16, "");
            this.rotate = true;
        }

        public void func_146112_a(Minecraft mc, int mouseX, int mouseY) {
            this.field_146123_n = mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
            mc.func_110434_K().func_110577_a(TEXTURE);
            float a = this.func_146115_a() ? 1.0f : 0.2f;
            int u = this.rotate ? 0 : 16;
            int v = 238;
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)a);
            GlStateManager.func_179147_l();
            GlStateManager.func_179126_j();
            this.field_73735_i = 1000.0f;
            this.func_73729_b(this.field_146128_h, this.field_146129_i, u, v, 16, 16);
            this.field_73735_i = 0.0f;
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }

        public boolean func_146116_c(Minecraft mc, int mouseX, int mouseY) {
            if (super.func_146116_c(mc, mouseX, mouseY)) {
                this.rotate = !this.rotate;
                return true;
            }
            return false;
        }

        public boolean rotate() {
            return this.rotate;
        }
    }

    private static class PreviewModeButton
    extends GuiButton {
        private PreviewType type;

        public PreviewModeButton(int buttonId, int x, int y, int widthIn, int heightIn) {
            super(buttonId, x, y, widthIn, heightIn, "");
            this.setType(PreviewType.values()[0]);
        }

        public boolean func_146116_c(Minecraft mc, int mouseX, int mouseY) {
            if (super.func_146116_c(mc, mouseX, mouseY)) {
                this.setType(PreviewType.values()[(this.type.ordinal() + 1) % PreviewType.values().length]);
                return true;
            }
            return false;
        }

        private final void setType(PreviewType type) {
            this.type = type;
            this.field_146126_j = "< " + type.toString() + " >";
        }

        public PreviewType getType() {
            return this.type;
        }
    }
}

