/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.client.render;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.Variant;
import net.minecraft.client.renderer.block.statemap.DefaultStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.ModelProcessingHelper;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.common.property.IExtendedBlockState;
import team.chisel.api.render.IChiselFace;
import team.chisel.api.render.IChiselTexture;
import team.chisel.client.render.ModelChiselBlock;
import team.chisel.common.util.json.JsonHelper;

public class ModelChisel
implements IModel {
    private static StateMapperBase mapper = new DefaultStateMapper();
    private Variant model;
    private Map<String, Variant> models = Maps.newHashMap();
    private String face;
    private Map<EnumFacing, String> overrides = Maps.newHashMap();
    private transient IChiselFace faceObj;
    private transient Map<EnumFacing, IChiselFace> overridesObj = new EnumMap<EnumFacing, IChiselFace>(EnumFacing.class);
    private transient IBakedModel modelObj;
    private transient Map<String, IBakedModel> modelsObj = Maps.newHashMap();
    private transient Map<IBlockState, IBakedModel> stateMap = Maps.newHashMap();
    private transient List<ResourceLocation> textures = Lists.newArrayList();

    public Collection<ResourceLocation> getDependencies() {
        ArrayList list = Lists.newArrayList((Object[])new ResourceLocation[]{this.model.func_188046_a()});
        list.addAll(this.models.values().stream().map(v -> v.func_188046_a()).collect(Collectors.toList()));
        return list;
    }

    public Collection<ResourceLocation> getTextures() {
        return ImmutableList.copyOf(this.textures);
    }

    public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        Function dummyGetter = t -> Minecraft.func_71410_x().func_147117_R().func_110572_b(TextureMap.field_174945_f.toString());
        this.modelObj = this.bake(this.model, format, (Function<ResourceLocation, TextureAtlasSprite>)dummyGetter);
        for (Map.Entry<String, Variant> e : this.models.entrySet()) {
            Variant v = e.getValue();
            this.modelsObj.put(e.getKey(), this.bake(v, format, (Function<ResourceLocation, TextureAtlasSprite>)dummyGetter));
        }
        return new ModelChiselBlock(this);
    }

    private IBakedModel bake(Variant variant, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> getter) {
        IModel imodel = ModelLoaderRegistry.getModel((ResourceLocation)variant.func_188046_a());
        imodel = ModelProcessingHelper.uvlock((IModel)imodel, (boolean)variant.func_188049_c());
        return imodel.bake(variant.getState(), format, getter);
    }

    void load() {
        if (this.faceObj != null) {
            return;
        }
        this.faceObj = JsonHelper.getOrCreateFace(new ResourceLocation(this.face));
        for (Map.Entry<EnumFacing, String> e : this.overrides.entrySet()) {
            this.overridesObj.put(e.getKey(), JsonHelper.getOrCreateFace(new ResourceLocation(e.getValue())));
        }
        this.faceObj.getTextureList().forEach(t -> this.textures.addAll(t.getTextures()));
        this.overridesObj.values().forEach(f -> f.getTextureList().forEach(t -> this.textures.addAll(t.getTextures())));
    }

    public IModelState getDefaultState() {
        return TRSRTransformation.identity();
    }

    public IChiselFace getDefaultFace() {
        return this.faceObj;
    }

    public List<IChiselTexture<?>> getChiselTextures() {
        ArrayList ret = Lists.newArrayList();
        ret.addAll(this.getDefaultFace().getTextureList());
        for (IChiselFace face : this.overridesObj.values()) {
            ret.addAll(face.getTextureList());
        }
        return ret;
    }

    public IChiselFace getFace(EnumFacing facing) {
        return this.overridesObj.getOrDefault(facing, this.faceObj);
    }

    public IBakedModel getModel(IBlockState state) {
        if (state instanceof IExtendedBlockState) {
            state = ((IExtendedBlockState)state).getClean();
        }
        String stateStr = mapper.func_178131_a((Map)state.func_177228_b());
        String capture = stateStr = stateStr.substring(stateStr.indexOf(",") + 1, stateStr.length());
        if (this.modelsObj.containsKey(stateStr)) {
            this.stateMap.computeIfAbsent(state, s -> this.modelsObj.get(capture));
        }
        return this.stateMap.getOrDefault(state, this.modelObj);
    }
}

