/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.client.render;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.block.model.ModelBlockDefinition;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModel;
import team.chisel.Chisel;
import team.chisel.client.render.ModelChisel;

public class ModelLoaderChisel
implements ICustomModelLoader {
    private static final String DEFAULT_MODEL = "{\"model\": { \"model\": \"cube\" }, \"face\":\"%s\"}";
    private final Gson gson = ModelBlockDefinition.field_178333_a;
    private IResourceManager manager;
    private Map<ResourceLocation, ModelChisel> loadedModels = Maps.newHashMap();

    public void func_110549_a(@Nonnull IResourceManager resourceManager) {
        this.manager = resourceManager;
        this.loadedModels.clear();
    }

    public boolean accepts(ResourceLocation modelLocation) {
        if (modelLocation.func_110624_b().equals("ctm")) {
            return true;
        }
        JsonElement json = this.getJSON(modelLocation);
        return json.isJsonObject() && json.getAsJsonObject().has("ctm");
    }

    public IModel loadModel(ResourceLocation modelLocation) throws IOException {
        this.loadedModels.computeIfAbsent(modelLocation, this::loadFromFile);
        ModelChisel model = this.loadedModels.get(modelLocation);
        if (model != null) {
            model.load();
        }
        return model;
    }

    @Nonnull
    private JsonElement getJSON(ResourceLocation modelLocation) {
        ResourceLocation absolute = new ResourceLocation(modelLocation.func_110624_b(), modelLocation.func_110623_a() + ".json");
        try {
            IResource resource = this.manager.func_110536_a(absolute);
            JsonElement ele = new JsonParser().parse((Reader)new InputStreamReader(resource.func_110527_b()));
            if (ele != null) {
                return ele;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return JsonNull.INSTANCE;
    }

    private ModelChisel loadFromFile(ResourceLocation res) {
        JsonElement json;
        if (res.func_110624_b().equals("ctm")) {
            String domain = res.func_110623_a();
            String path = "models/block/" + domain.substring(domain.indexOf(":") + 1, domain.length());
            domain = domain.substring(0, domain.indexOf(":"));
            domain = domain.substring(domain.lastIndexOf("/") + 1, domain.length());
            res = new ResourceLocation(domain, path);
        }
        if ((json = this.getJSON(res)).isJsonObject()) {
            JsonObject obj = json.getAsJsonObject();
            if (obj.has("ctm")) {
                JsonElement ctm = obj.get("ctm");
                if (ctm.isJsonObject()) {
                    obj = ctm.getAsJsonObject();
                } else if (ctm.isJsonPrimitive() && ctm.getAsString().equals("parent")) {
                    return this.loadFromFile(new ResourceLocation(obj.get("parent").getAsString()));
                }
            }
            return (ModelChisel)this.gson.fromJson((JsonElement)obj, ModelChisel.class);
        }
        if (json.isJsonNull()) {
            Chisel.debug("Substituting default model json for missing file " + res);
            return (ModelChisel)this.gson.fromJson(String.format(DEFAULT_MODEL, res.toString().replace("models/block/", "").concat(".cf")), ModelChisel.class);
        }
        throw new IllegalArgumentException("Found invalid JSON information \"" + json + "\" loading model " + res);
    }
}

