/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.client.render.ctm;

import com.google.common.base.Optional;
import com.google.common.collect.Maps;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.EnumMap;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import team.chisel.api.IFacade;
import team.chisel.client.render.ConnectionLocations;
import team.chisel.client.render.ctm.ISubmap;
import team.chisel.client.render.ctm.Submap;
import team.chisel.common.util.Dir;

public class CTM {
    public static final ISubmap[] uvs = new ISubmap[]{new Submap(4.0f, 4.0f, 0.0f, 0.0f), new Submap(4.0f, 4.0f, 4.0f, 0.0f), new Submap(4.0f, 4.0f, 8.0f, 0.0f), new Submap(4.0f, 4.0f, 12.0f, 0.0f), new Submap(4.0f, 4.0f, 0.0f, 4.0f), new Submap(4.0f, 4.0f, 4.0f, 4.0f), new Submap(4.0f, 4.0f, 8.0f, 4.0f), new Submap(4.0f, 4.0f, 12.0f, 4.0f), new Submap(4.0f, 4.0f, 0.0f, 8.0f), new Submap(4.0f, 4.0f, 4.0f, 8.0f), new Submap(4.0f, 4.0f, 8.0f, 8.0f), new Submap(4.0f, 4.0f, 12.0f, 8.0f), new Submap(4.0f, 4.0f, 0.0f, 12.0f), new Submap(4.0f, 4.0f, 4.0f, 12.0f), new Submap(4.0f, 4.0f, 8.0f, 12.0f), new Submap(4.0f, 4.0f, 12.0f, 12.0f), new Submap(8.0f, 8.0f, 0.0f, 0.0f), new Submap(8.0f, 8.0f, 8.0f, 0.0f), new Submap(8.0f, 8.0f, 0.0f, 8.0f), new Submap(8.0f, 8.0f, 8.0f, 8.0f)};
    public static final ISubmap FULL_TEXTURE = new Submap(16.0f, 16.0f, 0.0f, 0.0f);
    protected static int[] submapOffsets = new int[]{4, 5, 1, 0};
    public static boolean disableObscuredFaceCheckConfig = false;
    public Optional<Boolean> disableObscuredFaceCheck = Optional.absent();
    protected TIntObjectMap<Dir[]> submapMap = new TIntObjectHashMap();
    protected EnumMap<Dir, Boolean> connectionMap = Maps.newEnumMap(Dir.class);
    protected int[] submapCache;

    protected CTM() {
        for (Dir dir : Dir.VALUES) {
            this.connectionMap.put(dir, false);
        }
        this.submapMap.put(0, (Object)new Dir[]{Dir.BOTTOM, Dir.LEFT, Dir.BOTTOM_LEFT});
        this.submapMap.put(1, (Object)new Dir[]{Dir.BOTTOM, Dir.RIGHT, Dir.BOTTOM_RIGHT});
        this.submapMap.put(2, (Object)new Dir[]{Dir.TOP, Dir.RIGHT, Dir.TOP_RIGHT});
        this.submapMap.put(3, (Object)new Dir[]{Dir.TOP, Dir.LEFT, Dir.TOP_LEFT});
    }

    public static CTM getInstance() {
        return new CTM();
    }

    public int[] createSubmapIndices(IBlockAccess world, BlockPos pos, EnumFacing side) {
        this.submapCache = new int[]{18, 19, 17, 16};
        if (world == null) {
            return this.submapCache;
        }
        this.buildConnectionMap(world, pos, side);
        for (int i = 0; i < 4; ++i) {
            this.fillSubmaps(i);
        }
        return this.submapCache;
    }

    public int[] createSubmapIndices(long data, EnumFacing side) {
        this.submapCache = new int[]{18, 19, 17, 16};
        this.buildConnectionMap(data, side);
        for (int i = 0; i < 4; ++i) {
            this.fillSubmaps(i);
        }
        return this.submapCache;
    }

    public int[] getSubmapIndices() {
        return this.submapCache;
    }

    public static boolean isDefaultTexture(int id) {
        return id == 16 || id == 17 || id == 18 || id == 19;
    }

    public void buildConnectionMap(IBlockAccess world, BlockPos pos, EnumFacing side) {
        IBlockState state = world.func_180495_p(pos);
        for (Dir dir : Dir.VALUES) {
            this.connectionMap.put(dir, dir.isConnected(this, world, pos, side, state));
        }
    }

    public void buildConnectionMap(long data, EnumFacing side) {
        for (Dir dir : Dir.VALUES) {
            this.connectionMap.put(dir, false);
        }
        List<ConnectionLocations> connections = ConnectionLocations.decode(data);
        for (ConnectionLocations loc : connections) {
            if (loc.getDirForSide(side) == null) continue;
            this.connectionMap.put(loc.getDirForSide(side), true);
        }
    }

    private void fillSubmaps(int idx) {
        Dir[] dirs = (Dir[])this.submapMap.get(idx);
        if (this.connectedOr(dirs[0], dirs[1])) {
            this.submapCache[idx] = this.connectedAnd(dirs) ? submapOffsets[idx] : submapOffsets[idx] + (this.connected(dirs[0]) ? 2 : 0) + (this.connected(dirs[1]) ? 8 : 0);
        }
    }

    public boolean connected(Dir dir) {
        return this.connectionMap.get((Object)dir);
    }

    public boolean connectedAnd(Dir ... dirs) {
        for (Dir dir : dirs) {
            if (this.connected(dir)) continue;
            return false;
        }
        return true;
    }

    public boolean connectedOr(Dir ... dirs) {
        for (Dir dir : dirs) {
            if (!this.connected(dir)) continue;
            return true;
        }
        return false;
    }

    public boolean isConnected(IBlockAccess world, BlockPos current, BlockPos connection, EnumFacing dir) {
        IBlockState state = world.func_180495_p(current);
        return this.isConnected(world, current, connection, dir, state);
    }

    public boolean isConnected(IBlockAccess world, BlockPos current, BlockPos connection, EnumFacing dir, IBlockState state) {
        boolean ret;
        IBlockState obscuring;
        BlockPos pos2 = connection.func_177971_a(dir.func_176730_m());
        boolean disableObscured = (Boolean)this.disableObscuredFaceCheck.or((Object)disableObscuredFaceCheckConfig);
        IBlockState con = CTM.getBlockOrFacade(world, connection, dir);
        IBlockState iBlockState = obscuring = disableObscured ? null : CTM.getBlockOrFacade(world, pos2, dir);
        if (con == null) {
            return false;
        }
        boolean bl = ret = con == state;
        if (obscuring == null) {
            return ret;
        }
        return ret &= !obscuring.func_185917_h() || !obscuring.equals(state);
    }

    public static IBlockState getBlockOrFacade(IBlockAccess world, BlockPos pos, EnumFacing side) {
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() instanceof IFacade) {
            return ((IFacade)state.func_177230_c()).getFacade(world, pos, side);
        }
        return state;
    }
}

