/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.client.render.ctx;

import java.util.EnumMap;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import org.apache.commons.lang3.ArrayUtils;
import team.chisel.api.render.IBlockRenderContext;
import team.chisel.client.render.ConnectionLocations;
import team.chisel.client.render.ctm.CTM;

public class CTMBlockRenderContext
implements IBlockRenderContext {
    private static final ConnectionLocations[] CACHED_LOCATIONS = (ConnectionLocations[])ArrayUtils.removeElements((Object[])ConnectionLocations.VALUES, (Object[])new ConnectionLocations[]{ConnectionLocations.UP_UP, ConnectionLocations.DOWN_DOWN, ConnectionLocations.EAST_EAST, ConnectionLocations.WEST_WEST, ConnectionLocations.NORTH_NORTH, ConnectionLocations.SOUTH_SOUTH});
    private EnumMap<EnumFacing, CTM> ctmData = new EnumMap(EnumFacing.class);
    private long data;

    public CTMBlockRenderContext(IBlockAccess world, BlockPos pos) {
        for (EnumFacing face : EnumFacing.field_82609_l) {
            CTM ctm = this.createCTM();
            ctm.createSubmapIndices(world, pos, face);
            this.ctmData.put(face, ctm);
        }
        this.data = ConnectionLocations.getData(world, pos, CACHED_LOCATIONS);
    }

    public CTMBlockRenderContext(long data) {
        this.data = data;
        for (EnumFacing face : EnumFacing.field_82609_l) {
            CTM ctm = this.createCTM();
            ctm.createSubmapIndices(data, face);
            this.ctmData.put(face, ctm);
        }
    }

    protected CTM createCTM() {
        return CTM.getInstance();
    }

    public CTM getCTM(EnumFacing face) {
        return this.ctmData.get(face);
    }

    @Override
    public long getCompressedData() {
        return this.data;
    }
}

