/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.common.asm;

import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public class ChiselTransformer
implements IClassTransformer {
    private static final String BLOCK_CLASS = "net.minecraft.block.Block";
    private static final String EXTENDED_STATE_METHOD_NAME = "getExtendedState";
    private static final String WRAPPER_CLASS_NAME = "team/chisel/client/ChiselExtendedState";
    private static final String WRAPPER_CLASS_CONSTRUCTOR_NAME = "<init>";
    private static final String WRAPPER_CLASS_CONSTRUCTOR_DESC = "(Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/util/math/BlockPos;)V";

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (transformedName.equals(BLOCK_CLASS)) {
            System.out.println("Transforming Class [" + transformedName + "], Method [" + EXTENDED_STATE_METHOD_NAME + "]");
            ClassNode classNode = new ClassNode();
            ClassReader classReader = new ClassReader(basicClass);
            classReader.accept((ClassVisitor)classNode, 0);
            block0: for (MethodNode m : classNode.methods) {
                if (!m.name.equals(EXTENDED_STATE_METHOD_NAME)) continue;
                for (int i = 0; i < m.instructions.size(); ++i) {
                    AbstractInsnNode next = m.instructions.get(i);
                    if (!(next instanceof InsnNode) || ((InsnNode)next).getOpcode() != 176) continue;
                    InsnList toAdd = new InsnList();
                    AbstractInsnNode load = m.instructions.get(i - 1);
                    int var = ((VarInsnNode)load).var;
                    toAdd.add((AbstractInsnNode)new InsnNode(87));
                    toAdd.add((AbstractInsnNode)new TypeInsnNode(187, WRAPPER_CLASS_NAME));
                    toAdd.add((AbstractInsnNode)new InsnNode(89));
                    toAdd.add((AbstractInsnNode)new VarInsnNode(25, var));
                    toAdd.add((AbstractInsnNode)new VarInsnNode(25, 2));
                    toAdd.add((AbstractInsnNode)new VarInsnNode(25, 3));
                    toAdd.add((AbstractInsnNode)new MethodInsnNode(183, WRAPPER_CLASS_NAME, WRAPPER_CLASS_CONSTRUCTOR_NAME, WRAPPER_CLASS_CONSTRUCTOR_DESC, false));
                    m.instructions.insertBefore(next, toAdd);
                    continue block0;
                }
            }
            ClassWriter cw = new ClassWriter(3);
            classNode.accept((ClassVisitor)cw);
            System.out.println("Transforming " + transformedName + " Finished.");
            return cw.toByteArray();
        }
        return basicClass;
    }
}

