/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.common.carving;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import team.chisel.api.carving.ICarvingGroup;
import team.chisel.api.carving.ICarvingVariation;

public class GroupList
implements Set<ICarvingGroup> {
    private HashMap<String, ICarvingGroup> groups = Maps.newHashMap();
    private HashMap<VariationWrapper, ICarvingGroup> lookup = Maps.newHashMap();

    @Override
    public int size() {
        return this.groups.size();
    }

    @Override
    public boolean isEmpty() {
        return this.groups.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        if (o instanceof ICarvingGroup) {
            return this.groups.containsKey(((ICarvingGroup)o).getName());
        }
        return false;
    }

    @Override
    public Iterator<ICarvingGroup> iterator() {
        return this.groups.values().iterator();
    }

    @Override
    public Object[] toArray() {
        return this.groups.values().toArray();
    }

    @Override
    public <T> T[] toArray(T[] arr) {
        return this.groups.values().toArray(arr);
    }

    @Override
    public boolean add(ICarvingGroup group) {
        String key = group.getName();
        if (this.groups.containsKey(key)) {
            return false;
        }
        for (ICarvingVariation v : group.getVariations()) {
            ICarvingGroup g = this.lookup.get(v);
            if (g != null || v == null) continue;
            this.lookup.put(new VariationWrapper(v), group);
        }
        this.groups.put(key, group);
        return true;
    }

    @Override
    public boolean remove(Object o) {
        if (o instanceof ICarvingGroup) {
            ArrayList toRemove = Lists.newArrayList();
            for (VariationWrapper v : this.lookup.keySet()) {
                if (!this.lookup.get(v).getName().equals(((ICarvingGroup)o).getName())) continue;
                toRemove.add(v);
            }
            for (VariationWrapper v : toRemove) {
                this.lookup.remove(v);
            }
            return this.groups.remove(((ICarvingGroup)o).getName()) != null;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (!(o instanceof ICarvingGroup)) {
                return false;
            }
            if (this.groups.containsKey(((ICarvingGroup)o).getName())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends ICarvingGroup> c) {
        boolean ret = false;
        for (ICarvingGroup iCarvingGroup : c) {
            ret |= this.add(iCarvingGroup);
        }
        return ret;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean ret = false;
        for (Object o : c) {
            ret |= this.remove(o);
        }
        return ret;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        this.groups.clear();
    }

    public ICarvingGroup getGroup(@Nonnull IBlockState state) {
        return this.getGroup(new BlockKey(state));
    }

    public ICarvingGroup getGroup(@Nonnull ItemStack stack) {
        return this.getGroup(new StackKey(stack));
    }

    public ICarvingGroup getGroup(@Nonnull ICarvingVariation variation) {
        return this.lookup.get(new VariationWrapper(variation));
    }

    public void addVariation(String name, @Nonnull ICarvingVariation variation) {
        ICarvingGroup g = this.groups.get(name);
        if (g == null) {
            throw new NullPointerException("No group exists for name " + name);
        }
        g.addVariation(variation);
        this.lookup.put(new VariationWrapper(variation), g);
    }

    public ICarvingGroup getGroupByName(String groupName) {
        return this.groups.get(groupName);
    }

    public ICarvingGroup getGroupByOre(String oreName) {
        for (ICarvingGroup group : this.groups.values()) {
            if (!oreName.equals(group.getOreName())) continue;
            return group;
        }
        return null;
    }

    public Collection<? extends String> getNames() {
        return this.groups.keySet();
    }

    public ICarvingVariation removeVariation(@Nonnull ItemStack stack, String group) {
        return this.removeVariation(new StackKey(stack), group);
    }

    public ICarvingVariation removeVariation(IBlockState state, String group) {
        return this.removeVariation(new BlockKey(state), group);
    }

    public ICarvingVariation removeVariation(@Nonnull ICarvingVariation variation, String group) {
        ICarvingGroup g = null;
        if (group != null) {
            g = this.groups.get(group);
            if (g == null) {
                throw new IllegalArgumentException("No such group " + group);
            }
            this.groups.remove(g.getName());
        }
        ArrayList toRemove = Lists.newArrayList();
        for (VariationWrapper v : this.lookup.keySet()) {
            if (g != null && !this.lookup.get(v).getName().equals(g.getName()) || !v.equals(new VariationWrapper(variation))) continue;
            this.lookup.get(v).removeVariation(v.v);
            toRemove.add(v);
        }
        for (VariationWrapper v : toRemove) {
            this.lookup.remove(v);
        }
        return toRemove.isEmpty() ? null : ((VariationWrapper)toRemove.get(0)).v;
    }

    public String toString() {
        return this.groups.toString();
    }

    private class StackKey
    implements ICarvingVariation {
        @Nonnull
        ItemStack stack;
        Block block;

        private StackKey(ItemStack stack) {
            this.stack = stack;
            this.block = Block.func_149634_a((Item)stack.func_77973_b());
        }

        @Override
        public Block getBlock() {
            return this.block;
        }

        @Override
        public IBlockState getBlockState() {
            return this.block.func_176223_P();
        }

        @Override
        @Nonnull
        public ItemStack getStack() {
            return this.stack;
        }

        @Override
        public int getOrder() {
            return 0;
        }

        public String toString() {
            return this.stack.toString();
        }
    }

    private class BlockKey
    implements ICarvingVariation {
        private IBlockState state;

        private BlockKey(IBlockState state) {
            this.state = state;
        }

        @Override
        @Nonnull
        public Block getBlock() {
            return this.state.func_177230_c();
        }

        @Override
        public IBlockState getBlockState() {
            return this.state;
        }

        @Override
        @Nonnull
        public ItemStack getStack() {
            return new ItemStack(this.getBlock());
        }

        @Override
        public int getOrder() {
            return 0;
        }

        public String toString() {
            return this.state.toString();
        }
    }

    private class VariationWrapper {
        @Nonnull
        private ICarvingVariation v;

        private VariationWrapper(ICarvingVariation v) {
            this.v = v;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ICarvingVariation) {
                ItemStack stack2;
                ICarvingVariation v2 = (ICarvingVariation)obj;
                ItemStack stack1 = this.v.getStack();
                if (stack1.func_77969_a(stack2 = v2.getStack()) && ItemStack.func_77970_a((ItemStack)stack1, (ItemStack)stack2)) {
                    return true;
                }
                if (this.v.getBlock() != null && this.v.getBlock() != Blocks.field_150350_a) {
                    return this.v.getBlockState().equals(v2.getBlockState());
                }
            } else if (obj instanceof VariationWrapper) {
                return this.equals(((VariationWrapper)obj).v);
            }
            return false;
        }

        public int hashCode() {
            return this.v.getStack().func_77973_b().hashCode() ^ this.v.getStack().func_77952_i();
        }
    }
}

