/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.common.util;

import com.google.common.base.Throwables;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import io.netty.buffer.ByteBuf;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.event.world.ChunkDataEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import team.chisel.Chisel;
import team.chisel.api.chunkdata.ChunkData;
import team.chisel.api.chunkdata.IChunkData;
import team.chisel.api.chunkdata.IChunkDataRegistry;
import team.chisel.common.util.NBTSaveable;

public enum PerChunkData implements IChunkDataRegistry
{
    INSTANCE;

    private Map<String, IChunkData<?>> data = Maps.newHashMap();

    private PerChunkData() {
        ChunkData.setOffsetRegistry(this);
    }

    @Override
    public void registerChunkData(String key, IChunkData<?> cd) {
        this.data.put(key, cd);
    }

    @Override
    public <T extends IChunkData<?>> T getData(String key) {
        return (T)this.data.get(key);
    }

    @SubscribeEvent
    public void onChunkSave(ChunkDataEvent.Save event) {
        for (Map.Entry<String, IChunkData<?>> e : this.data.entrySet()) {
            NBTTagCompound tag = new NBTTagCompound();
            e.getValue().writeToNBT(event.getChunk(), tag);
            event.getData().func_74782_a("chisel:" + e.getKey(), (NBTBase)tag);
        }
    }

    @SubscribeEvent
    public void onChunkLoad(ChunkDataEvent.Load event) {
        for (Map.Entry<String, IChunkData<?>> e : this.data.entrySet()) {
            NBTTagCompound tag = event.getData().func_74775_l("chisel:" + e.getKey());
            e.getValue().readFromNBT(event.getChunk(), tag);
            this.updateClient(event.getChunk(), e.getKey(), e.getValue());
        }
    }

    public void chunkModified(Chunk chunk, String key) {
        IChunkData<?> cd = this.data.get(key);
        chunk.func_177427_f(true);
        this.updateClient(chunk, key, cd);
    }

    private void updateClient(@Nonnull Chunk chunk, String key, IChunkData<?> cd) {
        if (cd.requiresClientSync()) {
            NBTTagCompound tag = new NBTTagCompound();
            cd.writeToNBT(chunk, tag);
            Chisel.network.sendToAll((IMessage)new MessageChunkData(chunk, key, tag));
        }
    }

    public static class ChunkDataBase<T extends NBTSaveable>
    implements IChunkData<T> {
        protected final Table<Integer, ChunkPos, T> data = HashBasedTable.create();
        protected final Class<? extends T> clazz;
        private final boolean needsClientSync;

        public ChunkDataBase(Class<? extends T> clazz, boolean needsClientSync) {
            this.clazz = clazz;
            this.needsClientSync = needsClientSync;
        }

        @Override
        public void writeToNBT(@Nonnull Chunk chunk, @Nonnull NBTTagCompound tag) {
            NBTSaveable t = (NBTSaveable)this.data.get((Object)chunk.func_177412_p().field_73011_w.getDimension(), (Object)chunk.func_76632_l());
            if (t != null) {
                t.write(tag);
            }
        }

        @Override
        public void readFromNBT(@Nonnull Chunk chunk, @Nonnull NBTTagCompound tag) {
            int dimID = chunk.func_177412_p().field_73011_w.getDimension();
            ChunkPos coords = chunk.func_76632_l();
            if (tag.func_82582_d()) {
                this.data.remove((Object)dimID, (Object)coords);
                return;
            }
            T t = this.getOrCreateNew(dimID, coords);
            t.read(tag);
        }

        protected T getOrCreateNew(int dimID, @Nonnull ChunkPos coords) {
            NBTSaveable t = (NBTSaveable)this.data.get((Object)dimID, (Object)coords);
            if (t == null) {
                try {
                    t = (NBTSaveable)this.clazz.newInstance();
                }
                catch (Exception e) {
                    Chisel.logger.error("Could not instantiate NBTSaveable " + this.clazz.getName() + "!");
                    Throwables.propagate((Throwable)e);
                }
            }
            this.data.put((Object)dimID, (Object)coords, (Object)t);
            return (T)t;
        }

        @Override
        public boolean requiresClientSync() {
            return this.needsClientSync;
        }

        @Override
        public T getDataForChunk(int dimID, @Nonnull ChunkPos coords) {
            return this.getOrCreateNew(dimID, coords);
        }
    }

    public static class MessageChunkDataHandler
    implements IMessageHandler<MessageChunkData, IMessage> {
        public IMessage onMessage(final MessageChunkData message, MessageContext ctx) {
            Minecraft.func_71410_x().func_152344_a(new Runnable(){

                @Override
                public void run() {
                    Chunk chunk = Chisel.proxy.getClientWorld().func_72964_e(((MessageChunkData)message).chunk.field_77276_a, ((MessageChunkData)message).chunk.field_77275_b);
                    IChunkData data = (IChunkData)INSTANCE.data.get(message.key);
                    data.readFromNBT(chunk, message.tag);
                    int x = chunk.field_76635_g << 4;
                    int z = chunk.field_76647_h << 4;
                    Chisel.proxy.getClientWorld().func_147458_c(x, 0, z, x, 255, z);
                }
            });
            return null;
        }
    }

    public static class MessageChunkData
    implements IMessage {
        private ChunkPos chunk;
        private String key;
        @Nonnull
        private NBTTagCompound tag;

        public MessageChunkData() {
        }

        public MessageChunkData(Chunk chunk, String key, @Nonnull NBTTagCompound tag) {
            this.chunk = chunk.func_76632_l();
            this.key = key;
            this.tag = tag;
        }

        public void toBytes(ByteBuf buf) {
            buf.writeInt(this.chunk.field_77276_a);
            buf.writeInt(this.chunk.field_77275_b);
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.key);
            ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.tag);
        }

        public void fromBytes(ByteBuf buf) {
            this.chunk = new ChunkPos(buf.readInt(), buf.readInt());
            this.key = ByteBufUtils.readUTF8String((ByteBuf)buf);
            this.tag = ByteBufUtils.readTag((ByteBuf)buf);
        }
    }
}

