/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.capability;

import com.enderio.core.common.util.ItemUtil;
import com.google.common.base.Predicate;
import crazypants.enderio.capability.Callback;
import crazypants.enderio.capability.Filters;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.items.IItemHandler;

public class InventorySlot
implements IItemHandler {
    private ItemStack itemStack;
    private final Predicate<ItemStack> filterIn;
    private final Predicate<ItemStack> filterOut;
    private final Callback<ItemStack> callback;
    private final int limit;

    public InventorySlot() {
        this(null, null, null, null, -1);
    }

    public InventorySlot(Callback<ItemStack> callback) {
        this(null, null, null, callback, -1);
    }

    public InventorySlot(ItemStack itemStack) {
        this(itemStack, null, null, null, -1);
    }

    public InventorySlot(ItemStack itemStack, Callback<ItemStack> callback) {
        this(itemStack, null, null, callback, -1);
    }

    public InventorySlot(Predicate<ItemStack> filterIn, Predicate<ItemStack> filterOut) {
        this(null, filterIn, filterOut, null, -1);
    }

    public InventorySlot(Predicate<ItemStack> filterIn, Predicate<ItemStack> filterOut, Callback<ItemStack> callback) {
        this(null, filterIn, filterOut, callback, -1);
    }

    public InventorySlot(int limit) {
        this(null, null, null, null, limit);
    }

    public InventorySlot(Callback<ItemStack> callback, int limit) {
        this(null, null, null, callback, limit);
    }

    public InventorySlot(ItemStack itemStack, int limit) {
        this(itemStack, null, null, null, limit);
    }

    public InventorySlot(ItemStack itemStack, Callback<ItemStack> callback, int limit) {
        this(itemStack, null, null, callback, limit);
    }

    public InventorySlot(Predicate<ItemStack> filterIn, Predicate<ItemStack> filterOut, int limit) {
        this(null, filterIn, filterOut, null, limit);
    }

    public InventorySlot(Predicate<ItemStack> filterIn, Predicate<ItemStack> filterOut, Callback<ItemStack> callback, int limit) {
        this(null, filterIn, filterOut, callback, limit);
    }

    public InventorySlot(ItemStack itemStack, Predicate<ItemStack> filterIn, Predicate<ItemStack> filterOut) {
        this(itemStack, filterIn, filterOut, null, -1);
    }

    public InventorySlot(ItemStack itemStack, Predicate<ItemStack> filterIn, Predicate<ItemStack> filterOut, Callback<ItemStack> callback) {
        this(itemStack, filterIn, filterOut, callback, -1);
    }

    public InventorySlot(ItemStack itemStack, Predicate<ItemStack> filterIn, Predicate<ItemStack> filterOut, int limit) {
        this(itemStack, filterIn, filterOut, null, limit);
    }

    public InventorySlot(ItemStack itemStack, Predicate<ItemStack> filterIn, Predicate<ItemStack> filterOut, Callback<ItemStack> callback, int limit) {
        this.itemStack = itemStack;
        this.filterIn = filterIn != null ? filterIn : Filters.ALWAYS_TRUE;
        this.filterOut = filterOut != null ? filterOut : Filters.ALWAYS_TRUE;
        this.callback = callback != null ? callback : Filters.NO_CALLBACK;
        this.limit = limit > 0 ? limit : Integer.MAX_VALUE;
    }

    public int getSlots() {
        return 1;
    }

    public ItemStack getStackInSlot(int slot) {
        return slot == 0 ? this.itemStack : null;
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        if (slot == 0 && this.filterIn.apply((Object)stack)) {
            if (this.itemStack == null) {
                int max = Math.min(this.limit, stack.func_77976_d());
                if (!simulate) {
                    this.itemStack = stack.func_77946_l();
                }
                if (stack.field_77994_a <= max) {
                    if (!simulate) {
                        this.callback.onChange(null, this.itemStack);
                    }
                    return null;
                }
                if (!simulate) {
                    this.itemStack.field_77994_a = max;
                    this.callback.onChange(null, this.itemStack);
                }
                ItemStack result = stack.func_77946_l();
                result.field_77994_a -= max;
                return result;
            }
            if (ItemUtil.areStackMergable((ItemStack)this.itemStack, (ItemStack)stack)) {
                int target = this.itemStack.field_77994_a + stack.field_77994_a;
                int max = Math.min(this.limit, stack.func_77976_d());
                if (target <= max) {
                    if (!simulate) {
                        ItemStack oldStack = this.itemStack.func_77946_l();
                        this.itemStack.field_77994_a = target;
                        this.callback.onChange(oldStack, this.itemStack);
                    }
                    return null;
                }
                if (!simulate) {
                    ItemStack oldStack = this.itemStack.func_77946_l();
                    this.itemStack.field_77994_a = max;
                    this.callback.onChange(oldStack, this.itemStack);
                }
                ItemStack result = stack.func_77946_l();
                result.field_77994_a -= max - target;
                return result;
            }
        }
        return stack;
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (slot == 0 && this.itemStack != null && this.filterOut.apply((Object)this.itemStack)) {
            ItemStack result = this.itemStack.func_77946_l();
            if (amount >= this.itemStack.field_77994_a) {
                if (!simulate) {
                    this.callback.onChange(this.itemStack, null);
                    this.itemStack = null;
                }
            } else {
                if (!simulate) {
                    ItemStack oldStack = this.itemStack.func_77946_l();
                    this.itemStack.field_77994_a -= amount;
                    this.callback.onChange(oldStack, this.itemStack);
                }
                result.field_77994_a = amount;
            }
            return result;
        }
        return null;
    }

    public void writeToNBT(NBTTagCompound tag) {
        if (this.itemStack != null) {
            this.itemStack.func_77955_b(tag);
        }
    }

    public void readFromNBT(NBTTagCompound tag) {
        this.itemStack = ItemStack.func_77949_a((NBTTagCompound)tag);
    }

    public void clear() {
        this.itemStack = null;
    }

    public void set(ItemStack stack) {
        this.itemStack = stack;
    }
}

