/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.capability;

import crazypants.enderio.machine.AbstractMachineEntity;
import crazypants.enderio.machine.IoMode;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public class ItemTools {
    @CapabilityInject(value=IItemHandler.class)
    public static Capability<IItemHandler> ITEM_HANDLER_CAPABILITY = null;
    public static final Limit NO_LIMIT = new Limit(Integer.MAX_VALUE, Integer.MAX_VALUE);

    private ItemTools() {
    }

    public static boolean doPush(IBlockAccess world, BlockPos pos) {
        boolean result = false;
        for (EnumFacing facing : EnumFacing.values()) {
            MoveResult moveResult = ItemTools.move(NO_LIMIT, world, pos, facing, pos.func_177972_a(facing), facing.func_176734_d());
            if (moveResult == MoveResult.SOURCE_EMPTY) {
                return false;
            }
            if (moveResult != MoveResult.MOVED) continue;
            result = true;
        }
        return result;
    }

    public static boolean doPull(IBlockAccess world, BlockPos pos) {
        boolean result = false;
        for (EnumFacing facing : EnumFacing.values()) {
            MoveResult moveResult = ItemTools.move(NO_LIMIT, world, pos.func_177972_a(facing), facing.func_176734_d(), pos, facing);
            if (moveResult == MoveResult.TARGET_FULL) {
                return false;
            }
            if (moveResult != MoveResult.MOVED) continue;
            result = true;
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MoveResult move(Limit limit, IBlockAccess world, BlockPos sourcePos, EnumFacing sourceFacing, BlockPos targetPos, EnumFacing targetFacing) {
        if (!limit.canWork()) {
            return MoveResult.LIMITED;
        }
        boolean movedSomething = false;
        TileEntity source = world.func_175625_s(sourcePos);
        if (source == null) return MoveResult.SOURCE_EMPTY;
        if (!source.func_145830_o() || source.func_145831_w().field_72995_K || !ItemTools.canPullFrom(source, sourceFacing)) return MoveResult.SOURCE_EMPTY;
        TileEntity target = world.func_175625_s(targetPos);
        if (target == null || !target.func_145830_o() || !ItemTools.canPutInto(target, targetFacing)) return MoveResult.TARGET_FULL;
        IItemHandler sourceHandler = ItemTools.getExternalInventory(world, sourcePos, sourceFacing);
        if (sourceHandler == null || !ItemTools.hasItems(sourceHandler)) return MoveResult.SOURCE_EMPTY;
        IItemHandler targetHandler = ItemTools.getExternalInventory(world, targetPos, targetFacing);
        if (targetHandler == null || !ItemTools.hasFreeSpace(targetHandler)) return MoveResult.TARGET_FULL;
        for (int i = 0; i < sourceHandler.getSlots(); ++i) {
            ItemStack sourceRejected;
            ItemStack targetRejected;
            ItemStack unacceptable;
            int movable;
            ItemStack removable = sourceHandler.extractItem(i, limit.getItems(), true);
            if (removable == null || removable.field_77994_a <= 0 || (movable = removable.field_77994_a - ((unacceptable = ItemHandlerHelper.insertItemStacked((IItemHandler)targetHandler, (ItemStack)removable, (boolean)true)) == null ? 0 : unacceptable.field_77994_a)) <= 0) continue;
            ItemStack removed = sourceHandler.extractItem(i, movable, false);
            if (removed != null && removed.field_77994_a > 0 && (targetRejected = ItemHandlerHelper.insertItemStacked((IItemHandler)targetHandler, (ItemStack)removed, (boolean)false)) != null && targetRejected.field_77994_a > 0 && (sourceRejected = ItemHandlerHelper.insertItemStacked((IItemHandler)sourceHandler, (ItemStack)removed, (boolean)false)) != null && sourceRejected.field_77994_a > 0) {
                EntityItem drop = new EntityItem(source.func_145831_w(), (double)sourcePos.func_177958_n() + 0.5, (double)sourcePos.func_177956_o() + 0.5, (double)sourcePos.func_177952_p() + 0.5, sourceRejected);
                source.func_145831_w().func_72838_d((Entity)drop);
            }
            movedSomething = true;
            limit.useItems(movable);
            if (limit.canWork()) continue;
            return MoveResult.MOVED;
        }
        return movedSomething ? MoveResult.MOVED : MoveResult.NO_ACTION;
    }

    public static int doInsertItem(IItemHandler inventory, ItemStack item) {
        if (inventory == null || item == null) {
            return 0;
        }
        int startSize = item.field_77994_a;
        ItemStack res = ItemHandlerHelper.insertItemStacked((IItemHandler)inventory, (ItemStack)item.func_77946_l(), (boolean)false);
        int val = res == null ? startSize : startSize - res.field_77994_a;
        return val;
    }

    public static boolean hasFreeSpace(IItemHandler handler) {
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack stack = handler.getStackInSlot(i);
            if (stack != null && stack.func_77985_e() != stack.field_77994_a < stack.func_77976_d()) continue;
            return true;
        }
        return false;
    }

    public static boolean hasItems(IItemHandler handler) {
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack stack = handler.getStackInSlot(i);
            if (stack == null || stack.field_77994_a <= 0) continue;
            return true;
        }
        return false;
    }

    public static boolean canPutInto(TileEntity tileEntity, EnumFacing facing) {
        if (tileEntity instanceof AbstractMachineEntity) {
            IoMode ioMode = ((AbstractMachineEntity)tileEntity).getIoMode(facing);
            return ioMode != IoMode.DISABLED && ioMode != IoMode.PUSH;
        }
        return true;
    }

    public static boolean canPullFrom(TileEntity tileEntity, EnumFacing facing) {
        if (tileEntity instanceof AbstractMachineEntity) {
            IoMode ioMode = ((AbstractMachineEntity)tileEntity).getIoMode(facing);
            return ioMode != IoMode.DISABLED && ioMode != IoMode.PULL;
        }
        return true;
    }

    @Nullable
    public static IItemHandler getExternalInventory(IBlockAccess world, BlockPos pos, EnumFacing face) {
        if (world == null || pos == null || face == null) {
            return null;
        }
        TileEntity te = world.func_175625_s(pos);
        if (te != null && te.hasCapability(ITEM_HANDLER_CAPABILITY, face)) {
            return (IItemHandler)te.getCapability(ITEM_HANDLER_CAPABILITY, face);
        }
        if (te instanceof ISidedInventory) {
            return new SidedInvWrapper((ISidedInventory)te, face);
        }
        if (te instanceof IInventory) {
            return new InvWrapper((IInventory)te);
        }
        return null;
    }

    public static class Limit {
        private int stacks;
        private int items;

        public Limit(int stacks, int items) {
            this.stacks = stacks;
            this.items = items;
        }

        public Limit(int items) {
            this.stacks = Integer.MAX_VALUE;
            this.items = items;
        }

        public int getStacks() {
            return this.stacks;
        }

        public int getItems() {
            return this.items;
        }

        public void useItems(int count) {
            --this.stacks;
            this.items -= count;
        }

        public boolean canWork() {
            return this.stacks > 0 && this.items > 0;
        }

        public Limit copy() {
            return new Limit(this.stacks, this.items);
        }
    }

    public static enum MoveResult {
        NO_ACTION,
        LIMITED,
        MOVED,
        TARGET_FULL,
        SOURCE_EMPTY;

    }
}

