/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit.redstone;

import com.enderio.core.common.util.BlockCoord;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import crazypants.enderio.EnderIO;
import crazypants.enderio.conduit.AbstractConduitNetwork;
import crazypants.enderio.conduit.IConduitBundle;
import crazypants.enderio.conduit.redstone.IRedstoneConduit;
import crazypants.enderio.conduit.redstone.Signal;
import crazypants.enderio.conduit.redstone.SignalSource;
import crazypants.enderio.config.Config;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class RedstoneConduitNetwork
extends AbstractConduitNetwork<IRedstoneConduit, IRedstoneConduit> {
    private final Multimap<SignalSource, Signal> signals = ArrayListMultimap.create();
    boolean updatingNetwork = false;
    private boolean networkEnabled = true;

    public RedstoneConduitNetwork() {
        super(IRedstoneConduit.class, IRedstoneConduit.class);
    }

    @Override
    public void init(IConduitBundle tile, Collection<IRedstoneConduit> connections, World world) {
        super.init(tile, connections, world);
        this.updatingNetwork = true;
        this.notifyNeigborsOfSignalUpdate();
        this.updatingNetwork = false;
    }

    @Override
    public void destroyNetwork() {
        this.updatingNetwork = true;
        for (IRedstoneConduit con : this.conduits) {
            con.setActive(false);
        }
        this.signals.clear();
        this.notifyNeigborsOfSignalUpdate();
        this.updatingNetwork = false;
        super.destroyNetwork();
    }

    @Override
    public void addConduit(IRedstoneConduit con) {
        super.addConduit(con);
        this.updateInputsFromConduit(con);
    }

    public void updateInputsFromConduit(IRedstoneConduit con) {
        BlockPos pos = con.getLocation().getBlockPos();
        this.updatingNetwork = true;
        this.notifyConduitNeighbours(con);
        this.updatingNetwork = false;
        for (EnumFacing side : EnumFacing.values()) {
            this.updateInputsForSource(con, new SignalSource(pos, side));
        }
        this.notifyNeigborsOfSignalUpdate();
        if (Config.redstoneConduitsShowState) {
            this.updateActiveState();
        }
    }

    private void updateActiveState() {
        boolean isActive = false;
        for (Signal s : this.getSignals().values()) {
            if (s.strength <= 0) continue;
            isActive = true;
            break;
        }
        for (IRedstoneConduit con : this.conduits) {
            con.setActive(isActive);
        }
    }

    private void updateInputsForSource(IRedstoneConduit con, SignalSource source) {
        this.updatingNetwork = true;
        this.signals.removeAll((Object)source);
        Set<Signal> sigs = con.getNetworkInputs(source.fromDirection);
        if (sigs != null && !sigs.isEmpty()) {
            this.signals.putAll((Object)source, sigs);
        }
        this.updatingNetwork = false;
    }

    public Multimap<SignalSource, Signal> getSignals() {
        if (this.networkEnabled) {
            return this.signals;
        }
        return ArrayListMultimap.create();
    }

    void setNetworkEnabled(boolean enabled) {
        this.networkEnabled = enabled;
    }

    public boolean isNetworkEnabled() {
        return this.networkEnabled;
    }

    @Override
    public String toString() {
        return "RedstoneConduitNetwork [signals=" + this.signalsString() + ", conduits=" + this.conduitsString() + "]";
    }

    private String conduitsString() {
        StringBuilder sb = new StringBuilder();
        for (IRedstoneConduit con : this.conduits) {
            TileEntity te = con.getBundle().getEntity();
            sb.append("<").append(te.func_174877_v().func_177958_n()).append(",").append(te.func_174877_v().func_177956_o()).append(",").append(te.func_174877_v().func_177952_p()).append(">");
        }
        return sb.toString();
    }

    String signalsString() {
        StringBuilder sb = new StringBuilder();
        for (Signal s : this.signals.values()) {
            sb.append("<");
            sb.append(s);
            sb.append(">");
        }
        return sb.toString();
    }

    public void notifyNeigborsOfSignalUpdate() {
        ArrayList conduitsCopy = new ArrayList(this.conduits);
        for (IRedstoneConduit con : conduitsCopy) {
            this.notifyConduitNeighbours(con);
        }
    }

    private void notifyConduitNeighbours(IRedstoneConduit con) {
        BlockPos bc1;
        if (con.getBundle() == null) {
            return;
        }
        TileEntity te = con.getBundle().getEntity();
        World worldObj = te.func_145831_w();
        if (!worldObj.func_175667_e(bc1 = te.func_174877_v())) {
            return;
        }
        for (EnumFacing dir : con.getExternalConnections()) {
            BlockPos bc2 = bc1.func_177972_a(dir);
            if (!worldObj.func_175667_e(bc2)) continue;
            worldObj.func_180496_d(bc2, (Block)EnderIO.blockConduitBundle);
            IBlockState bs = worldObj.func_180495_p(bc2);
            if (!bs.func_185898_k()) continue;
            for (EnumFacing dir2 : EnumFacing.field_82609_l) {
                BlockPos bc3 = bc2.func_177972_a(dir2);
                if (bc3.equals((Object)bc1) || !worldObj.func_175667_e(bc3)) continue;
                worldObj.func_180496_d(bc3, (Block)EnderIO.blockConduitBundle);
            }
        }
    }

    public void afterChunkUnload(List<IRedstoneConduit> conduits, Multimap<SignalSource, Signal> oldSignals) {
        World world = null;
        for (IRedstoneConduit c : conduits) {
            BlockCoord loc;
            if (world == null) {
                world = c.getBundle().getBundleWorldObj();
            }
            if (!world.func_175667_e((loc = c.getLocation()).getBlockPos())) continue;
            this.conduits.add(c);
            c.setNetwork(this);
        }
        this.signals.clear();
        boolean signalsChanged = false;
        for (Map.Entry s : oldSignals.entries()) {
            if (world.func_175667_e(((SignalSource)s.getKey()).getPos())) {
                this.signals.put(s.getKey(), s.getValue());
                continue;
            }
            signalsChanged = true;
        }
        if (signalsChanged) {
            this.notifyNeigborsOfSignalUpdate();
        }
    }
}

