/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.config.recipes.xml;

import crazypants.enderio.Log;
import crazypants.enderio.config.recipes.InvalidRecipeConfigException;
import crazypants.enderio.config.recipes.StaxFactory;
import crazypants.enderio.config.recipes.xml.AbstractCrafting;
import crazypants.enderio.config.recipes.xml.Grid;
import crazypants.enderio.config.recipes.xml.Shapeless;
import java.util.Arrays;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class Crafting
extends AbstractCrafting {
    private Grid grid;
    private Shapeless shapeless;

    @Override
    public Object readResolve() throws InvalidRecipeConfigException {
        block5: {
            try {
                super.readResolve();
                if (this.grid != null) {
                    if (this.shapeless != null) {
                        throw new InvalidRecipeConfigException("Cannot have both <grid> and <shapeless>");
                    }
                    this.valid = this.valid && this.grid.isValid();
                    break block5;
                }
                if (this.shapeless != null) {
                    this.valid = this.valid && this.shapeless.isValid();
                    break block5;
                }
                throw new InvalidRecipeConfigException("Missing <grid> and <shapeless>");
            }
            catch (InvalidRecipeConfigException e) {
                throw new InvalidRecipeConfigException(e, "in <crafting>");
            }
        }
        return this;
    }

    @Override
    public void enforceValidity() throws InvalidRecipeConfigException {
        super.enforceValidity();
        if (this.grid != null) {
            this.grid.enforceValidity();
        } else if (this.shapeless != null) {
            this.shapeless.enforceValidity();
        }
    }

    @Override
    public void register() {
        if (this.valid && this.active) {
            if (this.grid != null) {
                Log.debug("Registering ShapedOreRecipe: " + this.getOutput().getItemStack() + ": " + Arrays.toString(this.grid.getElements()));
                GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(this.getOutput().getItemStack(), this.grid.getElements()));
            } else {
                Log.debug("Registering ShapelessOreRecipe: " + this.getOutput().getItemStack() + ": " + Arrays.toString(this.shapeless.getElements()));
                GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(this.getOutput().getItemStack(), this.shapeless.getElements()));
            }
        } else {
            Log.debug("Skipping Crafting '" + (this.getOutput() == null ? "null" : this.getOutput().getItemStack()) + "' (valid=" + this.valid + ", active=" + this.active + ")");
        }
    }

    @Override
    public boolean setAttribute(StaxFactory factory, String name, String value) throws InvalidRecipeConfigException, XMLStreamException {
        return super.setAttribute(factory, name, value);
    }

    @Override
    public boolean setElement(StaxFactory factory, String name, StartElement startElement) throws InvalidRecipeConfigException, XMLStreamException {
        if ("grid".equals(name) && this.grid == null) {
            this.grid = factory.read(new Grid(), startElement);
            return true;
        }
        if ("shapeless".equals(name) && this.shapeless == null) {
            this.shapeless = factory.read(new Shapeless(), startElement);
            return true;
        }
        return super.setElement(factory, name, startElement);
    }
}

