/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.integration.jei;

import crazypants.enderio.EnderIO;
import crazypants.enderio.ModObject;
import crazypants.enderio.integration.jei.BaseRecipeHandler;
import crazypants.enderio.machine.IMachineRecipe;
import crazypants.enderio.machine.MachineRecipeRegistry;
import crazypants.enderio.machine.power.PowerDisplayUtil;
import crazypants.enderio.machine.soul.ContainerSoulBinder;
import crazypants.enderio.machine.soul.GuiSoulBinder;
import crazypants.enderio.machine.soul.ISoulBinderRecipe;
import crazypants.enderio.machine.soul.SoulBinderTunedPressurePlateRecipe;
import crazypants.util.CapturedMob;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.BlankRecipeCategory;
import mezz.jei.api.recipe.BlankRecipeWrapper;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeHandler;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class SoulBinderRecipeCategory
extends BlankRecipeCategory<SoulBinderRecipeWrapper> {
    @Nonnull
    public static final String UID = "SoulBinder";
    private int xOff = 34;
    private int yOff = 28;
    @Nonnull
    private final IDrawable background;
    @Nonnull
    protected final IDrawableAnimated arror;
    private SoulBinderRecipeWrapper currentRecipe;

    public static void register(IModRegistry registry, IGuiHelper guiHelper) {
        registry.addRecipeCategories(new IRecipeCategory[]{new SoulBinderRecipeCategory(guiHelper)});
        registry.addRecipeHandlers(new IRecipeHandler[]{new BaseRecipeHandler<SoulBinderRecipeWrapper>(SoulBinderRecipeWrapper.class, UID)});
        registry.addRecipeClickArea(GuiSoulBinder.class, 155, 42, 16, 16, new String[]{UID});
        registry.addRecipeCategoryCraftingItem(new ItemStack((Block)EnderIO.blockSoulFuser), new String[]{UID});
        ArrayList<SoulBinderRecipeWrapper> result = new ArrayList<SoulBinderRecipeWrapper>();
        Map<String, IMachineRecipe> recipes = MachineRecipeRegistry.instance.getRecipesForMachine(ModObject.blockSoulBinder.getUnlocalisedName());
        if (recipes.isEmpty()) {
            return;
        }
        for (IMachineRecipe recipe : recipes.values()) {
            if (!(recipe instanceof ISoulBinderRecipe)) continue;
            result.add(new SoulBinderRecipeWrapper((ISoulBinderRecipe)((Object)recipe)));
        }
        registry.addRecipes(result);
        registry.getRecipeTransferRegistry().addRecipeTransferHandler(ContainerSoulBinder.class, UID, ContainerSoulBinder.FIRST_RECIPE_SLOT, ContainerSoulBinder.NUM_RECIPE_SLOT, ContainerSoulBinder.FIRST_INVENTORY_SLOT, ContainerSoulBinder.NUM_INVENTORY_SLOT);
    }

    public SoulBinderRecipeCategory(IGuiHelper guiHelper) {
        ResourceLocation backgroundLocation = EnderIO.proxy.getGuiTexture("soulFuser");
        this.background = guiHelper.createDrawable(backgroundLocation, this.xOff, this.yOff, 120, 50);
        IDrawableStatic flameDrawable = guiHelper.createDrawable(backgroundLocation, 177, 14, 22, 16);
        this.arror = guiHelper.createAnimatedDrawable(flameDrawable, 200, IDrawableAnimated.StartDirection.LEFT, false);
    }

    @Nonnull
    public String getUid() {
        return UID;
    }

    @Nonnull
    public String getTitle() {
        String localizedName = EnderIO.blockSoulFuser.func_149732_F();
        return localizedName != null ? localizedName : "ERROR";
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    public void drawAnimations(@Nonnull Minecraft minecraft) {
        this.arror.draw(minecraft, 81 - this.xOff, 35 - this.yOff);
    }

    public void setRecipe(@Nonnull IRecipeLayout recipeLayout, @Nonnull SoulBinderRecipeWrapper recipeWrapper, @Nonnull IIngredients ingredients) {
        this.currentRecipe = recipeWrapper;
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        guiItemStacks.init(0, true, 37 - this.xOff, 33 - this.yOff);
        guiItemStacks.init(1, true, 58 - this.xOff, 33 - this.yOff);
        guiItemStacks.init(2, false, 111 - this.xOff, 33 - this.yOff);
        guiItemStacks.init(3, false, 133 - this.xOff, 33 - this.yOff);
        ItemStack outputStack = this.currentRecipe.recipe.getOutputStack();
        List<String> supportedSouls = this.currentRecipe.recipe.getSupportedSouls();
        ItemStack inputStack = this.currentRecipe.recipe.getInputStack();
        List<CapturedMob> souls = CapturedMob.getSouls(supportedSouls);
        ArrayList<ItemStack> soulStacks = new ArrayList<ItemStack>();
        for (CapturedMob soul : souls) {
            soulStacks.add(soul.toStack(EnderIO.itemSoulVessel, 1, 1));
        }
        guiItemStacks.set(0, soulStacks);
        if (inputStack != null) {
            guiItemStacks.set(1, inputStack);
        }
        if (EnderIO.itemBrokenSpawner == outputStack.func_77973_b() || this.currentRecipe.recipe instanceof SoulBinderTunedPressurePlateRecipe) {
            ArrayList<ItemStack> outputs = new ArrayList<ItemStack>();
            for (CapturedMob soul : souls) {
                outputs.add(soul.toStack(outputStack.func_77973_b(), outputStack.func_77960_j(), 1));
            }
            guiItemStacks.set(2, outputs);
        } else {
            guiItemStacks.set(2, outputStack);
        }
        guiItemStacks.set(3, new ItemStack((Item)EnderIO.itemSoulVessel));
    }

    public static class SoulBinderRecipeWrapper
    extends BlankRecipeWrapper {
        private ISoulBinderRecipe recipe;

        public SoulBinderRecipeWrapper(ISoulBinderRecipe recipe) {
            this.recipe = recipe;
        }

        public long getEnergyRequired() {
            return this.recipe.getEnergyRequired();
        }

        public void getIngredients(@Nonnull IIngredients ingredients) {
            ingredients.setInputs(ItemStack.class, Arrays.asList(new ItemStack((Item)EnderIO.itemSoulVessel), this.recipe.getInputStack()));
            ingredients.setOutputs(ItemStack.class, Arrays.asList(this.recipe.getOutputStack(), new ItemStack((Item)EnderIO.itemSoulVessel)));
        }

        public void drawInfo(@Nonnull Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
            int cost = this.recipe.getExperienceLevelsRequired();
            String str = I18n.func_135052_a((String)"container.repair.cost", (Object[])new Object[]{cost});
            minecraft.field_71466_p.func_78276_b(str, 6, 26, 8453920);
            String energyString = PowerDisplayUtil.formatPower(this.recipe.getEnergyRequired()) + " " + PowerDisplayUtil.abrevation();
            minecraft.field_71466_p.func_175065_a(energyString, 6.0f, 36.0f, 0x808080, false);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }
}

