/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.item;

import com.enderio.core.api.client.gui.IResourceTooltipProvider;
import com.enderio.core.common.util.DyeColor;
import crazypants.enderio.EnderIO;
import crazypants.enderio.EnderIOTab;
import crazypants.enderio.IHaveRenderers;
import crazypants.enderio.ModObject;
import crazypants.enderio.config.Config;
import crazypants.util.CapturedMob;
import crazypants.util.ClientUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.resources.I18n;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemSoulVessel
extends Item
implements IResourceTooltipProvider,
IHaveRenderers {
    private List<String> blackList;

    public static ItemSoulVessel create() {
        ItemSoulVessel result = new ItemSoulVessel();
        result.init();
        return result;
    }

    protected ItemSoulVessel() {
        this.func_77637_a(EnderIOTab.tabEnderIO);
        this.func_77655_b(ModObject.itemSoulVessel.getUnlocalisedName());
        this.setRegistryName(ModObject.itemSoulVessel.getUnlocalisedName());
        this.func_77625_d(64);
        this.blackList = new ArrayList<String>();
        for (String ent : Config.soulVesselBlackList) {
            this.blackList.add(ent);
        }
    }

    protected void init() {
        GameRegistry.register((IForgeRegistryEntry)this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerRenderers() {
        ClientUtil.regRenderer((Item)this, 0, "itemSoulVessel");
        ClientUtil.regRenderer((Item)this, 1, "itemSoulVesselFull");
    }

    public int getMetadata(ItemStack stack) {
        if (CapturedMob.containsSoul(stack)) {
            return 1;
        }
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack item) {
        return CapturedMob.containsSoul(item);
    }

    @Nonnull
    public EnumActionResult func_180614_a(ItemStack itemstack, EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K || player == null) {
            return EnumActionResult.PASS;
        }
        CapturedMob capturedMob = CapturedMob.create(itemstack);
        if (capturedMob == null) {
            return EnumActionResult.SUCCESS;
        }
        if (!capturedMob.spawn(world, pos, side, true)) {
            return EnumActionResult.SUCCESS;
        }
        if (!player.field_71075_bZ.field_75098_d) {
            if (itemstack.field_77994_a > 1) {
                --itemstack.field_77994_a;
                if (itemstack.field_77994_a == 0) {
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, new ItemStack((Item)this));
                } else if (!player.field_71071_by.func_70441_a(new ItemStack((Item)this))) {
                    player.field_70170_p.func_72838_d((Entity)new EntityItem(player.field_70170_p, player.field_70165_t, player.field_70163_u, player.field_70161_v, new ItemStack((Item)this)));
                }
                player.field_71069_bz.func_75142_b();
            } else {
                itemstack.func_77982_d(null);
            }
        }
        return EnumActionResult.SUCCESS;
    }

    public boolean func_111207_a(ItemStack item, EntityPlayer player, EntityLivingBase entity, EnumHand hand) {
        if (entity.field_70170_p.field_72995_K || player == null) {
            return false;
        }
        boolean isCreative = player.field_71075_bZ.field_75098_d;
        if (CapturedMob.containsSoul(item) && !isCreative) {
            return false;
        }
        CapturedMob capturedMob = CapturedMob.create((Entity)entity);
        if (capturedMob == null) {
            return false;
        }
        ItemStack capturedMobVessel = capturedMob.toStack(this, 1, 1);
        player.func_184609_a(hand);
        if (!isCreative) {
            entity.func_70106_y();
            if (entity.field_70128_L) {
                --item.field_77994_a;
                if (!player.field_71071_by.func_70441_a(capturedMobVessel)) {
                    entity.field_70170_p.func_72838_d((Entity)new EntityItem(entity.field_70170_p, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, capturedMobVessel));
                }
                player.func_184611_a(hand, item);
                ((EntityPlayerMP)player).func_71120_a(player.field_71069_bz);
                return true;
            }
        } else {
            if (!player.field_71071_by.func_70441_a(capturedMobVessel)) {
                entity.field_70170_p.func_72838_d((Entity)new EntityItem(entity.field_70170_p, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, capturedMobVessel));
            }
            ((EntityPlayerMP)player).func_71120_a(player.field_71069_bz);
            return true;
        }
        return false;
    }

    public ItemStack createVesselWithEntityStub(String entityId) {
        CapturedMob capturedMob = CapturedMob.create(entityId, null);
        if (capturedMob == null) {
            return null;
        }
        return capturedMob.toStack(this, 1, 1);
    }

    public ItemStack createVesselWithEntity(Entity entity) {
        CapturedMob capturedMob = CapturedMob.create(entity);
        if (capturedMob == null) {
            return null;
        }
        return capturedMob.toStack(this, 1, 1);
    }

    public void func_150895_a(Item itemIn, CreativeTabs tab, List<ItemStack> subItems) {
        super.func_150895_a(itemIn, tab, subItems);
        if (tab != null) {
            for (CapturedMob capturedMob : CapturedMob.getAllSouls()) {
                subItems.add(capturedMob.toStack(this, 1, 1));
            }
        }
    }

    public String getUnlocalizedNameForTooltip(ItemStack itemStack) {
        return itemStack == null ? null : this.func_77667_c(itemStack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, List<String> par3List, boolean par4) {
        CapturedMob capturedMob = CapturedMob.create(par1ItemStack);
        if (capturedMob != null) {
            DyeColor color;
            Fluid fluid;
            String fluidName;
            par3List.add(capturedMob.getDisplayName());
            float health = capturedMob.getHealth();
            if (health >= 0.0f) {
                float maxHealth = capturedMob.getMaxHealth();
                String msg = EnderIO.lang.localize("item.itemSoulVessel.tooltip.health");
                if (maxHealth >= 0.0f) {
                    par3List.add(String.format("%s %3.1f/%3.1f", msg, Float.valueOf(health), Float.valueOf(maxHealth)));
                } else {
                    par3List.add(String.format("%s %3.1f", msg, Float.valueOf(health)));
                }
            }
            if ((fluidName = capturedMob.getFluidName()) != null && (fluid = FluidRegistry.getFluid((String)fluidName)) != null) {
                String unlocalizedName = fluid.getUnlocalizedName();
                String name = unlocalizedName == null ? fluidName : I18n.func_135052_a((String)unlocalizedName, (Object[])new Object[0]);
                par3List.add(EnderIO.lang.localize("item.itemSoulVessel.tooltip.fluidname") + " " + name);
            }
            if ((color = capturedMob.getColor()) != null) {
                par3List.add(EnderIO.lang.localize("item.itemSoulVessel.tooltip.color") + " " + color.getLocalisedName());
            }
        } else {
            par3List.add(EnderIO.lang.localize("item.itemSoulVessel.tooltip.empty"));
        }
    }
}

