/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.item;

import com.enderio.core.common.Lang;
import com.enderio.core.common.util.ChatUtil;
import crazypants.enderio.EnderIO;
import crazypants.enderio.api.tool.IConduitControl;
import crazypants.enderio.conduit.ConduitDisplayMode;
import crazypants.enderio.config.Config;
import crazypants.enderio.item.ItemMagnet;
import crazypants.enderio.item.MagnetController;
import crazypants.enderio.item.PacketConduitProbeMode;
import crazypants.enderio.item.PacketMagnetState;
import crazypants.enderio.item.YetaWrenchPacketProcessor;
import crazypants.enderio.item.darksteel.DarkSteelController;
import crazypants.enderio.item.darksteel.PacketUpgradeState;
import crazypants.enderio.item.darksteel.SoundDetector;
import crazypants.enderio.item.darksteel.upgrade.JumpUpgrade;
import crazypants.enderio.item.darksteel.upgrade.SoundDetectorUpgrade;
import crazypants.enderio.item.darksteel.upgrade.SpeedUpgrade;
import crazypants.enderio.network.PacketHandler;
import crazypants.enderio.sound.IModSound;
import crazypants.enderio.sound.SoundHelper;
import crazypants.enderio.sound.SoundRegistry;
import crazypants.util.BaublesUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.multiplayer.PlayerControllerMP;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.apache.commons.lang3.tuple.Pair;

public class KeyTracker {
    public static final KeyTracker instance = new KeyTracker();
    private final List<Pair<KeyBinding, Action>> keyActions = new ArrayList<Pair<KeyBinding, Action>>();
    private final KeyBinding fovPlusKeyFast;
    private final KeyBinding fovMinusKeyFast;
    private final KeyBinding fovPlusKey;
    private final KeyBinding fovMinusKey;
    private final KeyBinding yetaWrenchMode;
    private double fovLevelLast = 1.0;
    private double fovLevelNext = 1.0;
    private long lastWorldTime = 0L;

    public KeyTracker() {
        this.create("enderio.keybind.glidertoggle      ", 34, "   enderio.category.darksteelarmor", new GlideAction());
        this.create("enderio.keybind.soundlocator      ", 38, "   enderio.category.darksteelarmor", new SoundDetectorAction());
        this.create("enderio.keybind.nightvision       ", 25, "   enderio.category.darksteelarmor", new NightVisionAction());
        this.create("enderio.keybind.gogglesofrevealing", 0, "enderio.category.darksteelarmor", new GogglesAction());
        this.create("enderio.keybind.stepassist        ", 0, "enderio.category.darksteelarmor", new StepAssistAction());
        this.create("enderio.keybind.speed             ", 0, "enderio.category.darksteelarmor", new SpeedAction());
        this.create("enderio.keybind.jump              ", 0, "enderio.category.darksteelarmor", new JumpAction());
        this.create("enderio.keybind.top               ", 0, "enderio.category.darksteelarmor", new TopAction());
        this.yetaWrenchMode = this.create("enderio.keybind.yetawrenchmode    ", 21, "   enderio.category.tools         ", new YetaWrenchAction());
        this.create("enderio.keybind.magnet            ", 0, "enderio.category.tools         ", new MagnetAction());
        this.create("enderio.keybind.fovreset          ", 0, "key.categories.misc            ", new FovAction());
        this.fovPlusKey = this.create("     enderio.keybind.fovplus     ", 0, "key.categories.misc");
        this.fovMinusKey = this.create("    enderio.keybind.fovminus    ", 0, "key.categories.misc");
        this.fovPlusKeyFast = this.create(" enderio.keybind.fovplusfast ", 0, "key.categories.misc");
        this.fovMinusKeyFast = this.create("enderio.keybind.fovminusfast", 0, "key.categories.misc");
    }

    private KeyBinding create(@Nonnull String description, int keyCode, @Nonnull String category, @Nonnull Action action) {
        KeyBinding keyBinding = this.create(description, keyCode, category);
        this.keyActions.add((Pair<KeyBinding, Action>)Pair.of((Object)keyBinding, (Object)action));
        return keyBinding;
    }

    private KeyBinding create(@Nonnull String description, int keyCode, @Nonnull String category) {
        KeyBinding keyBinding = new KeyBinding(description.trim(), keyCode, category.trim());
        ClientRegistry.registerKeyBinding((KeyBinding)keyBinding);
        return keyBinding;
    }

    @SubscribeEvent
    public void onKeyInput(InputEvent.KeyInputEvent event) {
        for (Pair<KeyBinding, Action> keyAction : this.keyActions) {
            if (!((KeyBinding)keyAction.getKey()).func_151468_f()) continue;
            ((Action)keyAction.getValue()).execute();
        }
        if (!KeyTracker.isSoundDetectorUpgradeEquipped(Minecraft.func_71410_x().field_71439_g)) {
            SoundDetector.instance.setEnabled(false);
        }
    }

    private static void sendEnabledChatMessage(String messageBase, boolean isActive) {
        String message = messageBase.concat(isActive ? ".enabled" : ".disabled");
        ChatUtil.sendNoSpamClientUnloc((Lang)EnderIO.lang, (String[])new String[]{message});
    }

    private static void toggleDarkSteelController(PacketUpgradeState.Type type, String messageBase) {
        boolean isActive = !DarkSteelController.instance.isActive((EntityPlayer)Minecraft.func_71410_x().field_71439_g, type);
        KeyTracker.sendEnabledChatMessage(messageBase, isActive);
        DarkSteelController.instance.setActive((EntityPlayer)Minecraft.func_71410_x().field_71439_g, type, isActive);
        PacketHandler.INSTANCE.sendToServer((IMessage)new PacketUpgradeState(type, isActive));
    }

    public static boolean isSoundDetectorUpgradeEquipped(EntityPlayerSP player) {
        ItemStack helmet = player.func_184582_a(EntityEquipmentSlot.HEAD);
        SoundDetectorUpgrade upgrade = SoundDetectorUpgrade.loadFromItem(helmet);
        return upgrade != null;
    }

    @SubscribeEvent
    public void onFov(EntityViewRenderEvent.FOVModifier event) {
        PlayerControllerMP playerController = Minecraft.func_71410_x().field_71442_b;
        if (!Config.allowFovControlsInSurvivalMode && (playerController == null || playerController.func_78763_f())) {
            return;
        }
        long worldTime = EnderIO.proxy.getTickCount();
        while (worldTime > this.lastWorldTime) {
            this.lastWorldTime = worldTime - this.lastWorldTime > 10L ? worldTime : ++this.lastWorldTime;
            this.fovLevelLast = this.fovLevelNext;
            if (this.fovPlusKeyFast.func_151470_d()) {
                this.fovLevelNext *= 1.05;
            } else if (this.fovMinusKeyFast.func_151470_d()) {
                this.fovLevelNext /= 1.05;
            } else if (this.fovPlusKey.func_151470_d()) {
                this.fovLevelNext *= 1.01;
            } else if (this.fovMinusKey.func_151470_d()) {
                this.fovLevelNext /= 1.01;
            }
            if (this.fovLevelNext > 1.3) {
                this.fovLevelNext = 1.3;
                continue;
            }
            if (!(this.fovLevelNext < 0.05)) continue;
            this.fovLevelNext = 0.05;
        }
        double val = this.fovLevelNext * event.getRenderPartialTicks() + this.fovLevelLast * (1.0 - event.getRenderPartialTicks());
        event.setFOV((float)((double)event.getFOV() * val));
    }

    public KeyBinding getYetaWrenchMode() {
        return this.yetaWrenchMode;
    }

    private class FovAction
    implements Action {
        private FovAction() {
        }

        @Override
        public void execute() {
            KeyTracker.this.fovLevelLast = (KeyTracker.this.fovLevelNext = 1.0);
        }
    }

    private static class TopAction
    implements Action {
        private TopAction() {
        }

        @Override
        public void execute() {
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            if (DarkSteelController.instance.isTopUpgradeEquipped((EntityPlayer)player)) {
                boolean isActive = !DarkSteelController.instance.isTopActive((EntityPlayer)player);
                DarkSteelController.instance.setTopActive((EntityPlayer)player, isActive);
            }
        }
    }

    private static class NightVisionAction
    implements Action {
        private NightVisionAction() {
        }

        @Override
        public void execute() {
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            if (DarkSteelController.instance.isNightVisionUpgradeEquipped((EntityPlayer)player)) {
                boolean isActive;
                boolean bl = isActive = !DarkSteelController.instance.isNightVisionActive();
                if (isActive) {
                    SoundHelper.playSound(player.field_70170_p, (Entity)player, (IModSound)SoundRegistry.NIGHTVISION_ON, 0.1f, player.field_70170_p.field_73012_v.nextFloat() * 0.4f - 0.2f + 1.0f);
                } else {
                    SoundHelper.playSound(player.field_70170_p, (Entity)player, (IModSound)SoundRegistry.NIGHTVISION_OFF, 0.1f, 1.0f);
                }
                DarkSteelController.instance.setNightVisionActive(isActive);
            }
        }
    }

    private static class GlideAction
    implements Action {
        private GlideAction() {
        }

        @Override
        public void execute() {
            if (DarkSteelController.instance.isGliderUpgradeEquipped((EntityPlayer)Minecraft.func_71410_x().field_71439_g)) {
                KeyTracker.toggleDarkSteelController(PacketUpgradeState.Type.GLIDE, "darksteel.upgrade.glider");
            } else if (DarkSteelController.instance.isElytraUpgradeEquipped((EntityPlayer)Minecraft.func_71410_x().field_71439_g)) {
                KeyTracker.toggleDarkSteelController(PacketUpgradeState.Type.ELYTRA, "darksteel.upgrade.elytra");
            }
        }
    }

    private static class SoundDetectorAction
    implements Action {
        private SoundDetectorAction() {
        }

        @Override
        public void execute() {
            if (KeyTracker.isSoundDetectorUpgradeEquipped(Minecraft.func_71410_x().field_71439_g)) {
                boolean isActive = !SoundDetector.instance.isEnabled();
                KeyTracker.sendEnabledChatMessage("darksteel.upgrade.sound", isActive);
                SoundDetector.instance.setEnabled(isActive);
            }
        }
    }

    private static class YetaWrenchAction
    implements Action {
        private YetaWrenchAction() {
        }

        @Override
        public void execute() {
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            ItemStack equipped = player.func_184614_ca();
            if (equipped == null) {
                return;
            }
            if (equipped.func_77973_b() instanceof IConduitControl) {
                ConduitDisplayMode curMode = ConduitDisplayMode.getDisplayMode(equipped);
                if (curMode == null) {
                    curMode = ConduitDisplayMode.ALL;
                }
                ConduitDisplayMode newMode = player.func_70093_af() ? curMode.previous() : curMode.next();
                ConduitDisplayMode.setDisplayMode(equipped, newMode);
                PacketHandler.INSTANCE.sendToServer((IMessage)new YetaWrenchPacketProcessor(player.field_71071_by.field_70461_c, newMode));
            } else if (equipped.func_77973_b() == EnderIO.itemConduitProbe) {
                int newMeta = equipped.func_77952_i() == 0 ? 1 : 0;
                equipped.func_77964_b(newMeta);
                PacketHandler.INSTANCE.sendToServer((IMessage)new PacketConduitProbeMode());
                player.func_184609_a(EnumHand.MAIN_HAND);
            }
        }
    }

    private static class GogglesAction
    implements Action {
        private GogglesAction() {
        }

        @Override
        public void execute() {
        }
    }

    private static class StepAssistAction
    implements Action {
        private StepAssistAction() {
        }

        @Override
        public void execute() {
            if (JumpUpgrade.isEquipped((EntityPlayer)Minecraft.func_71410_x().field_71439_g)) {
                KeyTracker.toggleDarkSteelController(PacketUpgradeState.Type.STEP_ASSIST, "darksteel.upgrade.stepAssist");
            }
        }
    }

    private static class SpeedAction
    implements Action {
        private SpeedAction() {
        }

        @Override
        public void execute() {
            if (SpeedUpgrade.isEquipped((EntityPlayer)Minecraft.func_71410_x().field_71439_g)) {
                KeyTracker.toggleDarkSteelController(PacketUpgradeState.Type.SPEED, "darksteel.upgrade.speed");
            }
        }
    }

    private static class JumpAction
    implements Action {
        private JumpAction() {
        }

        @Override
        public void execute() {
            if (JumpUpgrade.isEquipped((EntityPlayer)Minecraft.func_71410_x().field_71439_g)) {
                KeyTracker.toggleDarkSteelController(PacketUpgradeState.Type.JUMP, "darksteel.upgrade.jump");
            }
        }
    }

    private static class MagnetAction
    implements Action {
        private MagnetAction() {
        }

        @Override
        public void execute() {
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            MagnetController.ActiveMagnet magnet = MagnetController.getMagnet((EntityPlayer)player, false);
            if (magnet != null) {
                boolean isActive = !ItemMagnet.isActive(magnet.item);
                PacketHandler.INSTANCE.sendToServer((IMessage)new PacketMagnetState(PacketMagnetState.SlotType.INVENTORY, magnet.slot, isActive));
                return;
            }
            IInventory baubles = BaublesUtil.instance().getBaubles((EntityPlayer)player);
            if (baubles != null) {
                for (int i = 0; i < baubles.func_70302_i_(); ++i) {
                    ItemStack stack = baubles.func_70301_a(i);
                    if (!ItemMagnet.isMagnet(stack)) continue;
                    boolean isActive = !ItemMagnet.isActive(stack);
                    PacketHandler.INSTANCE.sendToServer((IMessage)new PacketMagnetState(PacketMagnetState.SlotType.BAUBLES, i, isActive));
                    return;
                }
            }
        }
    }

    private static interface Action {
        public void execute();
    }
}

