/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.item.darksteel;

import com.enderio.core.api.client.gui.IAdvancedTooltipProvider;
import com.enderio.core.common.transform.EnderCoreMethods;
import com.enderio.core.common.util.ItemUtil;
import com.enderio.core.common.util.OreDictionaryHelper;
import crazypants.enderio.EnderIOTab;
import crazypants.enderio.config.Config;
import crazypants.enderio.item.PowerBarOverlayRenderHelper;
import crazypants.enderio.item.darksteel.DarkSteelRecipeManager;
import crazypants.enderio.item.darksteel.IDarkSteelItem;
import crazypants.enderio.item.darksteel.upgrade.EnergyUpgrade;
import crazypants.enderio.material.Material;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArrow;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import net.minecraftforge.client.event.FOVUpdateEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemDarkSteelBow
extends ItemBow
implements IDarkSteelItem,
IAdvancedTooltipProvider,
EnderCoreMethods.IOverlayRenderAware {
    public static final String NAME = "darkSteelBow";
    private float damageBonus = Config.darkSteelBowDamageBonus;

    public static ItemDarkSteelBow create() {
        ItemDarkSteelBow res = new ItemDarkSteelBow();
        res.init();
        MinecraftForge.EVENT_BUS.register((Object)res);
        return res;
    }

    protected ItemDarkSteelBow() {
        this.func_77655_b(NAME);
        this.setRegistryName(NAME);
        this.func_77637_a(EnderIOTab.tabEnderIO);
        this.func_77656_e(300);
        this.func_77627_a(false);
        this.func_185043_a(new ResourceLocation("pull"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
                return ItemDarkSteelBow.this.updatePullProperty(stack, worldIn, entityIn);
            }
        });
        this.func_185043_a(new ResourceLocation("pulling"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
                return ItemDarkSteelBow.this.updatePullingProperty(stack, entityIn);
            }
        });
    }

    private float updatePullProperty(ItemStack stack, World worldIn, EntityLivingBase entityIn) {
        if (stack == null || stack.func_77973_b().getClass() != this.getClass()) {
            return 0.0f;
        }
        float res = (float)(stack.func_77988_m() - entityIn.func_184605_cv()) / (float)this.getDrawTime(stack);
        return res;
    }

    private float updatePullingProperty(ItemStack stack, EntityLivingBase entityIn) {
        float res = entityIn != null && entityIn.func_184587_cr() && entityIn.func_184607_cu() == stack ? 1.0f : 0.0f;
        return res;
    }

    protected void init() {
        GameRegistry.register((IForgeRegistryEntry)this);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs par2CreativeTabs, List<ItemStack> par3List) {
        ItemStack is = new ItemStack((Item)this);
        par3List.add(is);
        is = new ItemStack((Item)this);
        EnergyUpgrade.EMPOWERED_FOUR.writeToItem(is);
        EnergyUpgrade.setPowerFull(is);
        par3List.add(is);
    }

    public void func_77615_a(ItemStack stack, World worldIn, EntityLivingBase entityLiving, int timeLeft) {
        if (!(entityLiving instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer entityplayer = (EntityPlayer)entityLiving;
        boolean hasInfinateArrows = entityplayer.field_71075_bZ.field_75098_d || EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185312_x, (ItemStack)stack) > 0;
        ItemStack itemstack = this.getArrowsToShoot(entityplayer);
        int draw = this.func_77626_a(stack) - timeLeft;
        if ((draw = ForgeEventFactory.onArrowLoose((ItemStack)stack, (World)worldIn, (EntityPlayer)((EntityPlayer)entityLiving), (int)draw, (itemstack != null || hasInfinateArrows ? 1 : 0) != 0)) < 0) {
            return;
        }
        if (itemstack == null && hasInfinateArrows) {
            itemstack = new ItemStack(Items.field_151032_g);
        }
        if (itemstack == null) {
            return;
        }
        float drawRatio = this.getCustumArrowVelocity(stack, draw);
        if ((double)drawRatio >= 0.1) {
            boolean arrowIsInfinite;
            boolean bl = arrowIsInfinite = hasInfinateArrows && itemstack.func_77973_b() instanceof ItemArrow;
            if (!worldIn.field_72995_K) {
                int knockBack;
                int powerLevel;
                EnergyUpgrade upgrade = EnergyUpgrade.loadFromItem(stack);
                ItemArrow itemarrow = (ItemArrow)(itemstack.func_77973_b() instanceof ItemArrow ? itemstack.func_77973_b() : Items.field_151032_g);
                EntityArrow entityarrow = itemarrow.func_185052_a(worldIn, itemstack, (EntityLivingBase)entityplayer);
                entityarrow.func_184547_a((Entity)entityplayer, entityplayer.field_70125_A, entityplayer.field_70177_z, 0.0f, drawRatio * 3.0f * this.getForceMultiplier(upgrade), 0.25f);
                if (drawRatio == 1.0f) {
                    entityarrow.func_70243_d(true);
                }
                if ((powerLevel = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185309_u, (ItemStack)stack)) > 0) {
                    entityarrow.func_70239_b(entityarrow.func_70242_d() + (double)powerLevel * 0.5 + 0.5);
                }
                if ((knockBack = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185310_v, (ItemStack)stack)) > 0) {
                    entityarrow.func_70240_a(knockBack);
                }
                if (EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185311_w, (ItemStack)stack) > 0) {
                    entityarrow.func_70015_d(100);
                }
                stack.func_77972_a(1, (EntityLivingBase)entityplayer);
                if (arrowIsInfinite) {
                    entityarrow.field_70251_a = EntityArrow.PickupStatus.CREATIVE_ONLY;
                }
                entityarrow.func_70239_b(entityarrow.func_70242_d() + (double)this.damageBonus);
                worldIn.func_72838_d((Entity)entityarrow);
                int used = this.getRequiredPower(draw, upgrade);
                if (used > 0) {
                    upgrade.setEnergy(upgrade.getEnergy() - used);
                    upgrade.writeToItem(stack);
                }
            }
            worldIn.func_184148_a((EntityPlayer)null, entityplayer.field_70165_t, entityplayer.field_70163_u, entityplayer.field_70161_v, SoundEvents.field_187737_v, SoundCategory.NEUTRAL, 1.0f, 1.0f / (field_77697_d.nextFloat() * 0.4f + 1.2f) + drawRatio * 0.5f);
            if (!arrowIsInfinite) {
                --itemstack.field_77994_a;
                if (itemstack.field_77994_a == 0) {
                    entityplayer.field_71071_by.func_184437_d(itemstack);
                }
            }
            entityplayer.func_71029_a(StatList.func_188057_b((Item)this));
        }
    }

    private int getRequiredPower(int drawDuration, EnergyUpgrade upgrade) {
        if (upgrade == null || drawDuration <= 0) {
            return 0;
        }
        int drawTime = this.getDrawTime(upgrade);
        float ratio = Math.min(1.0f, (float)drawDuration / (float)drawTime);
        int powerRequired = (int)Math.ceil((float)Config.darkSteelBowPowerUsePerDraw * ratio);
        if (drawDuration > drawTime) {
            powerRequired += (drawDuration - drawTime) * Config.darkSteelBowPowerUsePerTickDrawn;
        }
        return powerRequired;
    }

    public int getRequiredPower(EntityLivingBase entity, EnergyUpgrade upgrade, ItemStack stack, int drawTime) {
        int powerRequired = 0;
        if (upgrade == null) {
            return powerRequired;
        }
        int drawDuration = this.func_77626_a(stack) - entity.func_184605_cv();
        float ratio = Math.min(1.0f, (float)drawDuration / (float)drawTime);
        powerRequired = (int)Math.ceil((float)Config.darkSteelBowPowerUsePerDraw * ratio);
        if (drawDuration > drawTime) {
            powerRequired += (drawDuration - drawTime) * Config.darkSteelBowPowerUsePerTickDrawn;
        }
        return powerRequired;
    }

    public float getCustumArrowVelocity(ItemStack stack, int charge) {
        float f = (float)charge / (float)this.getDrawTime(stack);
        if ((f = (f * f + f * 2.0f) / 3.0f) > 1.0f) {
            f = 1.0f;
        }
        return f;
    }

    private ItemStack getArrowsToShoot(EntityPlayer player) {
        if (this.func_185058_h_(player.func_184586_b(EnumHand.OFF_HAND))) {
            return player.func_184586_b(EnumHand.OFF_HAND);
        }
        if (this.func_185058_h_(player.func_184586_b(EnumHand.MAIN_HAND))) {
            return player.func_184586_b(EnumHand.MAIN_HAND);
        }
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack itemstack = player.field_71071_by.func_70301_a(i);
            if (!this.func_185058_h_(itemstack)) continue;
            return itemstack;
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onFovUpdateEvent(FOVUpdateEvent fovEvt) {
        ItemStack currentItem = fovEvt.getEntity().func_184614_ca();
        if (currentItem == null || currentItem.func_77973_b() != this || fovEvt.getEntity().func_184605_cv() <= 0) {
            return;
        }
        int drawDuration = this.func_77626_a(currentItem) - fovEvt.getEntity().func_184605_cv();
        float ratio = (float)drawDuration / (float)this.getDrawTime(currentItem);
        ratio = ratio > 1.0f ? 1.0f : (ratio *= ratio);
        float mult = (float)Config.darkSteelBowFovMultipliers[0];
        EnergyUpgrade upgrade = EnergyUpgrade.loadFromItem(currentItem);
        if (upgrade != null && upgrade.getEnergy() > 0) {
            mult = (float)Config.darkSteelBowFovMultipliers[upgrade.getLevel() + 1];
        }
        fovEvt.setNewfov(1.0f - ratio * mult);
    }

    public int getDrawTime(ItemStack stack) {
        return this.getDrawTime(EnergyUpgrade.loadFromItem(stack));
    }

    public int getDrawTime(EnergyUpgrade upgrade) {
        if (upgrade == null) {
            return Config.darkSteelBowDrawSpeeds[0];
        }
        if (upgrade.getEnergy() >= Config.darkSteelBowPowerUsePerDraw) {
            return Config.darkSteelBowDrawSpeeds[upgrade.getLevel() + 1];
        }
        return Config.darkSteelBowDrawSpeeds[0];
    }

    private float getForceMultiplier(EnergyUpgrade upgrade) {
        float res = (float)Config.darkSteelBowForceMultipliers[0];
        if (upgrade != null && upgrade.getEnergy() >= 0) {
            res = (float)Config.darkSteelBowForceMultipliers[upgrade.getLevel() + 1];
        }
        return res;
    }

    public void setDamage(ItemStack stack, int newDamage) {
        int oldDamage = this.getDamage(stack);
        if (newDamage <= oldDamage) {
            super.setDamage(stack, newDamage);
        } else {
            int damage = newDamage - oldDamage;
            if (!this.absorbDamageWithEnergy(stack, damage * Config.darkSteelBowPowerUsePerDamagePoint)) {
                super.setDamage(stack, newDamage);
            }
        }
    }

    private boolean absorbDamageWithEnergy(ItemStack stack, int amount) {
        EnergyUpgrade eu = EnergyUpgrade.loadFromItem(stack);
        if (eu != null && eu.isAbsorbDamageWithPower() && eu.getEnergy() > 0) {
            eu.extractEnergy(amount, false);
            eu.writeToItem(stack);
            return true;
        }
        return false;
    }

    public int func_77626_a(ItemStack p_77626_1_) {
        return 72000;
    }

    public EnumAction func_77661_b(ItemStack p_77661_1_) {
        return EnumAction.BOW;
    }

    public int func_77619_b() {
        return 1;
    }

    @Override
    public int getIngotsRequiredForFullRepair() {
        return 2;
    }

    @Override
    public boolean isItemForRepair(ItemStack right) {
        return OreDictionaryHelper.hasName((ItemStack)right, (String)Material.NUTRITIOUS_STICK.oreDict);
    }

    @Override
    public String getItemName() {
        return NAME;
    }

    public void renderItemOverlayIntoGUI(ItemStack stack, int xPosition, int yPosition) {
        PowerBarOverlayRenderHelper.instance_upgradeable.render(stack, xPosition, yPosition);
    }

    public void addCommonEntries(ItemStack itemstack, EntityPlayer entityplayer, List<String> list, boolean flag) {
        DarkSteelRecipeManager.instance.addCommonTooltipEntries(itemstack, entityplayer, list, flag);
    }

    public void addBasicEntries(ItemStack itemstack, EntityPlayer entityplayer, List<String> list, boolean flag) {
        DarkSteelRecipeManager.instance.addBasicTooltipEntries(itemstack, entityplayer, list, flag);
    }

    public void addDetailedEntries(ItemStack itemstack, EntityPlayer entityplayer, List<String> list, boolean flag) {
        String str;
        if (!Config.addDurabilityTootip) {
            list.add(ItemUtil.getDurabilityString((ItemStack)itemstack));
        }
        if ((str = EnergyUpgrade.getStoredEnergyString(itemstack)) != null) {
            list.add(str);
        }
        DarkSteelRecipeManager.instance.addAdvancedTooltipEntries(itemstack, entityplayer, list, flag);
    }
}

