/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.enchanter;

import crazypants.enderio.config.Config;
import crazypants.enderio.machine.recipe.RecipeInput;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.item.ItemStack;

public class EnchanterRecipe {
    private final RecipeInput input;
    private final Enchantment enchantment;
    private final int stackSizePerLevel;
    private final double costMultiplier;

    public EnchanterRecipe(RecipeInput curInput, String enchantmentName) {
        this(curInput, Enchantment.func_180305_b((String)enchantmentName), 1.0);
    }

    public EnchanterRecipe(RecipeInput input, Enchantment enchantment, double costMultiplier) {
        this.input = input;
        this.enchantment = enchantment;
        this.stackSizePerLevel = input.getInput().field_77994_a;
        this.costMultiplier = costMultiplier;
    }

    public boolean isInput(ItemStack stack) {
        if (stack == null || !this.isValid()) {
            return false;
        }
        return this.input.isInput(stack);
    }

    public boolean isValid() {
        return this.enchantment != null && this.input != null && this.input.getInput() != null;
    }

    public Enchantment getEnchantment() {
        return this.enchantment;
    }

    public RecipeInput getInput() {
        return this.input;
    }

    public int getLevelForStackSize(int size) {
        return Math.min(size / this.stackSizePerLevel, this.enchantment.func_77325_b());
    }

    public int getItemsPerLevel() {
        return this.stackSizePerLevel;
    }

    public int getCostForLevel(int level) {
        level = Math.min(level, this.enchantment.func_77325_b());
        int cost = this.getRawCostForLevel(level);
        if (level < this.enchantment.func_77325_b()) {
            int nextCost = this.getRawCostForLevel(level + 1);
            cost = Math.max(nextCost / 2, cost);
        }
        return cost;
    }

    private int getRawCostForLevel(int level) {
        double min = Math.max(1, this.enchantment.func_77321_a(level));
        int cost = (int)Math.round((min *= this.costMultiplier) * Config.enchanterLevelCostFactor);
        return cost += Config.enchanterBaseLevelCost;
    }

    public int getLapizForLevel(int level) {
        int res = this.enchantment.func_77325_b() == 1 ? 5 : level;
        return (int)Math.max(1L, Math.round((double)res * Config.enchanterLapisCostFactor));
    }

    public int getLapizForStackSize(int stackSize) {
        return this.getLapizForLevel(this.getLevelForStackSize(stackSize));
    }
}

