/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.farm.farmers;

import com.enderio.core.common.util.BlockCoord;
import crazypants.enderio.machine.farm.FarmNotification;
import crazypants.enderio.machine.farm.FarmStationContainer;
import crazypants.enderio.machine.farm.TileFarmStation;
import crazypants.enderio.machine.farm.farmers.HarvestResult;
import crazypants.enderio.machine.farm.farmers.IFarmerJoe;
import crazypants.enderio.machine.farm.farmers.IHarvestResult;
import crazypants.util.Things;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;

public class FlowerPicker
implements IFarmerJoe {
    protected Things flowers = new Things(new String[0]);

    public FlowerPicker(Things flowers) {
        this.add(flowers);
    }

    public FlowerPicker add(Things flowers) {
        this.flowers.add(flowers);
        FarmStationContainer.slotItemsProduce.addAll(flowers.getItemStacks());
        return this;
    }

    @Override
    public boolean prepareBlock(TileFarmStation farm, BlockCoord bc, Block block, IBlockState meta) {
        return false;
    }

    @Override
    public boolean canHarvest(TileFarmStation farm, BlockCoord bc, Block block, IBlockState meta) {
        return this.flowers.contains(block) || block instanceof IShearable;
    }

    @Override
    public boolean canPlant(ItemStack stack) {
        return false;
    }

    @Override
    public IHarvestResult harvestBlock(TileFarmStation farm, BlockCoord bc, Block block, IBlockState meta) {
        World worldObj = farm.func_145831_w();
        List drops = null;
        if (block instanceof IShearable) {
            if (!farm.hasShears()) {
                farm.setNotification(FarmNotification.NO_SHEARS);
                return null;
            }
            ItemStack shears = farm.getTool(TileFarmStation.ToolType.SHEARS);
            if (!((IShearable)block).isShearable(shears, (IBlockAccess)worldObj, bc.getBlockPos())) {
                return null;
            }
            drops = ((IShearable)block).onSheared(shears, (IBlockAccess)worldObj, bc.getBlockPos(), farm.getMaxLootingValue());
            farm.damageShears(block, bc);
        } else {
            if (!farm.hasHoe()) {
                farm.setNotification(FarmNotification.NO_HOE);
                return null;
            }
            drops = block.getDrops((IBlockAccess)worldObj, bc.getBlockPos(), meta, farm.getMaxLootingValue());
            farm.damageHoe(1, bc);
        }
        farm.actionPerformed(false);
        ArrayList<EntityItem> result = new ArrayList<EntityItem>();
        if (drops != null) {
            for (ItemStack stack : drops) {
                result.add(new EntityItem(worldObj, (double)bc.x + 0.5, (double)bc.y + 0.5, (double)bc.z + 0.5, stack.func_77946_l()));
            }
        }
        worldObj.func_175698_g(bc.getBlockPos());
        return new HarvestResult(result, bc.getBlockPos());
    }
}

