/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.farm.farmers;

import com.enderio.core.common.util.BlockCoord;
import crazypants.enderio.machine.farm.TileFarmStation;
import crazypants.enderio.machine.farm.farmers.FarmersCommune;
import crazypants.enderio.machine.farm.farmers.IFarmerJoe;
import crazypants.enderio.machine.farm.farmers.IHarvestResult;
import forestry.api.arboriculture.EnumGermlingType;
import forestry.api.arboriculture.ITree;
import forestry.api.arboriculture.ITreeRoot;
import forestry.api.genetics.AlleleManager;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;

public class ForestryFarmer
implements IFarmerJoe {
    private ITreeRoot root;

    private ForestryFarmer(ITreeRoot root) {
        this.root = root;
    }

    public static void init() {
        ITreeRoot root = (ITreeRoot)AlleleManager.alleleRegistry.getSpeciesRoot("rootTrees");
        if (root != null) {
            FarmersCommune.joinCommune(new ForestryFarmer(root));
        }
    }

    @Override
    public boolean canPlant(ItemStack stack) {
        return this.root.getType(stack) == EnumGermlingType.SAPLING;
    }

    @Override
    public boolean prepareBlock(TileFarmStation farm, BlockCoord bc, Block block, IBlockState state) {
        ItemStack sapling = farm.getSeedTypeInSuppliesFor(bc);
        ITree tree = this.root.getMember(sapling);
        if (tree != null && tree.canStay((IBlockAccess)farm.func_145831_w(), bc.getBlockPos())) {
            farm.takeSeedFromSupplies(sapling, bc, false);
            this.root.plantSapling(farm.func_145831_w(), tree, farm.getFakePlayer().func_146103_bH(), bc.getBlockPos());
            return true;
        }
        return false;
    }

    @Override
    public boolean canHarvest(TileFarmStation farm, BlockCoord bc, Block block, IBlockState state) {
        return false;
    }

    @Override
    public IHarvestResult harvestBlock(TileFarmStation farm, BlockCoord bc, Block block, IBlockState state) {
        return null;
    }
}

