/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.monitor;

import com.enderio.core.api.client.gui.IAdvancedTooltipProvider;
import com.enderio.core.client.handlers.SpecialTooltipHandler;
import com.enderio.core.common.TileEntityBase;
import crazypants.enderio.IModObject;
import crazypants.enderio.ModObject;
import crazypants.enderio.machine.AbstractMachineBlock;
import crazypants.enderio.machine.monitor.ContainerPowerMonitor;
import crazypants.enderio.machine.monitor.GuiPowerMonitor;
import crazypants.enderio.machine.monitor.PacketPowerMonitorConfig;
import crazypants.enderio.machine.monitor.PacketPowerMonitorGraph;
import crazypants.enderio.machine.monitor.PacketPowerMonitorStatData;
import crazypants.enderio.machine.monitor.TilePowerMonitor;
import crazypants.enderio.network.PacketHandler;
import crazypants.enderio.paint.IPaintable;
import crazypants.enderio.render.IBlockStateWrapper;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockPowerMonitor
extends AbstractMachineBlock<TilePowerMonitor>
implements IAdvancedTooltipProvider,
IPaintable.ISolidBlockPaintableBlock,
IPaintable.IWrenchHideablePaint {
    public static BlockPowerMonitor advancedInstance;

    public static BlockPowerMonitor createAdvancedPowerMonitor() {
        PacketHandler.INSTANCE.registerMessage(PacketPowerMonitorGraph.ClientHandler.class, PacketPowerMonitorGraph.class, PacketHandler.nextID(), Side.CLIENT);
        PacketHandler.INSTANCE.registerMessage(PacketPowerMonitorGraph.ServerHandler.class, PacketPowerMonitorGraph.class, PacketHandler.nextID(), Side.SERVER);
        PacketHandler.INSTANCE.registerMessage(PacketPowerMonitorStatData.ClientHandler.class, PacketPowerMonitorStatData.class, PacketHandler.nextID(), Side.CLIENT);
        PacketHandler.INSTANCE.registerMessage(PacketPowerMonitorStatData.ServerHandler.class, PacketPowerMonitorStatData.class, PacketHandler.nextID(), Side.SERVER);
        PacketHandler.INSTANCE.registerMessage(PacketPowerMonitorConfig.ServerHandler.class, PacketPowerMonitorConfig.class, PacketHandler.nextID(), Side.SERVER);
        advancedInstance = new BlockPowerMonitor(ModObject.blockPowerMonitorv2);
        advancedInstance.init();
        return advancedInstance;
    }

    public static Block createPowerMonitor() {
        BlockPowerMonitor result = new BlockPowerMonitor(ModObject.blockPowerMonitor);
        result.init();
        return result;
    }

    public BlockPowerMonitor(@Nonnull IModObject mo) {
        super(mo, TilePowerMonitor.class);
    }

    @Override
    public void init() {
        super.init();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs p_149666_2_, List list) {
        list.add(new ItemStack((Block)this, 1, 0));
    }

    public Object getServerGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        TileEntityBase te = this.getTileEntity((IBlockAccess)world, new BlockPos(x, y, z));
        if (!(te instanceof TilePowerMonitor)) {
            return null;
        }
        return new ContainerPowerMonitor(player.field_71071_by, (TilePowerMonitor)te);
    }

    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        TileEntityBase te = this.getTileEntity((IBlockAccess)world, new BlockPos(x, y, z));
        InventoryPlayer inventory = player.field_71071_by;
        if (te instanceof TilePowerMonitor && inventory != null) {
            return new GuiPowerMonitor(inventory, (TilePowerMonitor)te);
        }
        return null;
    }

    public boolean func_149662_c(IBlockState bs) {
        return false;
    }

    @Override
    protected int getGuiId() {
        return 8;
    }

    @SideOnly(value=Side.CLIENT)
    public void addCommonEntries(ItemStack itemstack, EntityPlayer entityplayer, List<String> list, boolean flag) {
    }

    @SideOnly(value=Side.CLIENT)
    public void addBasicEntries(ItemStack itemstack, EntityPlayer entityplayer, List<String> list, boolean flag) {
    }

    @SideOnly(value=Side.CLIENT)
    public void addDetailedEntries(ItemStack itemstack, EntityPlayer entityplayer, List<String> list, boolean flag) {
        SpecialTooltipHandler.addDetailedTooltipFromResources(list, (ItemStack)itemstack);
    }

    @Override
    protected void setBlockStateWrapperCache(@Nonnull IBlockStateWrapper blockStateWrapper, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull TilePowerMonitor tileEntity) {
        blockStateWrapper.addCacheKey(tileEntity.getFacing());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState bs, World world, BlockPos pos, Random rand) {
    }

    @Override
    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase player, ItemStack stack) {
        super.func_180633_a(world, pos, state, player, stack);
        TilePowerMonitor te = (TilePowerMonitor)this.getTileEntity((IBlockAccess)world, pos);
        if (te != null) {
            te.setAdvanced(this == advancedInstance);
        }
    }

    @Deprecated
    public int func_180656_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        TilePowerMonitor te = (TilePowerMonitor)this.getTileEntity(blockAccess, pos);
        if (te != null) {
            return te.getRedstoneLevel();
        }
        return super.func_180656_a(blockState, blockAccess, pos, side);
    }

    public boolean func_149744_f(IBlockState state) {
        return true;
    }

    public boolean canConnectRedstone(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        TilePowerMonitor te = (TilePowerMonitor)this.getTileEntitySafe(world, pos);
        if (te != null) {
            return te.isEngineControlEnabled();
        }
        return super.canConnectRedstone(state, world, pos, side);
    }

    @Deprecated
    public boolean func_176225_a(IBlockState bs, IBlockAccess worldIn, BlockPos pos, EnumFacing side) {
        if (!super.func_176225_a(bs, worldIn, pos, side)) {
            return false;
        }
        if (advancedInstance != this) {
            return true;
        }
        BlockPos myPos = pos;
        TilePowerMonitor tileEntity = (TilePowerMonitor)this.getTileEntitySafe(worldIn, myPos);
        if (tileEntity == null) {
            return true;
        }
        if (tileEntity.getFacing() != side) {
            return true;
        }
        return tileEntity.getPaintSource() == null;
    }
}

