/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.reservoir;

import com.enderio.core.client.render.BoundingBox;
import com.enderio.core.client.render.ManagedTESR;
import com.enderio.core.client.render.RenderUtil;
import com.enderio.core.common.vecmath.Vertex;
import crazypants.enderio.machine.reservoir.BlockReservoir;
import crazypants.enderio.machine.reservoir.TileReservoir;
import crazypants.enderio.tool.SmartTank;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ReservoirRenderer
extends ManagedTESR<TileReservoir> {
    public ReservoirRenderer(BlockReservoir res) {
        super((Block)res);
    }

    protected boolean shouldRender(@Nonnull TileReservoir te, @Nonnull IBlockState blockState, int renderPass) {
        return !te.tank.isEmpty();
    }

    protected void renderTileEntity(@Nonnull TileReservoir te, @Nonnull IBlockState blockState, float partialTicks, int destroyStage) {
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer tes = tessellator.func_178180_c();
        tes.func_181668_a(7, DefaultVertexFormats.field_181712_l);
        Set<EnumFacing> mergers = this.getMergers(te.func_145831_w(), te.func_174877_v());
        this.renderTankFluid(te.tank, mergers, te.func_145831_w(), te.func_174877_v());
        tessellator.func_78381_a();
    }

    private Set<EnumFacing> getMergers(World world, BlockPos pos) {
        EnumSet<EnumFacing> result = EnumSet.noneOf(EnumFacing.class);
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            BlockPos pos2 = pos.func_177972_a(dir);
            if (world.func_180495_p(pos2).func_177230_c() != this.block) continue;
            result.add(dir);
        }
        return result;
    }

    private boolean[][][] getMergers9(World world, BlockPos pos) {
        boolean[][][] merge = new boolean[3][3][3];
        for (int dx = 0; dx < 3; ++dx) {
            for (int dy = 0; dy < 3; ++dy) {
                for (int dz = 0; dz < 3; ++dz) {
                    BlockPos pos2 = pos.func_177982_a(dx - 1, dy - 1, dz - 1);
                    merge[dx][dy][dz] = world.func_180495_p(pos2).func_177230_c() == this.block;
                }
            }
        }
        return merge;
    }

    private BoundingBox mkFace(boolean[][][] merge, EnumFacing face, float fullness, float fullness2) {
        double minX = 0.0;
        double minY = 0.0;
        double minZ = 0.0;
        double maxX = 1.0;
        double maxY = 1.0;
        double maxZ = 1.0;
        switch (face) {
            case DOWN: {
                if (merge[1][0][1]) {
                    if (fullness2 == 1.0f) {
                        return null;
                    }
                    minY = 0.0;
                } else {
                    minY = 0.001;
                }
                double d = merge[0][1][1] ? (merge[0][0][1] ? -0.001 : 0.0) : (minX = 0.001);
                double d2 = merge[2][1][1] ? (merge[2][0][1] ? 1.001 : 1.0) : (maxX = 0.999);
                double d3 = merge[1][1][0] ? (merge[1][0][0] ? -0.001 : 0.0) : (minZ = 0.001);
                maxZ = merge[1][1][2] ? (merge[1][0][2] ? 1.001 : 1.0) : 0.999;
                break;
            }
            case EAST: {
                if (merge[2][1][1]) {
                    if (fullness <= fullness2) {
                        return null;
                    }
                    maxX = 1.0;
                } else {
                    maxX = 0.999;
                }
                double d = merge[1][0][1] ? (merge[2][0][1] ? -0.001 : 0.0) : (minY = 0.001);
                double d4 = merge[1][2][1] ? (merge[2][2][1] ? 1.001 : 1.0) : (maxY = 0.999);
                double d5 = merge[1][1][0] ? (merge[2][1][0] ? -0.001 : 0.0) : (minZ = 0.001);
                maxZ = merge[1][1][2] ? (merge[2][1][2] ? 1.001 : 1.0) : 0.999;
                break;
            }
            case NORTH: {
                if (merge[1][1][0]) {
                    if (fullness <= fullness2) {
                        return null;
                    }
                    minZ = 0.0;
                } else {
                    minZ = 0.001;
                }
                double d = merge[0][1][1] ? (merge[0][1][0] ? -0.001 : 0.0) : (minX = 0.001);
                double d6 = merge[2][1][1] ? (merge[2][1][0] ? 1.001 : 1.0) : (maxX = 0.999);
                double d7 = merge[1][0][1] ? (merge[1][0][0] ? -0.001 : 0.0) : (minY = 0.001);
                maxY = merge[1][2][1] ? (merge[1][2][0] ? 1.001 : 1.0) : 0.999;
                break;
            }
            case SOUTH: {
                if (merge[1][1][2]) {
                    if (fullness <= fullness2) {
                        return null;
                    }
                    maxZ = 1.0;
                } else {
                    maxZ = 0.999;
                }
                double d = merge[0][1][1] ? (merge[0][1][2] ? -0.001 : 0.0) : (minX = 0.001);
                double d8 = merge[2][1][1] ? (merge[2][1][2] ? 1.001 : 1.0) : (maxX = 0.999);
                double d9 = merge[1][0][1] ? (merge[1][0][2] ? -0.001 : 0.0) : (minY = 0.001);
                maxY = merge[1][2][1] ? (merge[1][2][2] ? 1.001 : 1.0) : 0.999;
                break;
            }
            case UP: {
                if (merge[1][2][1]) {
                    if (fullness2 > 0.0f && fullness == 1.0f) {
                        return null;
                    }
                    maxY = 1.0;
                } else {
                    maxY = 0.999;
                }
                double d = merge[0][1][1] ? (merge[0][2][1] ? -0.001 : 0.0) : (minX = 0.001);
                double d10 = merge[2][1][1] ? (merge[2][2][1] ? 1.001 : 1.0) : (maxX = 0.999);
                double d11 = merge[1][1][0] ? (merge[1][2][0] ? -0.001 : 0.0) : (minZ = 0.001);
                maxZ = merge[1][1][2] ? (merge[1][2][2] ? 1.001 : 1.0) : 0.999;
                break;
            }
            case WEST: {
                if (merge[0][1][1]) {
                    if (fullness <= fullness2) {
                        return null;
                    }
                    minX = 0.0;
                } else {
                    minX = 0.001;
                }
                double d = merge[1][0][1] ? (merge[0][0][1] ? -0.001 : 0.0) : (minY = 0.001);
                double d12 = merge[1][2][1] ? (merge[0][2][1] ? 1.001 : 1.0) : (maxY = 0.999);
                double d13 = merge[1][1][0] ? (merge[0][1][0] ? -0.001 : 0.0) : (minZ = 0.001);
                maxZ = merge[1][1][2] ? (merge[0][1][2] ? 1.001 : 1.0) : 0.999;
                break;
            }
        }
        if (face != EnumFacing.DOWN) {
            if (fullness2 > 0.0f && face != EnumFacing.UP) {
                minY = maxY * (double)fullness2;
            }
            maxY *= (double)fullness;
        }
        return new BoundingBox(minX, minY, minZ, maxX, maxY, maxZ);
    }

    private void renderTankFluid(SmartTank tank, Set<EnumFacing> mergers, World world, BlockPos pos) {
        TextureAtlasSprite icon = RenderUtil.getStillTexture((FluidStack)tank.getFluid());
        if (icon != null) {
            int color = tank.getFluid().getFluid().getColor(tank.getFluid());
            float fullness = tank.getFilledRatio();
            boolean[][][] merge = this.getMergers9(world, pos);
            VertexBuffer tes = Tessellator.func_178181_a().func_178180_c();
            float minU = icon.func_94209_e();
            float maxU = icon.func_94212_f();
            float minV = icon.func_94206_g();
            float maxV = icon.func_94210_h();
            for (int i = 0; i <= 1; ++i) {
                if (i == 0) {
                    GlStateManager.func_187407_a((GlStateManager.CullFace)GlStateManager.CullFace.FRONT);
                } else {
                    GlStateManager.func_187407_a((GlStateManager.CullFace)GlStateManager.CullFace.BACK);
                }
                for (EnumFacing dir : EnumFacing.field_82609_l) {
                    BoundingBox bb;
                    BlockPos pos2;
                    TileEntity tileEntity;
                    float fullness2 = 0.0f;
                    if (mergers.contains(dir) && (tileEntity = world.func_175625_s(pos2 = pos.func_177972_a(dir))) instanceof TileReservoir) {
                        TileReservoir res2 = (TileReservoir)tileEntity;
                        fullness2 = res2.tank.getFilledRatio();
                    }
                    if ((bb = this.mkFace(merge, dir, fullness, fullness2)) == null) continue;
                    float minVx = minV;
                    float maxVx = maxV;
                    if (dir.func_176740_k() != EnumFacing.Axis.Y) {
                        minVx = icon.func_94207_b((double)((1.0f - fullness) * 16.0f));
                        maxVx = icon.func_94207_b((double)((1.0f - fullness2) * 16.0f));
                    }
                    ReservoirRenderer.renderFace(tes, bb, dir, minU, maxU, minVx, maxVx, color);
                }
            }
        }
    }

    public static void renderFace(VertexBuffer tes, BoundingBox bb, EnumFacing face, float minU, float maxU, float minV, float maxV, int color) {
        float d = 1.0f;
        float r = d * (float)(color >> 16 & 0xFF) / 255.0f;
        float g = d * (float)(color >> 8 & 0xFF) / 255.0f;
        float b = d * (float)(color & 0xFF) / 255.0f;
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        List corners = bb.getCornersWithUvForFace(face, minU, maxU, minV, maxV);
        for (Vertex v : corners) {
            tes.func_181662_b(v.x(), v.y(), v.z()).func_187315_a((double)v.u(), (double)v.v()).func_181666_a(r, g, b, a).func_181663_c(v.nx(), v.ny(), v.nz()).func_181675_d();
        }
    }
}

