/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.solar;

import com.enderio.core.api.client.gui.IResourceTooltipProvider;
import com.enderio.core.common.TileEntityBase;
import crazypants.enderio.BlockEio;
import crazypants.enderio.EnderIO;
import crazypants.enderio.ModObject;
import crazypants.enderio.config.Config;
import crazypants.enderio.integration.waila.IWailaInfoProvider;
import crazypants.enderio.machine.solar.BlockItemSolarPanel;
import crazypants.enderio.machine.solar.SolarBlockRenderMapper;
import crazypants.enderio.machine.solar.SolarItemRenderMapper;
import crazypants.enderio.machine.solar.SolarType;
import crazypants.enderio.machine.solar.TileEntitySolarPanel;
import crazypants.enderio.render.IRenderMapper;
import crazypants.enderio.render.ISmartRenderAwareBlock;
import crazypants.enderio.render.pipeline.BlockStateWrapperBase;
import crazypants.enderio.render.property.EnumMergingBlockRenderMode;
import crazypants.enderio.render.registry.SmartModelAttacher;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockSolarPanel
extends BlockEio<TileEntitySolarPanel>
implements IResourceTooltipProvider,
IWailaInfoProvider,
ISmartRenderAwareBlock {
    @SideOnly(value=Side.CLIENT)
    private static SolarItemRenderMapper RENDER_MAPPER;
    private static final float BLOCK_HEIGHT = 0.15625f;

    public static BlockSolarPanel create() {
        BlockSolarPanel result = new BlockSolarPanel();
        result.init();
        return result;
    }

    private BlockSolarPanel() {
        super(ModObject.blockSolarPanel.getUnlocalisedName(), TileEntitySolarPanel.class);
        if (!Config.photovoltaicCellEnabled) {
            this.func_149647_a(null);
        }
        this.func_149713_g(255);
        this.field_149783_u = true;
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(EnumMergingBlockRenderMode.RENDER, (Comparable)((Object)EnumMergingBlockRenderMode.AUTO)).func_177226_a(SolarType.KIND, (Comparable)((Object)SolarType.SIMPLE)));
    }

    protected ItemBlock createItemBlock() {
        return new BlockItemSolarPanel(this, this.getName());
    }

    protected void init() {
        super.init();
        SmartModelAttacher.register((Block)this, EnumMergingBlockRenderMode.RENDER, EnumMergingBlockRenderMode.DEFAULTS, EnumMergingBlockRenderMode.AUTO);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{EnumMergingBlockRenderMode.RENDER, SolarType.KIND});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(SolarType.KIND, (Comparable)((Object)SolarType.getTypeFromMeta(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return SolarType.getMetaFromType((SolarType)((Object)state.func_177229_b(SolarType.KIND)));
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return state.func_177226_a(EnumMergingBlockRenderMode.RENDER, (Comparable)((Object)EnumMergingBlockRenderMode.AUTO));
    }

    @SideOnly(value=Side.CLIENT)
    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (state != null && world != null && pos != null) {
            SolarBlockRenderMapper renderMapper = new SolarBlockRenderMapper(state, world, pos);
            BlockStateWrapperBase blockStateWrapper = new BlockStateWrapperBase(state, world, pos, renderMapper);
            blockStateWrapper.addCacheKey(state.func_177229_b(SolarType.KIND));
            blockStateWrapper.addCacheKey(renderMapper);
            blockStateWrapper.bakeModel();
            return blockStateWrapper;
        }
        return state;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IRenderMapper.IItemRenderMapper getItemRenderMapper() {
        return SolarItemRenderMapper.instance;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.SOLID;
    }

    public int func_180651_a(IBlockState bs) {
        return this.func_176201_c(bs);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.15625, 1.0);
    }

    public String getUnlocalizedNameForTooltip(ItemStack itemStack) {
        return this.func_149739_a();
    }

    @Override
    public void getWailaInfo(List<String> tooltip, EntityPlayer player, World world, int x, int y, int z) {
        TileEntityBase te = this.getTileEntity((IBlockAccess)world, new BlockPos(x, y, z));
        if (te instanceof TileEntitySolarPanel) {
            TileEntitySolarPanel solar = (TileEntitySolarPanel)te;
            float efficiency = solar.calculateLightRatio();
            if (!solar.canSeeSun()) {
                tooltip.add(TextFormatting.RED + EnderIO.lang.localize("tooltip.sunlightBlocked"));
            } else {
                tooltip.add(String.format("%s : %s%.0f%%", TextFormatting.WHITE + EnderIO.lang.localize("tooltip.efficiency") + TextFormatting.RESET, TextFormatting.WHITE, Float.valueOf(efficiency * 100.0f)));
            }
        }
    }

    @Override
    public int getDefaultDisplayMask(World world, int x, int y, int z) {
        return 0;
    }

    public boolean func_149662_c(IBlockState bs) {
        return false;
    }

    public boolean func_149686_d(IBlockState bs) {
        return false;
    }

    public boolean doesSideBlockRendering(IBlockState bs, IBlockAccess world, BlockPos pos, EnumFacing face) {
        return face == EnumFacing.DOWN;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item itemIn, CreativeTabs tab, List<ItemStack> list) {
        for (SolarType solarType : SolarType.KIND.func_177700_c()) {
            list.add(new ItemStack((Block)this, 1, this.func_180651_a(this.func_176223_P().func_177226_a(SolarType.KIND, (Comparable)((Object)solarType)))));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        TileEntitySolarPanel solar;
        TileEntityBase te;
        if (state.func_177229_b(SolarType.KIND) == SolarType.VIBRANT && (te = this.getTileEntity((IBlockAccess)world, pos)) instanceof TileEntitySolarPanel && (solar = (TileEntitySolarPanel)te).canSeeSun() && solar.calculateLightRatio() / 3.0f > rand.nextFloat()) {
            double d0 = (double)pos.func_177958_n() + 0.5 + (Math.random() - 0.5) * 0.5;
            double d1 = (float)pos.func_177956_o() + 0.15625f;
            double d2 = (double)pos.func_177952_p() + 0.5 + (Math.random() - 0.5) * 0.5;
            world.func_175688_a(EnumParticleTypes.REDSTONE, d0, d1, d2, 0.2784313725490196, 0.6235294117647059, 0.6392156862745098, new int[0]);
        }
    }
}

