/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.transceiver;

import com.enderio.core.common.fluid.FluidWrapper;
import com.enderio.core.common.fluid.IFluidWrapper;
import com.enderio.core.common.util.FluidUtil;
import com.enderio.core.common.util.ItemUtil;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.SetMultimap;
import crazypants.enderio.ModObject;
import crazypants.enderio.capacitor.CapacitorKey;
import crazypants.enderio.conduit.item.FilterRegister;
import crazypants.enderio.conduit.item.filter.ItemFilter;
import crazypants.enderio.machine.AbstractPoweredTaskEntity;
import crazypants.enderio.machine.ContinuousTask;
import crazypants.enderio.machine.IItemBuffer;
import crazypants.enderio.machine.IoMode;
import crazypants.enderio.machine.SlotDefinition;
import crazypants.enderio.machine.transceiver.Channel;
import crazypants.enderio.machine.transceiver.ChannelType;
import crazypants.enderio.machine.transceiver.PacketSendRecieveChannelList;
import crazypants.enderio.machine.transceiver.ServerChannelRegister;
import crazypants.enderio.network.PacketHandler;
import crazypants.enderio.paint.IPaintable;
import crazypants.enderio.power.IInternalPowerReceiver;
import crazypants.enderio.power.PowerDistributor;
import crazypants.enderio.rail.EnderRailController;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class TileTransceiver
extends AbstractPoweredTaskEntity
implements IItemBuffer,
IInternalPowerReceiver,
IPaintable.IPaintableTileEntity {
    private static final float MIN_POWER_TO_SEND = 0.5f;
    private final SetMultimap<ChannelType, Channel> sendChannels = MultimapBuilder.enumKeys(ChannelType.class).hashSetValues().build();
    private final SetMultimap<ChannelType, Channel> recieveChannels = MultimapBuilder.enumKeys(ChannelType.class).hashSetValues().build();
    private boolean sendChannelsDirty = false;
    private boolean recieveChannelsDirty = false;
    private boolean registered = false;
    private Map<EnumFacing, IFluidHandler> neighbourFluidHandlers = null;
    private PowerDistributor powerDistributor;
    @Nonnull
    private final EnderRailController railController;
    private boolean inFluidFill = false;
    private boolean inGetTankInfo = false;
    private ItemFilter sendItemFilter;
    private ItemFilter recieveItemFilter;
    private boolean bufferStacks = true;

    public TileTransceiver() {
        super(new SlotDefinition(8, 8, 0), CapacitorKey.TRANSCEIVER_POWER_INTAKE, CapacitorKey.TRANSCEIVER_POWER_BUFFER, CapacitorKey.TRANSCEIVER_POWER_USE);
        this.currentTask = new ContinuousTask(this.getPowerUsePerTick());
        this.railController = new EnderRailController(this);
        this.sendItemFilter = new ItemFilter(true);
        this.recieveItemFilter = new ItemFilter(true);
    }

    public EnderRailController getRailController() {
        return this.railController;
    }

    public boolean isRedstoneChecksPassed() {
        return this.redstoneCheckPassed;
    }

    @Override
    protected boolean processTasks(boolean redstoneChecksPassed) {
        boolean res = super.processTasks(redstoneChecksPassed);
        if (!redstoneChecksPassed) {
            return res;
        }
        this.processPower();
        this.processItems();
        return res;
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 1;
    }

    @Override
    public void doUpdate() {
        if (!this.registered && !this.field_145850_b.field_72995_K) {
            ServerChannelRegister.instance.register(this);
            this.registered = true;
            this.removeUnregsiteredChannels(this.sendChannels);
            this.removeUnregsiteredChannels(this.recieveChannels);
        }
        super.doUpdate();
        if (!this.field_145850_b.field_72995_K) {
            this.railController.doTick();
            if (this.sendChannelsDirty) {
                PacketHandler.sendToAllAround((IMessage)new PacketSendRecieveChannelList(this, true), (TileEntity)this, 256);
                this.sendChannelsDirty = false;
            }
            if (this.recieveChannelsDirty) {
                PacketHandler.sendToAllAround((IMessage)new PacketSendRecieveChannelList(this, false), (TileEntity)this, 256);
                this.recieveChannelsDirty = false;
            }
        }
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        if (this.registered && this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            ServerChannelRegister.instance.dergister(this);
            this.registered = false;
        }
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        if (this.registered && this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            ServerChannelRegister.instance.dergister(this);
            this.registered = false;
        }
    }

    private void removeUnregsiteredChannels(SetMultimap<ChannelType, Channel> chans) {
        ArrayList<Channel> toRemove = new ArrayList<Channel>();
        for (Channel chan : chans.values()) {
            if (ServerChannelRegister.instance.getChannelsForType(chan.getType()).contains(chan)) continue;
            toRemove.add(chan);
        }
        for (Channel chan : toRemove) {
            this.removeChannel(chan, chans);
        }
    }

    @Override
    @Nonnull
    public String getMachineName() {
        return ModObject.blockTransceiver.getUnlocalisedName();
    }

    @Override
    public boolean isActive() {
        return this.hasPower();
    }

    public Set<Channel> getSendChannels(ChannelType type) {
        return this.sendChannels.get((Object)type);
    }

    public Set<Channel> getRecieveChannels(ChannelType type) {
        return this.recieveChannels.get((Object)type);
    }

    public void addSendChanel(Channel channel) {
        this.addChannel(channel, this.sendChannels);
    }

    public void addRecieveChanel(Channel channel) {
        this.addChannel(channel, this.recieveChannels);
    }

    public void removeSendChanel(Channel channel) {
        this.removeChannel(channel, this.sendChannels);
    }

    public void removeRecieveChanel(Channel channel) {
        this.removeChannel(channel, this.recieveChannels);
    }

    private void addChannel(Channel channel, SetMultimap<ChannelType, Channel> channels) {
        if (channel == null) {
            return;
        }
        Set chans = channels.get((Object)channel.getType());
        if (chans.add(channel)) {
            if (channels == this.sendChannels) {
                this.sendChannelsDirty = true;
            } else {
                this.recieveChannelsDirty = true;
            }
        }
    }

    private void removeChannel(Channel channel, SetMultimap<ChannelType, Channel> channnels) {
        if (channel == null) {
            return;
        }
        Set chans = channnels.get((Object)channel.getType());
        if (chans.remove(channel)) {
            if (channnels == this.sendChannels) {
                this.sendChannelsDirty = true;
            } else {
                this.recieveChannelsDirty = true;
            }
        }
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbtRoot) {
        super.readCustomNBT(nbtRoot);
        this.railController.readFromNBT(nbtRoot);
        this.currentTask = new ContinuousTask(this.getPowerUsePerTick());
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbtRoot) {
        super.writeCustomNBT(nbtRoot);
        this.railController.writeToNBT(nbtRoot);
    }

    @Override
    public void readCommon(NBTTagCompound nbtRoot) {
        NBTTagCompound itemRoot;
        super.readCommon(nbtRoot);
        TileTransceiver.readChannels(nbtRoot, this.sendChannels, "sendChannels");
        TileTransceiver.readChannels(nbtRoot, this.recieveChannels, "recieveChannels");
        if (nbtRoot.func_74764_b("sendItemFilter")) {
            itemRoot = nbtRoot.func_74775_l("sendItemFilter");
            this.sendItemFilter.copyFrom((ItemFilter)FilterRegister.loadFilterFromNbt(itemRoot));
        }
        if (nbtRoot.func_74764_b("recieveItemFilter")) {
            itemRoot = nbtRoot.func_74775_l("recieveItemFilter");
            this.recieveItemFilter.copyFrom((ItemFilter)FilterRegister.loadFilterFromNbt(itemRoot));
        }
        this.bufferStacks = nbtRoot.func_74764_b("bufferStacks") ? nbtRoot.func_74767_n("bufferStacks") : true;
    }

    static void readChannels(NBTTagCompound nbtRoot, SetMultimap<ChannelType, Channel> channels, String key) {
        channels.clear();
        if (!nbtRoot.func_74764_b(key)) {
            return;
        }
        NBTTagList tags = (NBTTagList)nbtRoot.func_74781_a(key);
        for (int i = 0; i < tags.func_74745_c(); ++i) {
            NBTTagCompound chanelTag = tags.func_150305_b(i);
            Channel channel = Channel.readFromNBT(chanelTag);
            if (channel == null) continue;
            channels.put((Object)channel.getType(), (Object)channel);
        }
    }

    @Override
    public void writeCommon(NBTTagCompound nbtRoot) {
        NBTTagCompound itemRoot;
        super.writeCommon(nbtRoot);
        NBTTagList channelTags = TileTransceiver.createTagList(this.sendChannels);
        nbtRoot.func_74782_a("sendChannels", (NBTBase)channelTags);
        channelTags = TileTransceiver.createTagList(this.recieveChannels);
        nbtRoot.func_74782_a("recieveChannels", (NBTBase)channelTags);
        if (this.sendItemFilter != null) {
            itemRoot = new NBTTagCompound();
            FilterRegister.writeFilterToNbt(this.sendItemFilter, itemRoot);
            nbtRoot.func_74782_a("sendItemFilter", (NBTBase)itemRoot);
        }
        if (this.recieveItemFilter != null) {
            itemRoot = new NBTTagCompound();
            FilterRegister.writeFilterToNbt(this.recieveItemFilter, itemRoot);
            nbtRoot.func_74782_a("recieveItemFilter", (NBTBase)itemRoot);
        }
        nbtRoot.func_74757_a("bufferStacks", this.bufferStacks);
    }

    static NBTTagList createTagList(SetMultimap<ChannelType, Channel> channels) {
        NBTTagList res = new NBTTagList();
        for (Channel channel : channels.values()) {
            NBTTagCompound chanTag = new NBTTagCompound();
            channel.writeToNBT(chanTag);
            res.func_74742_a((NBTBase)chanTag);
        }
        return res;
    }

    void setSendChannels(Multimap<? extends ChannelType, ? extends Channel> channels) {
        this.sendChannels.clear();
        this.sendChannels.putAll(channels);
    }

    void setRecieveChannels(Multimap<? extends ChannelType, ? extends Channel> channels) {
        this.recieveChannels.clear();
        this.recieveChannels.putAll(channels);
    }

    SetMultimap<ChannelType, Channel> getSendChannels() {
        return this.sendChannels;
    }

    SetMultimap<ChannelType, Channel> getReceiveChannels() {
        return this.recieveChannels;
    }

    private void processPower() {
        Set<Channel> sendTo = this.getSendChannels(ChannelType.POWER);
        int canSend = this.getMaxSendableEnergy();
        if (canSend > 0 && !sendTo.isEmpty()) {
            Iterator<Channel> iter = sendTo.iterator();
            while (canSend > 0 && iter.hasNext()) {
                ServerChannelRegister.instance.sendPower(this, canSend, iter.next());
                canSend = this.getMaxSendableEnergy();
            }
        }
        if ((canSend = this.getMaxSendableEnergy()) > 0 && !this.getRecieveChannels(ChannelType.POWER).isEmpty()) {
            if (this.powerDistributor == null) {
                this.powerDistributor = new PowerDistributor(this.getLocation());
            }
            int used = this.powerDistributor.transmitEnergy(this.field_145850_b, canSend);
            this.usePower(used);
        }
    }

    private int getMaxSendableEnergy() {
        return this.getEnergyStored(null) - (int)(0.5f * (float)this.getMaxEnergyStored());
    }

    @Override
    public void onNeighborBlockChange(Block blockId) {
        super.onNeighborBlockChange(blockId);
        if (this.powerDistributor != null) {
            this.powerDistributor.neighboursChanged();
        }
        this.neighbourFluidHandlers = null;
    }

    private boolean hasRecieveChannel(Set<Channel> channels, ChannelType type) {
        boolean hasChannel = false;
        for (Channel chan : channels) {
            if (!this.getRecieveChannels(type).contains(chan)) continue;
            hasChannel = true;
            break;
        }
        return hasChannel;
    }

    public boolean canReceive(Set<Channel> channels, Fluid fluid) {
        if (this.inFluidFill) {
            return false;
        }
        if (!this.hasRecieveChannel(channels, ChannelType.FLUID)) {
            return false;
        }
        FluidStack offer = new FluidStack(fluid, 1);
        Map neighbours = FluidWrapper.wrapNeighbours((IBlockAccess)this.field_145850_b, (BlockPos)this.field_174879_c);
        for (Map.Entry entry : neighbours.entrySet()) {
            IoMode mode = this.getIoMode((EnumFacing)entry.getKey());
            if (!mode.canOutput() || ((IFluidWrapper)entry.getValue()).offer(offer) <= 0) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int fill(EnumFacing from, FluidStack resource, boolean doFill) {
        if (this.inFluidFill) {
            return 0;
        }
        try {
            this.inFluidFill = true;
            if (this.getSendChannels(ChannelType.FLUID).isEmpty() || !this.redstoneCheckPassed || !this.getIoMode(from).canRecieveInput()) {
                int n = 0;
                return n;
            }
            int n = ServerChannelRegister.instance.fill(this, this.getSendChannels(ChannelType.FLUID), resource, doFill);
            return n;
        }
        finally {
            this.inFluidFill = false;
        }
    }

    public int recieveFluid(Set<Channel> channels, FluidStack resource, boolean doFill) {
        if (this.inFluidFill) {
            return 0;
        }
        if (!this.hasRecieveChannel(channels, ChannelType.FLUID) || !this.redstoneCheckPassed) {
            return 0;
        }
        Map neighbours = FluidWrapper.wrapNeighbours((IBlockAccess)this.field_145850_b, (BlockPos)this.field_174879_c);
        for (Map.Entry entry : neighbours.entrySet()) {
            int res;
            IoMode mode = this.getIoMode((EnumFacing)entry.getKey());
            if (!mode.canOutput() || (res = doFill ? ((IFluidWrapper)entry.getValue()).fill(resource) : ((IFluidWrapper)entry.getValue()).offer(resource)) <= 0) continue;
            return res;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getRecieveTankInfo(List<IFluidTankProperties> infos, Set<Channel> channels) {
        if (this.inGetTankInfo) {
            return;
        }
        try {
            this.inGetTankInfo = true;
            if (!this.hasRecieveChannel(channels, ChannelType.FLUID)) {
                return;
            }
            Map<EnumFacing, IFluidHandler> fluidHandlers = this.getNeighbouringFluidHandlers();
            for (Map.Entry<EnumFacing, IFluidHandler> entry : fluidHandlers.entrySet()) {
                IFluidTankProperties[] tanks = entry.getValue().getTankProperties();
                if (tanks == null) continue;
                for (IFluidTankProperties info : tanks) {
                    infos.add(info);
                }
            }
        }
        finally {
            this.inGetTankInfo = false;
        }
    }

    Map<EnumFacing, IFluidHandler> getNeighbouringFluidHandlers() {
        if (this.neighbourFluidHandlers == null) {
            this.neighbourFluidHandlers = FluidUtil.getNeighbouringFluidHandlers((World)this.field_145850_b, (BlockPos)this.func_174877_v());
        }
        return this.neighbourFluidHandlers;
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)new FluidCap(facing);
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public int func_70297_j_() {
        return this.bufferStacks ? 64 : 1;
    }

    @Override
    public boolean isBufferStacks() {
        return this.bufferStacks;
    }

    @Override
    public void setBufferStacks(boolean bufferStacks) {
        this.bufferStacks = bufferStacks;
    }

    private void processItems() {
        Set<Channel> sendItemChannels = this.getSendChannels(ChannelType.ITEM);
        if (!sendItemChannels.isEmpty()) {
            for (int i = this.slotDefinition.minInputSlot; i <= this.slotDefinition.maxInputSlot; ++i) {
                ItemStack toSend = this.func_70301_a(i);
                if (toSend == null) continue;
                ServerChannelRegister.instance.sendItem(this, sendItemChannels, i, toSend);
            }
        }
    }

    public ItemFilter getSendItemFilter() {
        return this.sendItemFilter;
    }

    public ItemFilter getReceiveItemFilter() {
        return this.recieveItemFilter;
    }

    public ItemFilter getRecieveItemFilter() {
        return this.recieveItemFilter;
    }

    public void setRecieveItemFilter(ItemFilter recieveItemFilter) {
        this.recieveItemFilter = recieveItemFilter;
    }

    public void setSendItemFilter(ItemFilter sendItemFilter) {
        this.sendItemFilter = sendItemFilter;
    }

    @Override
    protected boolean isMachineItemValidForSlot(int slot, ItemStack itemstack) {
        if (itemstack == null) {
            return false;
        }
        return !(this.slotDefinition.isInputSlot(slot) ? !this.getSendItemFilter().doesItemPassFilter(null, itemstack) : this.slotDefinition.isOutputSlot(slot) && !this.getReceiveItemFilter().doesItemPassFilter(null, itemstack));
    }

    @Override
    public boolean func_180462_a(int slot, ItemStack itemstack, EnumFacing j) {
        block7: {
            block6: {
                if (itemstack == null) {
                    return false;
                }
                if (!this.slotDefinition.isInputSlot(slot)) break block6;
                Set chans = this.getSendChannels().get((Object)ChannelType.ITEM);
                if (chans == null || chans.size() == 0) {
                    return false;
                }
                if (!this.getSendItemFilter().doesItemPassFilter(null, itemstack)) {
                    return false;
                }
                for (int i = this.slotDefinition.getMinInputSlot(); i <= this.slotDefinition.getMaxInputSlot(); ++i) {
                    if (i == slot || !ItemUtil.areStacksEqual((ItemStack)itemstack, (ItemStack)this.func_70301_a(i))) continue;
                    return false;
                }
                break block7;
            }
            if (!this.slotDefinition.isOutputSlot(slot)) break block7;
            if (!this.getRecieveItemFilter().doesItemPassFilter(null, itemstack)) {
                return false;
            }
            for (int i = this.slotDefinition.getMinOutputSlot(); i <= this.slotDefinition.getMaxOutputSlot(); ++i) {
                if (i == slot || !ItemUtil.areStacksEqual((ItemStack)itemstack, (ItemStack)this.func_70301_a(i))) continue;
                return false;
            }
        }
        return super.func_180462_a(slot, itemstack, j);
    }

    private class FluidCap
    implements IFluidHandler {
        final EnumFacing facing;

        FluidCap(EnumFacing facing) {
            this.facing = facing;
        }

        public int fill(FluidStack resource, boolean doFill) {
            return TileTransceiver.this.fill(this.facing, resource, doFill);
        }

        public FluidStack drain(FluidStack resource, boolean doDrain) {
            return null;
        }

        public FluidStack drain(int maxDrain, boolean doDrain) {
            return null;
        }

        public IFluidTankProperties[] getTankProperties() {
            if (TileTransceiver.this.inGetTankInfo) {
                return new IFluidTankProperties[0];
            }
            try {
                TileTransceiver.this.inGetTankInfo = true;
                IFluidTankProperties[] iFluidTankPropertiesArray = ServerChannelRegister.instance.getTankInfoForChannels(TileTransceiver.this, TileTransceiver.this.getSendChannels(ChannelType.FLUID));
                return iFluidTankPropertiesArray;
            }
            finally {
                TileTransceiver.this.inGetTankInfo = false;
            }
        }
    }
}

