/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.vat;

import com.enderio.core.client.ClientUtil;
import crazypants.enderio.ModObject;
import crazypants.enderio.machine.AbstractMachineBlock;
import crazypants.enderio.machine.RenderMappers;
import crazypants.enderio.machine.vat.ContainerVat;
import crazypants.enderio.machine.vat.GuiVat;
import crazypants.enderio.machine.vat.PacketDumpTank;
import crazypants.enderio.machine.vat.PacketTanks;
import crazypants.enderio.machine.vat.PacketVatProgress;
import crazypants.enderio.machine.vat.TileVat;
import crazypants.enderio.network.PacketHandler;
import crazypants.enderio.paint.IPaintable;
import crazypants.enderio.render.IBlockStateWrapper;
import crazypants.enderio.render.IRenderMapper;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockVat
extends AbstractMachineBlock<TileVat>
implements IPaintable.INonSolidBlockPaintableBlock,
IPaintable.IWrenchHideablePaint {
    public static BlockVat create() {
        PacketHandler.INSTANCE.registerMessage(PacketTanks.class, PacketTanks.class, PacketHandler.nextID(), Side.CLIENT);
        PacketHandler.INSTANCE.registerMessage(PacketVatProgress.class, PacketVatProgress.class, PacketHandler.nextID(), Side.CLIENT);
        PacketHandler.INSTANCE.registerMessage(PacketDumpTank.class, PacketDumpTank.class, PacketHandler.nextID(), Side.SERVER);
        BlockVat res = new BlockVat();
        res.init();
        return res;
    }

    public BlockVat() {
        super(ModObject.blockVat, TileVat.class);
    }

    public int func_149717_k(IBlockState state) {
        return 0;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public Object getServerGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        TileVat te;
        if (world != null && (te = (TileVat)this.getTileEntity((IBlockAccess)world, new BlockPos(x, y, z))) != null) {
            return new ContainerVat(player.field_71071_by, te);
        }
        return null;
    }

    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        TileVat te;
        if (world != null && (te = (TileVat)this.getTileEntity((IBlockAccess)world, new BlockPos(x, y, z))) != null) {
            return new GuiVat(player.field_71071_by, te);
        }
        return null;
    }

    @Override
    protected int getGuiId() {
        return 20;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState state, IBlockAccess worldIn, BlockPos pos, EnumFacing side) {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState bs, World world, BlockPos pos, Random rand) {
        TileVat te;
        if (world != null && pos != null && rand != null && (te = (TileVat)this.getTileEntity((IBlockAccess)world, pos)) != null && te.isActive()) {
            float pX = (float)pos.func_177958_n() + 0.5f;
            float pY = (float)pos.func_177956_o() + 0.7f;
            float pZ = (float)pos.func_177952_p() + 0.5f;
            EnumFacing dir = te.getFacing();
            pX += 0.6f * (float)dir.func_82601_c();
            pZ += 0.6f * (float)dir.func_82599_e();
            double velX = (rand.nextDouble() * 0.075 + 0.025) * (double)dir.func_82601_c();
            double velZ = (rand.nextDouble() * 0.075 + 0.025) * (double)dir.func_82599_e();
            int num = rand.nextInt(4) + 2;
            for (int k = 0; k < num; ++k) {
                ParticleManager er = Minecraft.func_71410_x().field_71452_i;
                Particle fx = er.func_178927_a(EnumParticleTypes.SMOKE_NORMAL.func_179348_c(), (double)pX, (double)pY, (double)pZ, 1.0, 1.0, 1.0, new int[]{0});
                if (fx == null) continue;
                fx.func_70538_b(1.0f - rand.nextFloat() * 0.2f, 1.0f - rand.nextFloat() * 0.1f, 1.0f - rand.nextFloat() * 0.2f);
                ClientUtil.setParticleVelocity((Particle)fx, (double)velX, (double)-0.06, (double)velZ);
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IRenderMapper.IItemRenderMapper getItemRenderMapper() {
        return RenderMappers.FRONT_MAPPER;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IRenderMapper.IBlockRenderMapper getBlockRenderMapper() {
        return RenderMappers.FRONT_MAPPER;
    }

    @Override
    protected void setBlockStateWrapperCache(@Nonnull IBlockStateWrapper blockStateWrapper, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull TileVat tileEntity) {
        blockStateWrapper.addCacheKey(tileEntity.getFacing()).addCacheKey(tileEntity.isActive());
    }
}

