/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.wireless;

import com.enderio.core.api.client.gui.IResourceTooltipProvider;
import crazypants.enderio.BlockEio;
import crazypants.enderio.ModObject;
import crazypants.enderio.machine.wireless.PacketStoredEnergy;
import crazypants.enderio.machine.wireless.TileWirelessCharger;
import crazypants.enderio.machine.wireless.WirelessRenderMapper;
import crazypants.enderio.network.PacketHandler;
import crazypants.enderio.paint.IPaintable;
import crazypants.enderio.paint.PainterUtil2;
import crazypants.enderio.paint.render.PaintHelper;
import crazypants.enderio.render.IBlockStateWrapper;
import crazypants.enderio.render.IRenderMapper;
import crazypants.enderio.render.ISmartRenderAwareBlock;
import crazypants.enderio.render.pipeline.BlockStateWrapperBase;
import crazypants.enderio.render.property.EnumRenderMode;
import crazypants.enderio.render.registry.SmartModelAttacher;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockWirelessCharger
extends BlockEio<TileWirelessCharger>
implements IResourceTooltipProvider,
ISmartRenderAwareBlock,
IPaintable.IBlockPaintableBlock,
IPaintable.IWrenchHideablePaint {
    public static BlockWirelessCharger create() {
        PacketHandler.INSTANCE.registerMessage(PacketStoredEnergy.class, PacketStoredEnergy.class, PacketHandler.nextID(), Side.CLIENT);
        BlockWirelessCharger res = new BlockWirelessCharger();
        res.init();
        return res;
    }

    protected BlockWirelessCharger() {
        super(ModObject.blockWirelessCharger.getUnlocalisedName(), TileWirelessCharger.class);
        this.func_149713_g(1);
        this.initDefaultState();
    }

    protected void initDefaultState() {
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(EnumRenderMode.RENDER, (Comparable)((Object)EnumRenderMode.AUTO)));
        this.registerInSmartModelAttacher();
    }

    protected void registerInSmartModelAttacher() {
        SmartModelAttacher.register((Block)this);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{EnumRenderMode.RENDER});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P();
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return this.func_176223_P();
    }

    @SideOnly(value=Side.CLIENT)
    public final IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (state != null && world != null && pos != null) {
            BlockStateWrapperBase blockStateWrapper = this.createBlockStateWrapper(state, world, pos);
            TileWirelessCharger tileEntity = (TileWirelessCharger)this.getTileEntitySafe(world, pos);
            if (tileEntity != null) {
                this.setBlockStateWrapperCache(blockStateWrapper, world, pos, tileEntity);
            }
            blockStateWrapper.bakeModel();
            return blockStateWrapper;
        }
        return state;
    }

    protected void setBlockStateWrapperCache(@Nonnull IBlockStateWrapper blockStateWrapper, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull TileWirelessCharger tileEntity) {
        blockStateWrapper.addCacheKey(tileEntity.isActive());
    }

    @Nonnull
    protected BlockStateWrapperBase createBlockStateWrapper(@Nonnull IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
        return new BlockStateWrapperBase(state, world, pos, this.getBlockRenderMapper());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IRenderMapper.IItemRenderMapper getItemRenderMapper() {
        return WirelessRenderMapper.instance;
    }

    @SideOnly(value=Side.CLIENT)
    public IRenderMapper.IBlockRenderMapper getBlockRenderMapper() {
        return WirelessRenderMapper.instance;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public String getUnlocalizedNameForTooltip(ItemStack itemStack) {
        return this.func_149739_a();
    }

    public boolean doNormalDrops(IBlockAccess world, BlockPos pos) {
        return false;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase player, ItemStack stack) {
        TileEntity te;
        if (stack.func_77978_p() != null && (te = world.func_175625_s(pos)) instanceof TileWirelessCharger) {
            ((TileWirelessCharger)te).readContentsFromNBT(stack.func_77978_p());
            ((TileWirelessCharger)te).setPaintSource(PainterUtil2.getSourceBlock(stack));
        }
    }

    protected void processDrop(IBlockAccess world, BlockPos pos, @Nullable TileWirelessCharger te, ItemStack drop) {
        drop.func_77982_d(new NBTTagCompound());
        te.writeContentsToNBT(drop.func_77978_p());
        PainterUtil2.setSourceBlock(drop, this.getPaintSource(null, world, pos));
    }

    public IBlockState getFacade(IBlockAccess world, BlockPos pos, EnumFacing side) {
        IBlockState paintSource = this.getPaintSource(this.func_176223_P(), world, pos);
        return paintSource != null ? paintSource : world.func_180495_p(pos);
    }

    @Override
    public void setPaintSource(IBlockState state, IBlockAccess world, BlockPos pos, @Nullable IBlockState paintSource) {
        TileWirelessCharger te = (TileWirelessCharger)this.getTileEntity(world, pos);
        if (te != null) {
            te.setPaintSource(paintSource);
        }
    }

    @Override
    public void setPaintSource(Block block, ItemStack stack, @Nullable IBlockState paintSource) {
        PainterUtil2.setSourceBlock(stack, paintSource);
    }

    @Override
    public IBlockState getPaintSource(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileWirelessCharger te = (TileWirelessCharger)this.getTileEntitySafe(world, pos);
        if (te != null) {
            return te.getPaintSource();
        }
        return null;
    }

    @Override
    public IBlockState getPaintSource(Block block, ItemStack stack) {
        return PainterUtil2.getSourceBlock(stack);
    }

    public boolean canRenderInLayer(BlockRenderLayer layer) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(IBlockState state, World world, RayTraceResult target, ParticleManager effectRenderer) {
        return PaintHelper.addHitEffects(state, world, target, effectRenderer);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(World world, BlockPos pos, ParticleManager effectRenderer) {
        return PaintHelper.addDestroyEffects(world, pos, effectRenderer);
    }
}

