/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.material;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.StringUtils;

public enum MachinePart {
    MACHINE_CHASSI("machineChassi"),
    BASIC_GEAR("basicGear", "gearStone");

    @Nonnull
    public final String baseName;
    @Nonnull
    public final String unlocalisedName;
    @Nonnull
    public final String iconKey;
    @Nonnull
    public final String oreDict;

    public static List<ResourceLocation> resources() {
        ArrayList<ResourceLocation> res = new ArrayList<ResourceLocation>(MachinePart.values().length);
        for (MachinePart c : MachinePart.values()) {
            res.add(new ResourceLocation(c.iconKey));
        }
        return res;
    }

    private MachinePart(String baseName) {
        this(baseName, "item" + StringUtils.capitalize((String)baseName));
    }

    private MachinePart(String baseName, String oreDict) {
        this.baseName = baseName;
        this.unlocalisedName = "enderio." + baseName;
        this.iconKey = "enderio:" + baseName;
        this.oreDict = oreDict;
    }

    public static void registerOres(@Nonnull Item item) {
        for (MachinePart m : MachinePart.values()) {
            OreDictionary.registerOre((String)m.oreDict, (ItemStack)new ItemStack(item, 1, m.ordinal()));
        }
    }
}

