/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.material;

import crazypants.enderio.EnderIO;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.StringUtils;

public enum Material {
    SILICON("silicon"),
    CONDUIT_BINDER("conduitBinder"),
    BINDER_COMPOSITE("binderComposite"),
    PULSATING_IRON_NUGGET("pulsatingIronNugget"),
    VIBRANT_NUGGET("vibrantNugget"),
    PULSATING_CYSTAL("pulsatingCrystal", true),
    VIBRANT_CYSTAL("vibrantCrystal", true),
    DARK_GRINDING_BALL("darkGrindingBall"),
    ENDER_CRYSTAL("enderCrystal", true),
    ATTRACTOR_CRYSTAL("attractorCrystal", true),
    WEATHER_CRYSTAL("weatherCrystal", true),
    VIBRANT_POWDER("vibrantPowder", true),
    PULSATING_POWDER("pulsatingPowder", true),
    ENDER_CYSTAL_POWDER("enderCrystalPowder", true),
    NUTRITIOUS_STICK("nutritiousStick", false),
    PRECIENT_CRYSTAL("precientCrystal", true),
    PRECIENT_POWDER("precientPowder", true),
    CHASSIPARTS("chassiParts", false);

    @Nonnull
    public final String baseName;
    @Nonnull
    public final String unlocalisedName;
    @Nonnull
    public final String iconKey;
    @Nonnull
    public final String oreDict;
    public final boolean hasEffect;

    public static List<ResourceLocation> resources() {
        ArrayList<ResourceLocation> res = new ArrayList<ResourceLocation>(Material.values().length);
        for (Material c : Material.values()) {
            res.add(new ResourceLocation(c.iconKey));
        }
        return res;
    }

    private Material(String unlocalisedName) {
        this(unlocalisedName, false);
    }

    private Material(String baseName, boolean hasEffect) {
        this.baseName = baseName;
        this.unlocalisedName = "enderio." + baseName;
        this.iconKey = "enderio:" + baseName;
        this.hasEffect = hasEffect;
        this.oreDict = "item" + StringUtils.capitalize((String)baseName);
    }

    public static void registerOres(@Nonnull Item item) {
        for (Material m : Material.values()) {
            OreDictionary.registerOre((String)m.oreDict, (ItemStack)new ItemStack(item, 1, m.ordinal()));
        }
    }

    @Nonnull
    public ItemStack getStack() {
        return this.getStack(1);
    }

    @Nonnull
    public ItemStack getStack(int size) {
        return new ItemStack((Item)EnderIO.itemMaterial, size, this.ordinal());
    }
}

