/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.rail;

import com.enderio.core.api.client.gui.IResourceTooltipProvider;
import com.enderio.core.common.util.MetadataUtil;
import com.enderio.core.common.util.RoundRobinIterator;
import crazypants.enderio.EnderIO;
import crazypants.enderio.EnderIOTab;
import crazypants.enderio.ModObject;
import crazypants.enderio.config.Config;
import crazypants.enderio.machine.transceiver.Channel;
import crazypants.enderio.machine.transceiver.ChannelType;
import crazypants.enderio.machine.transceiver.ServerChannelRegister;
import crazypants.enderio.machine.transceiver.TileTransceiver;
import crazypants.enderio.network.PacketHandler;
import crazypants.enderio.rail.CartLinkUtil;
import crazypants.enderio.rail.PacketTeleportEffects;
import crazypants.enderio.rail.PlayerTeleportHandler;
import crazypants.enderio.rail.TeleportUtil;
import crazypants.enderio.tool.ToolUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRail;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;

public class BlockEnderRail
extends BlockRail
implements IResourceTooltipProvider {
    public static boolean isReverse(int meta) {
        return MetadataUtil.isBitSet((int)3, (int)meta);
    }

    public static EnumFacing getDirection(int meta) {
        EnumFacing result = BlockEnderRail.isEastWest(meta) ? EnumFacing.EAST : EnumFacing.SOUTH;
        if (BlockEnderRail.isReverse(meta)) {
            result = result.func_176734_d();
        }
        return result;
    }

    private static boolean isEastWest(int meta) {
        return MetadataUtil.isBitSet((int)0, (int)meta);
    }

    public static BlockEnderRail create() {
        PacketHandler.INSTANCE.registerMessage(PacketTeleportEffects.class, PacketTeleportEffects.class, PacketHandler.nextID(), Side.CLIENT);
        BlockEnderRail res = new BlockEnderRail();
        res.init();
        if (Config.enderRailTeleportPlayers) {
            MinecraftForge.EVENT_BUS.register((Object)PlayerTeleportHandler.instance);
        }
        return res;
    }

    protected BlockEnderRail() {
        this.func_149663_c(ModObject.blockEnderRail.getUnlocalisedName());
        this.setRegistryName(ModObject.blockEnderRail.getUnlocalisedName());
        this.func_149672_a(SoundType.field_185852_e);
        if (Config.transceiverEnabled && Config.enderRailEnabled) {
            this.func_149647_a(EnderIOTab.tabEnderIO);
        }
        this.func_149711_c(0.7f);
    }

    private void init() {
        GameRegistry.register((IForgeRegistryEntry)this);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, @Nullable ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (ToolUtil.isToolEquipped(player, hand)) {
            if (!world.field_72995_K) {
                // empty if block
            }
            return true;
        }
        return false;
    }

    public boolean rotateBlock(World world, BlockPos pos, EnumFacing axis) {
        return false;
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        TileEntity te;
        if (!world.field_72995_K && (te = world.func_175625_s(pos.func_177977_b())) instanceof TileTransceiver) {
            ((TileTransceiver)te).getRailController().dropNonSpawnedCarts();
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest);
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        return world.func_180495_p(pos.func_177977_b()).func_177230_c() == EnderIO.blockTransceiver;
    }

    public String getUnlocalizedNameForTooltip(ItemStack itemStack) {
        return this.func_149739_a();
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block neighborBlock) {
        if (world.field_72995_K) {
            return;
        }
    }

    public void onMinecartPass(World world, EntityMinecart cart, BlockPos pos) {
        if (world.field_72995_K) {
            return;
        }
        TileEntity te = world.func_175625_s(new BlockPos((Vec3i)pos.func_177977_b()));
        if (!(te instanceof TileTransceiver)) {
            return;
        }
        TileTransceiver ter = (TileTransceiver)te;
        if (ter.getRailController().isRecievedCart(cart)) {
            return;
        }
        this.tryTeleport(world, cart, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    private void tryTeleport(World world, EntityMinecart cart, int x, int y, int z) {
        TileEntity te = world.func_175625_s(new BlockPos(x, y - 1, z));
        if (!(te instanceof TileTransceiver)) {
            return;
        }
        TileTransceiver sender = (TileTransceiver)te;
        if (!sender.isRedstoneChecksPassed()) {
            return;
        }
        if (!sender.hasPower()) {
            return;
        }
        Set<Channel> sendChannels = sender.getSendChannels(ChannelType.RAIL);
        for (Channel channel : sendChannels) {
            RoundRobinIterator<TileTransceiver> iter = ServerChannelRegister.instance.getIterator(channel);
            for (TileTransceiver reciever : iter) {
                if (!this.isValidDestination(sender, channel, reciever)) continue;
                int requiredPower = this.getPowerRequired(cart, sender, reciever);
                if (sender.getEnergyStored(null) < requiredPower || !this.teleportCart(world, cart, sender, reciever)) continue;
                sender.usePower(requiredPower);
                return;
            }
        }
    }

    private boolean isValidDestination(TileTransceiver sender, Channel channel, TileTransceiver reciever) {
        if (reciever == sender) {
            return false;
        }
        if (!reciever.getRecieveChannels(ChannelType.RAIL).contains(channel)) {
            return false;
        }
        if (!reciever.isRedstoneChecksPassed() || !sender.isRedstoneChecksPassed()) {
            return false;
        }
        if (!reciever.hasPower()) {
            return false;
        }
        Block blk = reciever.func_145831_w().func_180495_p(reciever.func_174877_v()).func_177230_c();
        if (blk != this) {
            return false;
        }
        return reciever.getRailController().isClear();
    }

    private int getPowerRequired(EntityMinecart cart, TileTransceiver sender, TileTransceiver reciever) {
        int powerPerCart = this.getPowerRequiredForSingleCart(sender, reciever);
        int numCarts = CartLinkUtil.instance.getNumberOfCartsInTrain(cart);
        return powerPerCart * numCarts;
    }

    private int getPowerRequiredForSingleCart(TileTransceiver sender, TileTransceiver reciever) {
        int powerRequired = 0;
        if (sender.func_145831_w().field_73011_w.getDimension() != reciever.func_145831_w().field_73011_w.getDimension()) {
            powerRequired = Config.enderRailPowerRequireCrossDimensions;
        } else {
            powerRequired += sender.getLocation().getDist(reciever.getLocation()) * Config.enderRailPowerRequiredPerBlock;
            if (Config.enderRailCapSameDimensionPowerAtCrossDimensionCost) {
                powerRequired = Math.min(powerRequired, Config.enderRailPowerRequireCrossDimensions);
            }
        }
        return powerRequired;
    }

    private boolean teleportCart(World world, EntityMinecart cart, TileTransceiver sender, TileTransceiver reciever) {
        List<EntityMinecart> allCarts = CartLinkUtil.instance.getCartsInTrain(cart);
        if (allCarts.size() > 1) {
            CartLinkUtil.instance.updateCartLinks(world, cart);
        }
        ArrayList<List<Entity>> toTeleport = new ArrayList<List<Entity>>(allCarts.size());
        ArrayList<EntityMinecart> toDespawn = new ArrayList<EntityMinecart>(allCarts.size());
        for (EntityMinecart cartInTrain : allCarts) {
            List<Entity> entities;
            if (cartInTrain == null || (entities = TeleportUtil.createEntitiesForReciever(cartInTrain, sender, reciever)) == null) continue;
            toTeleport.add(entities);
            toDespawn.add(cartInTrain);
        }
        for (EntityMinecart despawnCart : toDespawn) {
            TeleportUtil.spawnTeleportEffects(world, (Entity)despawnCart);
            TeleportUtil.despawn(sender.func_145831_w(), despawnCart);
        }
        reciever.getRailController().onTrainRecieved(toTeleport);
        return true;
    }
}

