/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.render.util;

import com.enderio.core.api.client.render.VertexTransform;
import com.enderio.core.client.render.BoundingBox;
import com.enderio.core.client.render.IconUtil;
import com.enderio.core.client.render.RenderUtil;
import com.enderio.core.common.vecmath.Vector4f;
import com.enderio.core.common.vecmath.Vertex;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.client.model.pipeline.LightUtil;
import net.minecraftforge.client.model.pipeline.UnpackedBakedQuad;

public class HalfBakedQuad {
    private final List<Vertex> corners;
    private final TextureAtlasSprite tex;
    private final Vector4f color;
    private final EnumFacing face;
    private static final Vector4f NO_COLOR = new Vector4f(1.0f, 1.0f, 1.0f, 1.0f);
    private static boolean hasMojangFixedUVXWTextureCoords = false;

    public HalfBakedQuad(BoundingBox bb, EnumFacing face, float umin, float umax, float vmin, float vmax, TextureAtlasSprite tex, Vector4f color) {
        this.corners = bb.getCornersWithUvForFace(face, umin, umax, vmin, vmax);
        this.tex = tex != null ? tex : IconUtil.instance.errorTexture;
        this.color = color != null ? color : NO_COLOR;
        this.face = face;
    }

    public void bake(List<BakedQuad> quads) {
        float w01 = 1.0f;
        float w23 = 1.0f;
        if (hasMojangFixedUVXWTextureCoords && this.face != EnumFacing.DOWN && this.face != EnumFacing.UP) {
            w01 = (float)this.corners.get((int)0).xyz.distance(this.corners.get((int)1).xyz);
            w23 = (float)this.corners.get((int)2).xyz.distance(this.corners.get((int)3).xyz);
        }
        UnpackedBakedQuad.Builder builder = new UnpackedBakedQuad.Builder(DefaultVertexFormats.field_176599_b);
        builder.setQuadOrientation(this.face);
        builder.setTexture(this.tex);
        this.putVertexData(builder, this.corners.get(0), w01);
        this.putVertexData(builder, this.corners.get(1), w01);
        this.putVertexData(builder, this.corners.get(2), w23);
        this.putVertexData(builder, this.corners.get(3), w23);
        quads.add((BakedQuad)builder.build());
    }

    private void putVertexData(UnpackedBakedQuad.Builder builder, Vertex v, float w) {
        VertexFormat format = builder.getVertexFormat();
        block6: for (int e = 0; e < format.func_177345_h(); ++e) {
            switch (format.func_177348_c(e).func_177375_c()) {
                case POSITION: {
                    builder.put(e, new float[]{(float)v.x(), (float)v.y(), (float)v.z(), 1.0f});
                    continue block6;
                }
                case COLOR: {
                    float d = LightUtil.diffuseLight((float)v.nx(), (float)v.ny(), (float)v.nz());
                    builder.put(e, new float[]{d * this.color.x, d * this.color.y, d * this.color.z, this.color.w});
                    continue block6;
                }
                case UV: {
                    builder.put(e, new float[]{this.tex.func_94214_a((double)(v.u() * 16.0f)) * w, this.tex.func_94207_b((double)(v.v() * 16.0f)) * w, 0.0f, w});
                    continue block6;
                }
                case NORMAL: {
                    builder.put(e, new float[]{v.nx(), v.ny(), v.nz(), 0.0f});
                    continue block6;
                }
                default: {
                    builder.put(e, new float[0]);
                }
            }
        }
    }

    public void transform(VertexTransform ... xforms) {
        for (Vertex vertex : this.corners) {
            for (VertexTransform xform : xforms) {
                xform.apply(vertex);
            }
        }
    }

    public void render(VertexBuffer tes) {
        for (Vertex v : this.corners) {
            tes.func_181662_b(v.x(), v.y(), v.z()).func_187315_a((double)this.tex.func_94214_a((double)(v.u() * 16.0f)), (double)this.tex.func_94207_b((double)(v.v() * 16.0f))).func_181666_a(this.color.x, this.color.y, this.color.z, this.color.w).func_181663_c(v.nx(), v.ny(), v.nz()).func_181675_d();
        }
    }

    public static class HalfBakedList
    extends AbstractList<HalfBakedQuad> {
        private final List<HalfBakedQuad> store = new ArrayList<HalfBakedQuad>();

        @Override
        public HalfBakedQuad get(int index) {
            return this.store.get(index);
        }

        @Override
        public int size() {
            return this.store.size();
        }

        public void add(BoundingBox bb, EnumFacing face, float umin, float umax, float vmin, float vmax, TextureAtlasSprite tex, Vector4f color) {
            this.store.add(new HalfBakedQuad(bb, face, umin, umax, vmin, vmax, tex, color));
        }

        public void add(BoundingBox bb, EnumFacing face, double umin, double umax, double vmin, double vmax, TextureAtlasSprite tex, Vector4f color) {
            this.store.add(new HalfBakedQuad(bb, face, (float)umin, (float)umax, (float)vmin, (float)vmax, tex, color));
        }

        public void transform(VertexTransform ... xforms) {
            for (HalfBakedQuad halfBakedQuad : this.store) {
                halfBakedQuad.transform(xforms);
            }
        }

        public void bake(List<BakedQuad> quads, VertexTransform ... xforms) {
            for (HalfBakedQuad halfBakedQuad : this.store) {
                halfBakedQuad.transform(xforms);
                halfBakedQuad.bake(quads);
            }
        }

        public void bake(List<BakedQuad> quads) {
            for (HalfBakedQuad halfBakedQuad : this.store) {
                halfBakedQuad.bake(quads);
            }
        }

        public void render(VertexBuffer tes) {
            for (HalfBakedQuad halfBakedQuad : this.store) {
                halfBakedQuad.render(tes);
            }
        }

        public void render() {
            RenderUtil.bindBlockTexture();
            RenderHelper.func_74518_a();
            VertexBuffer tes = Tessellator.func_178181_a().func_178180_c();
            for (int i = 0; i <= 1; ++i) {
                if (i == 0) {
                    GlStateManager.func_187407_a((GlStateManager.CullFace)GlStateManager.CullFace.FRONT);
                } else {
                    GlStateManager.func_187407_a((GlStateManager.CullFace)GlStateManager.CullFace.BACK);
                }
                tes.func_181668_a(7, DefaultVertexFormats.field_181712_l);
                this.render(tes);
                Tessellator.func_178181_a().func_78381_a();
            }
            RenderHelper.func_74519_b();
        }
    }
}

