/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.render.util;

import com.enderio.core.client.render.BoundingBox;
import com.enderio.core.common.vecmath.Vector4f;
import crazypants.enderio.render.util.HalfBakedQuad;
import crazypants.enderio.tool.SmartTank;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;

public class TankRenderHelper {
    private static final Double px = 0.0625;

    public static HalfBakedQuad.HalfBakedList mkTank(SmartTank tank, double xzBorder, double miny, double maxy, boolean renderBottom) {
        float ratio;
        if (tank != null && (ratio = tank.getFilledRatio()) > 0.0f) {
            TextureAtlasSprite sprite;
            float height = 1.0f - ratio;
            ResourceLocation still = tank.getFluid().getFluid().getStill(tank.getFluid());
            int color = tank.getFluid().getFluid().getColor(tank.getFluid());
            Vector4f vecC = new Vector4f((double)(color >> 16 & 0xFF) / 255.0, (double)(color >> 8 & 0xFF) / 255.0, (double)(color & 0xFF) / 255.0, 1.0);
            TextureAtlasSprite textureAtlasSprite = sprite = still == null ? null : Minecraft.func_71410_x().func_147117_R().getTextureExtry(still.toString());
            if (sprite == null) {
                sprite = Minecraft.func_71410_x().func_147117_R().func_174944_f();
            }
            BoundingBox bb = new BoundingBox(xzBorder * px, miny * px, xzBorder * px, (16.0 - xzBorder) * px, ((maxy - miny) * (double)ratio + miny) * px, (16.0 - xzBorder) * px);
            HalfBakedQuad.HalfBakedList buffer = new HalfBakedQuad.HalfBakedList();
            buffer.add(bb, EnumFacing.NORTH, 0.0f, 1.0f, height, 1.0f, sprite, vecC);
            buffer.add(bb, EnumFacing.EAST, 0.0f, 1.0f, height, 1.0f, sprite, vecC);
            buffer.add(bb, EnumFacing.SOUTH, 0.0f, 1.0f, height, 1.0f, sprite, vecC);
            buffer.add(bb, EnumFacing.WEST, 0.0f, 1.0f, height, 1.0f, sprite, vecC);
            buffer.add(bb, EnumFacing.UP, 0.0f, 1.0f, 0.0f, 1.0f, sprite, vecC);
            if (renderBottom) {
                buffer.add(bb, EnumFacing.DOWN, 0.0f, 1.0f, 0.0f, 1.0f, sprite, vecC);
            }
            return buffer;
        }
        return null;
    }
}

