/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.teleport.anchor;

import com.enderio.core.api.client.gui.IResourceTooltipProvider;
import com.enderio.core.common.util.ChatUtil;
import crazypants.enderio.BlockEio;
import crazypants.enderio.EnderIO;
import crazypants.enderio.ModObject;
import crazypants.enderio.api.teleport.ITravelAccessable;
import crazypants.enderio.config.Config;
import crazypants.enderio.network.PacketHandler;
import crazypants.enderio.paint.IPaintable;
import crazypants.enderio.paint.PainterUtil2;
import crazypants.enderio.paint.render.PaintHelper;
import crazypants.enderio.render.IBlockStateWrapper;
import crazypants.enderio.render.IRenderMapper;
import crazypants.enderio.render.ISmartRenderAwareBlock;
import crazypants.enderio.render.pipeline.BlockStateWrapperBase;
import crazypants.enderio.render.property.EnumRenderMode;
import crazypants.enderio.render.registry.SmartModelAttacher;
import crazypants.enderio.teleport.ContainerTravelAccessable;
import crazypants.enderio.teleport.ContainerTravelAuth;
import crazypants.enderio.teleport.GuiTravelAccessable;
import crazypants.enderio.teleport.GuiTravelAuth;
import crazypants.enderio.teleport.anchor.TileTravelAnchor;
import crazypants.enderio.teleport.packet.PacketAccessMode;
import crazypants.enderio.teleport.packet.PacketDrainStaff;
import crazypants.enderio.teleport.packet.PacketLabel;
import crazypants.enderio.teleport.packet.PacketOpenAuthGui;
import crazypants.enderio.teleport.packet.PacketPassword;
import crazypants.enderio.teleport.packet.PacketTravelEvent;
import crazypants.enderio.teleport.telepad.render.TelePadRenderMapper;
import crazypants.util.UserIdent;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockTravelAnchor<T extends TileTravelAnchor>
extends BlockEio<T>
implements IGuiHandler,
ITileEntityProvider,
IResourceTooltipProvider,
ISmartRenderAwareBlock,
IPaintable.IBlockPaintableBlock,
IPaintable.IWrenchHideablePaint {
    public static BlockTravelAnchor<TileTravelAnchor> create() {
        PacketHandler.INSTANCE.registerMessage(PacketAccessMode.class, PacketAccessMode.class, PacketHandler.nextID(), Side.SERVER);
        PacketHandler.INSTANCE.registerMessage(PacketLabel.class, PacketLabel.class, PacketHandler.nextID(), Side.SERVER);
        PacketHandler.INSTANCE.registerMessage(PacketTravelEvent.class, PacketTravelEvent.class, PacketHandler.nextID(), Side.SERVER);
        PacketHandler.INSTANCE.registerMessage(PacketDrainStaff.class, PacketDrainStaff.class, PacketHandler.nextID(), Side.SERVER);
        PacketHandler.INSTANCE.registerMessage(PacketOpenAuthGui.class, PacketOpenAuthGui.class, PacketHandler.nextID(), Side.SERVER);
        PacketHandler.INSTANCE.registerMessage(PacketPassword.Handler.class, PacketPassword.class, PacketHandler.nextID(), Side.SERVER);
        BlockTravelAnchor<TileTravelAnchor> result = new BlockTravelAnchor<TileTravelAnchor>(TileTravelAnchor.class);
        result.init();
        return result;
    }

    private BlockTravelAnchor(Class<T> clz) {
        super(ModObject.blockTravelAnchor.getUnlocalisedName(), clz);
        if (!Config.travelAnchorEnabled) {
            this.func_149647_a(null);
        }
        this.initDefaultState();
    }

    protected void initDefaultState() {
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(EnumRenderMode.RENDER, (Comparable)((Object)EnumRenderMode.AUTO)));
    }

    public BlockTravelAnchor(@Nonnull String unlocalisedName, Class<T> teClass) {
        super(unlocalisedName, teClass);
        this.initDefaultState();
    }

    protected final void init() {
        super.init();
        this.registerGuiHandlers();
        this.registerInSmartModelAttacher();
    }

    protected void registerGuiHandlers() {
        EnderIO.guiHandler.registerGuiHandler(18, this);
        EnderIO.guiHandler.registerGuiHandler(19, this);
    }

    protected void registerInSmartModelAttacher() {
        SmartModelAttacher.register((Block)this);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{EnumRenderMode.RENDER});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P();
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return this.func_176223_P();
    }

    @SideOnly(value=Side.CLIENT)
    public final IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (state != null && world != null && pos != null) {
            BlockStateWrapperBase blockStateWrapper = this.createBlockStateWrapper(state, world, pos);
            TileTravelAnchor tileEntity = (TileTravelAnchor)this.getTileEntitySafe(world, pos);
            if (tileEntity != null) {
                this.setBlockStateWrapperCache(blockStateWrapper, world, pos, tileEntity);
            }
            blockStateWrapper.bakeModel();
            return blockStateWrapper;
        }
        return state;
    }

    protected void setBlockStateWrapperCache(@Nonnull IBlockStateWrapper blockStateWrapper, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull T tileEntity) {
        blockStateWrapper.addCacheKey(0);
    }

    @Nonnull
    protected BlockStateWrapperBase createBlockStateWrapper(@Nonnull IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
        return new BlockStateWrapperBase(state, world, pos, this.getBlockRenderMapper());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IRenderMapper.IItemRenderMapper getItemRenderMapper() {
        return TelePadRenderMapper.instance;
    }

    @SideOnly(value=Side.CLIENT)
    public IRenderMapper.IBlockRenderMapper getBlockRenderMapper() {
        return TelePadRenderMapper.instance;
    }

    public TileEntity func_149915_a(World var1, int var2) {
        return new TileTravelAnchor();
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase entity, ItemStack stack) {
        TileEntity te;
        if (entity instanceof EntityPlayer && (te = world.func_175625_s(pos)) instanceof TileTravelAnchor) {
            TileTravelAnchor ta = (TileTravelAnchor)te;
            ta.setPlacedBy((EntityPlayer)entity);
            IBlockState bs = PainterUtil2.getSourceBlock(stack);
            ta.setPaintSource(bs);
            te.func_145831_w().func_184138_a(pos, state, state, 3);
        }
    }

    protected boolean openGui(World world, BlockPos pos, EntityPlayer entityPlayer, EnumFacing side) {
        TileEntity te = world.func_175625_s(pos);
        if (!world.field_72995_K && te instanceof ITravelAccessable) {
            ITravelAccessable ta = (ITravelAccessable)te;
            if (ta.canUiBeAccessed(entityPlayer)) {
                entityPlayer.openGui((Object)EnderIO.instance, 18, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            } else {
                BlockTravelAnchor.sendPrivateChatMessage(entityPlayer, ta.getOwner());
            }
        }
        return true;
    }

    public static void sendPrivateChatMessage(EntityPlayer player, UserIdent owner) {
        if (!player.func_70093_af()) {
            ChatUtil.sendNoSpam((EntityPlayer)player, (String[])new String[]{EnderIO.lang.localize("gui.travelAccessable.privateBlock1") + " " + TextFormatting.RED + owner.getPlayerName() + TextFormatting.WHITE + " " + EnderIO.lang.localize("gui.travelAccessable.privateBlock2")});
        }
    }

    public Object getServerGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        TileEntity te = world.func_175625_s(new BlockPos(x, y, z));
        if (te instanceof ITravelAccessable) {
            if (ID == 18) {
                return new ContainerTravelAccessable(player.field_71071_by, (ITravelAccessable)te, world);
            }
            return new ContainerTravelAuth(player.field_71071_by);
        }
        return null;
    }

    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        TileEntity te = world.func_175625_s(new BlockPos(x, y, z));
        if (te instanceof ITravelAccessable) {
            if (ID == 18) {
                return new GuiTravelAccessable(player.field_71071_by, (ITravelAccessable)te, world);
            }
            return new GuiTravelAuth(player, (ITravelAccessable)te, world);
        }
        return null;
    }

    protected void processDrop(IBlockAccess world, BlockPos pos, @Nullable TileTravelAnchor anchor, ItemStack drop) {
        PainterUtil2.setSourceBlock(drop, this.getPaintSource(null, world, pos));
    }

    public boolean doNormalDrops(IBlockAccess world, BlockPos pos) {
        return false;
    }

    public String getUnlocalizedNameForTooltip(ItemStack itemStack) {
        return this.func_149739_a();
    }

    public boolean func_149662_c(IBlockState bs) {
        return false;
    }

    public IBlockState getFacade(IBlockAccess world, BlockPos pos, EnumFacing side) {
        IBlockState paintSource = this.getPaintSource(this.func_176223_P(), world, pos);
        return paintSource != null ? paintSource : world.func_180495_p(pos);
    }

    @Override
    public void setPaintSource(IBlockState state, IBlockAccess world, BlockPos pos, @Nullable IBlockState paintSource) {
        TileTravelAnchor te = (TileTravelAnchor)this.getTileEntity(world, pos);
        if (te != null) {
            te.setPaintSource(paintSource);
        }
    }

    @Override
    public void setPaintSource(Block block, ItemStack stack, @Nullable IBlockState paintSource) {
        PainterUtil2.setSourceBlock(stack, paintSource);
    }

    @Override
    public IBlockState getPaintSource(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileTravelAnchor te = (TileTravelAnchor)this.getTileEntitySafe(world, pos);
        if (te != null) {
            return te.getPaintSource();
        }
        return null;
    }

    @Override
    public IBlockState getPaintSource(Block block, ItemStack stack) {
        return PainterUtil2.getSourceBlock(stack);
    }

    public boolean canRenderInLayer(BlockRenderLayer layer) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(IBlockState state, World world, RayTraceResult target, ParticleManager effectRenderer) {
        return PaintHelper.addHitEffects(state, world, target, effectRenderer);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(World world, BlockPos pos, ParticleManager effectRenderer) {
        return PaintHelper.addDestroyEffects(world, pos, effectRenderer);
    }
}

