/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.teleport.telepad;

import com.enderio.core.common.util.BlockCoord;
import crazypants.enderio.EnderIO;
import crazypants.enderio.EnderIOTab;
import crazypants.enderio.network.PacketHandler;
import crazypants.enderio.teleport.anchor.BlockTravelAnchor;
import crazypants.enderio.teleport.telepad.TelepadTarget;
import crazypants.enderio.teleport.telepad.TileDialingDevice;
import crazypants.enderio.teleport.telepad.TileTelePad;
import crazypants.enderio.teleport.telepad.gui.GuiLocationPrintout;
import crazypants.enderio.teleport.telepad.packet.PacketUpdateLocationPrintout;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;

public class ItemLocationPrintout
extends Item
implements IGuiHandler {
    public static final String NAME = "itemLocationPrintout";

    public static ItemLocationPrintout create() {
        PacketHandler.INSTANCE.registerMessage(PacketUpdateLocationPrintout.class, PacketUpdateLocationPrintout.class, PacketHandler.nextID(), Side.SERVER);
        ItemLocationPrintout result = new ItemLocationPrintout();
        EnderIO.guiHandler.registerGuiHandler(206, result);
        EnderIO.guiHandler.registerGuiHandler(207, result);
        GameRegistry.register((IForgeRegistryEntry)result);
        return result;
    }

    protected ItemLocationPrintout() {
        this.func_77637_a(EnderIOTab.tabEnderIO);
        this.func_77655_b(NAME);
        this.setRegistryName(NAME);
        this.func_77625_d(1);
    }

    public boolean doesSneakBypassUse(ItemStack stack, IBlockAccess world, BlockPos pos, EntityPlayer player) {
        return true;
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack stack, World world, EntityPlayer player, EnumHand hand) {
        if (player.func_70093_af()) {
            player.openGui((Object)EnderIO.instance, 206, world, hand.ordinal(), 0, 0);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return new ActionResult(EnumActionResult.PASS, (Object)stack);
    }

    public EnumActionResult func_180614_a(ItemStack stack, EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TelepadTarget targ = TelepadTarget.readFromNBT(stack);
        if (targ == null) {
            player.func_145747_a((ITextComponent)new TextComponentString("No location? but how.."));
            return EnumActionResult.SUCCESS;
        }
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof TileTelePad) {
            TileTelePad tile = (TileTelePad)te;
            return this.onTelepadClicked(stack, player, worldIn, tile, targ);
        }
        if (te instanceof TileDialingDevice) {
            TileDialingDevice dd = (TileDialingDevice)te;
            dd.addTarget(targ);
            if (worldIn.field_72995_K) {
                player.func_145747_a((ITextComponent)new TextComponentString(EnderIO.lang.localizeExact("item.itemLocationPrintout.chat.addTarget") + " " + targ.getChatString()));
            }
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    private EnumActionResult onTelepadClicked(ItemStack stack, EntityPlayer player, World worldIn, TileTelePad tile, TelepadTarget targ) {
        if (tile.canBlockBeAccessed(player)) {
            tile.setTarget(targ);
            if (worldIn.field_72995_K) {
                player.func_145747_a((ITextComponent)new TextComponentString(EnderIO.lang.localizeExact("item.itemLocationPrintout.chat.setTarget") + " " + targ.getChatString()));
            }
        } else {
            BlockTravelAnchor.sendPrivateChatMessage(player, tile.getOwner());
        }
        return EnumActionResult.SUCCESS;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List<String> list, boolean p_77624_4_) {
        TelepadTarget target;
        if (stack != null && stack.func_77978_p() != null && !stack.func_77978_p().func_74767_n("default") && (target = TelepadTarget.readFromNBT(stack.func_77978_p())) != null && target.getLocation() != null) {
            list.add(new BlockCoord(target.getLocation()).chatString(TextFormatting.GRAY));
            list.add(TelepadTarget.getDimenionName(target.getDimension()));
        }
        super.func_77624_a(stack, player, list, p_77624_4_);
    }

    public Object getServerGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return null;
    }

    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        if (ID == 207) {
            boolean foundPaper = false;
            for (int paperIndex = 0; paperIndex < player.field_71069_bz.field_75151_b.size() && !foundPaper; ++paperIndex) {
                ItemStack invItem = ((Slot)player.field_71069_bz.field_75151_b.get(paperIndex)).func_75211_c();
                if (invItem == null || invItem.func_77973_b() != Items.field_151121_aF) continue;
                ((Slot)player.field_71069_bz.field_75151_b.get(paperIndex)).func_75209_a(1);
                player.field_71069_bz.func_75142_b();
                foundPaper = true;
            }
            if (!foundPaper) {
                player.func_145747_a((ITextComponent)new TextComponentString(EnderIO.lang.localizeExact("item.itemLocationPrintout.chat.noPaper")));
                return null;
            }
            TelepadTarget target = new TelepadTarget(new BlockPos(x, y, z), world.field_73011_w.getDimension());
            ItemStack stack = new ItemStack((Item)this);
            target.writeToNBT(stack);
            return new GuiLocationPrintout(stack);
        }
        EnumHand hand = x == 0 ? EnumHand.MAIN_HAND : EnumHand.OFF_HAND;
        EntityEquipmentSlot slot = hand == EnumHand.MAIN_HAND ? EntityEquipmentSlot.MAINHAND : EntityEquipmentSlot.OFFHAND;
        return new GuiLocationPrintout(player, slot);
    }
}

