/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.tool;

import com.enderio.core.api.common.util.ITankAccess;
import com.enderio.core.common.util.FluidUtil;
import com.google.common.base.Strings;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidEvent;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidTank;

public class SmartTank
extends FluidTank {
    protected Fluid restriction;

    public SmartTank(FluidStack liquid, int capacity) {
        super(liquid, capacity);
        this.restriction = liquid != null ? liquid.getFluid() : null;
    }

    public SmartTank(int capacity) {
        super(capacity);
    }

    public SmartTank(Fluid liquid, int capacity) {
        super(capacity);
        this.restriction = liquid;
    }

    public void setRestriction(Fluid restriction) {
        this.restriction = restriction;
    }

    public float getFilledRatio() {
        return (float)this.getFluidAmount() / (float)this.getCapacity();
    }

    public boolean isFull() {
        return this.getFluidAmount() >= this.getCapacity();
    }

    public boolean isEmpty() {
        return this.getFluidAmount() == 0;
    }

    public boolean canDrain(Fluid fl) {
        if (this.fluid == null || fl == null || !this.canDrain()) {
            return false;
        }
        return FluidUtil.areFluidsTheSame((Fluid)fl, (Fluid)this.fluid.getFluid());
    }

    public boolean canDrain(FluidStack fluidStack) {
        if (this.fluid == null || fluidStack == null || !this.canDrain()) {
            return false;
        }
        return fluidStack.isFluidEqual(this.fluid);
    }

    public boolean canFill(FluidStack resource) {
        if (!this.canFillFluidType(resource)) {
            return false;
        }
        if (this.fluid != null) {
            return this.fluid.isFluidEqual(resource);
        }
        return true;
    }

    public boolean canFill(Fluid fl) {
        if (fl == null || !this.canFillFluidType(new FluidStack(fl, 1))) {
            return false;
        }
        if (this.fluid != null) {
            return FluidUtil.areFluidsTheSame((Fluid)this.fluid.getFluid(), (Fluid)fl);
        }
        return true;
    }

    public boolean canFillFluidType(FluidStack resource) {
        return super.canFillFluidType(resource) && (this.restriction == null || resource != null && resource.getFluid() != null && FluidUtil.areFluidsTheSame((Fluid)this.restriction, (Fluid)resource.getFluid()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setFluidAmount(int amount) {
        if (amount > 0) {
            if (this.fluid != null) {
                this.fluid.amount = Math.min(this.capacity, amount);
            } else {
                if (this.restriction == null) throw new RuntimeException("Cannot set fluid amount of an empty tank");
                this.setFluid(new FluidStack(this.restriction, Math.min(this.capacity, amount)));
            }
        } else {
            this.setFluid(null);
        }
        this.onContentsChanged();
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (!this.canFill(resource)) {
            return 0;
        }
        return this.fillInternal(resource, doFill);
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        return super.drain(resource, doDrain);
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        return super.drain(maxDrain, doDrain);
    }

    public FluidStack getFluid() {
        if (this.fluid != null) {
            return this.fluid;
        }
        if (this.restriction != null) {
            return new FluidStack(this.restriction, 0);
        }
        return null;
    }

    public int getAvailableSpace() {
        return this.getCapacity() - this.getFluidAmount();
    }

    public void addFluidAmount(int amount) {
        this.setFluidAmount(this.getFluidAmount() + amount);
        if (this.tile != null) {
            FluidEvent.fireEvent((FluidEvent)new FluidEvent.FluidFillingEvent(this.fluid, this.tile.func_145831_w(), this.tile.func_174877_v(), (IFluidTank)this, amount));
        }
    }

    public int removeFluidAmount(int amount) {
        int drained = 0;
        if (this.getFluidAmount() > amount) {
            this.setFluidAmount(this.getFluidAmount() - amount);
            drained = amount;
        } else if (!this.isEmpty()) {
            drained = this.getFluidAmount();
            this.setFluidAmount(0);
        } else {
            return 0;
        }
        if (this.tile != null) {
            FluidEvent.fireEvent((FluidEvent)new FluidEvent.FluidDrainingEvent(this.fluid, this.tile.func_145831_w(), this.tile.func_174877_v(), (IFluidTank)this, drained));
        }
        return drained;
    }

    public void setCapacity(int capacity) {
        super.setCapacity(capacity);
        if (this.getFluidAmount() > capacity) {
            this.setFluidAmount(capacity);
        }
    }

    public void writeCommon(String name, NBTTagCompound nbtRoot) {
        NBTTagCompound tankRoot = new NBTTagCompound();
        this.writeToNBT(tankRoot);
        if (this.restriction != null) {
            tankRoot.func_74778_a("FluidRestriction", this.restriction.getName());
        }
        tankRoot.func_74768_a("Capacity", this.capacity);
        nbtRoot.func_74782_a(name, (NBTBase)tankRoot);
    }

    public void readCommon(String name, NBTTagCompound nbtRoot) {
        NBTTagCompound tankRoot = (NBTTagCompound)nbtRoot.func_74781_a(name);
        if (tankRoot != null) {
            String fluidName;
            this.readFromNBT(tankRoot);
            if (tankRoot.func_74764_b("FluidRestriction") && !Strings.isNullOrEmpty((String)(fluidName = tankRoot.func_74779_i("FluidRestriction")))) {
                this.restriction = FluidRegistry.getFluid((String)fluidName);
            }
            if (tankRoot.func_74764_b("Capacity")) {
                this.capacity = tankRoot.func_74762_e("Capacity");
            }
        } else {
            this.setFluid(null);
        }
    }

    public static SmartTank createFromNBT(String name, NBTTagCompound nbtRoot) {
        SmartTank result = new SmartTank(0);
        result.readCommon(name, nbtRoot);
        if (result.getFluidAmount() > result.getCapacity()) {
            result.setCapacity(result.getFluidAmount());
        }
        return result;
    }

    protected void onContentsChanged() {
        super.onContentsChanged();
        if (this.tile instanceof ITankAccess) {
            ((ITankAccess)this.tile).setTanksDirty();
        } else if (this.tile != null) {
            this.tile.func_70296_d();
        }
    }
}

