/*
 * Decompiled with CFR 0.152.
 */
package crazypants.util;

import com.enderio.core.common.util.DyeColor;
import com.enderio.core.common.util.EntityUtil;
import crazypants.enderio.EnderIO;
import crazypants.enderio.config.Config;
import crazypants.enderio.item.darksteel.DarkSteelItems;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFence;
import net.minecraft.block.BlockFenceGate;
import net.minecraft.block.BlockWall;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.monster.SkeletonType;
import net.minecraft.entity.monster.ZombieType;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.fml.common.registry.VillagerRegistry;

public class CapturedMob {
    public static final String SKELETON_ENTITY_NAME = "Skeleton";
    public static final String ZOMBIE_ENTITY_NAME = "Zombie";
    public static final String ENTITY_KEY = "entity";
    public static final String ENTITY_ID_KEY = "entityId";
    public static final String CUSTOM_NAME_KEY = "customName";
    public static final String IS_STUB_KEY = "isStub";
    public static final String VARIANT_KEY = "isVariant";
    private static final List<String> blacklist = new ArrayList<String>();
    private final NBTTagCompound entityNbt;
    private final String entityId;
    private final String customName;
    private final boolean isStub;
    private Enum<?> variant;

    private CapturedMob(@Nonnull EntityLivingBase entity) {
        EntityLiving entLiv;
        this.entityId = EntityList.func_75621_b((Entity)entity);
        this.entityNbt = entity.serializeNBT();
        String name = null;
        if (entity instanceof EntityLiving && (entLiv = (EntityLiving)entity).func_145818_k_()) {
            name = entLiv.func_95999_t();
        }
        this.customName = name != null && name.length() > 0 ? name : null;
        this.variant = entity instanceof EntitySkeleton ? ((EntitySkeleton)entity).func_189771_df() : (entity instanceof EntityZombie ? ((EntityZombie)entity).func_189777_di() : null);
        this.isStub = false;
    }

    private CapturedMob(NBTTagCompound nbt) {
        this.entityNbt = nbt.func_74764_b(ENTITY_KEY) ? nbt.func_74775_l(ENTITY_KEY).func_74737_b() : null;
        this.entityId = nbt.func_74764_b(ENTITY_ID_KEY) ? nbt.func_74779_i(ENTITY_ID_KEY) : null;
        this.customName = nbt.func_74764_b(CUSTOM_NAME_KEY) ? nbt.func_74779_i(CUSTOM_NAME_KEY) : null;
        this.isStub = nbt.func_74767_n(IS_STUB_KEY);
        if (nbt.func_74764_b(VARIANT_KEY)) {
            short ord = nbt.func_74765_d(VARIANT_KEY);
            this.variant = this.mkEnumForType(ord);
        } else {
            this.variant = null;
        }
    }

    private CapturedMob(String entityId, Enum<?> variant) {
        this.entityNbt = null;
        this.entityId = entityId;
        this.customName = null;
        this.isStub = true;
        this.variant = variant;
    }

    @Nullable
    public static CapturedMob create(@Nullable Entity entity) {
        if (!(entity instanceof EntityLivingBase) || entity.field_70170_p == null || entity.field_70170_p.field_72995_K || entity instanceof EntityPlayer || CapturedMob.isBlacklisted(entity)) {
            return null;
        }
        return new CapturedMob((EntityLivingBase)entity);
    }

    @Nullable
    public static CapturedMob create(@Nullable String entityId, Enum<?> variant) {
        if (entityId == null || !EntityList.func_180125_b((String)entityId)) {
            return null;
        }
        return new CapturedMob(entityId, variant);
    }

    @Nonnull
    public ItemStack toStack(Item item, int meta, int amount) {
        ItemStack stack = new ItemStack(item, amount, meta);
        stack.func_77982_d(this.toNbt(null));
        if (item == EnderIO.itemSoulVessel && this.customName == null && "Pig".equals(this.entityId) && Math.random() < 0.01) {
            stack.func_77978_p().func_74778_a(CUSTOM_NAME_KEY, EnderIO.lang.localize("easteregg.piginabottle"));
        }
        return stack;
    }

    @Nonnull
    public NBTTagCompound toNbt(@Nullable NBTTagCompound nbt) {
        NBTTagCompound data;
        NBTTagCompound nBTTagCompound = data = nbt != null ? nbt : new NBTTagCompound();
        if (this.entityNbt != null) {
            data.func_74782_a(ENTITY_KEY, (NBTBase)this.entityNbt.func_74737_b());
        }
        if (this.entityId != null) {
            data.func_74778_a(ENTITY_ID_KEY, this.entityId);
        }
        if (this.customName != null) {
            data.func_74778_a(CUSTOM_NAME_KEY, this.customName);
        }
        if (this.isStub) {
            data.func_74757_a(IS_STUB_KEY, this.isStub);
        }
        if (this.variant != null) {
            data.func_74777_a(VARIANT_KEY, (short)this.variant.ordinal());
        }
        return data;
    }

    public static boolean containsSoul(@Nullable NBTTagCompound nbt) {
        return nbt != null && (nbt.func_74764_b(ENTITY_KEY) || nbt.func_74764_b(ENTITY_ID_KEY) && nbt.func_74764_b(IS_STUB_KEY));
    }

    public static boolean containsSoul(@Nullable ItemStack stack) {
        return stack != null && stack.func_77942_o() && CapturedMob.containsSoul(stack.func_77978_p());
    }

    @Nullable
    public static CapturedMob create(@Nullable ItemStack stack) {
        if (CapturedMob.containsSoul(stack)) {
            return new CapturedMob(stack.func_77978_p());
        }
        return null;
    }

    @Nullable
    public static CapturedMob create(@Nullable NBTTagCompound nbt) {
        if (CapturedMob.containsSoul(nbt)) {
            return new CapturedMob(nbt);
        }
        return null;
    }

    public static boolean isBlacklisted(@Nonnull Entity entity) {
        String entityId = EntityList.func_75621_b((Entity)entity);
        if (entityId == null || entityId.trim().isEmpty() || !Config.soulVesselCapturesBosses && !entity.func_184222_aU()) {
            return true;
        }
        return Config.soulVesselBlackList.contains(entityId) || blacklist.contains(entityId);
    }

    public boolean spawn(@Nullable World world, @Nullable BlockPos pos, @Nullable EnumFacing side, boolean clone) {
        if (world == null || pos == null) {
            return false;
        }
        EnumFacing theSide = side != null ? side : EnumFacing.UP;
        Entity entity = this.getEntity(world, pos, null, clone);
        if (entity == null) {
            return false;
        }
        Block blk = world.func_180495_p(pos).func_177230_c();
        double spawnX = (double)(pos.func_177958_n() + theSide.func_82601_c()) + 0.5;
        double spawnY = pos.func_177956_o() + theSide.func_96559_d();
        double spawnZ = (double)(pos.func_177952_p() + theSide.func_82599_e()) + 0.5;
        if (theSide == EnumFacing.UP && (blk instanceof BlockFence || blk instanceof BlockWall || blk instanceof BlockFenceGate)) {
            spawnY += 0.5;
        }
        entity.func_70012_b(spawnX, spawnY, spawnZ, world.field_73012_v.nextFloat() * 360.0f, 0.0f);
        if (!world.func_72855_b(entity.func_174813_aQ()) || !world.func_184144_a(entity, entity.func_174813_aQ()).isEmpty()) {
            return false;
        }
        if (this.customName != null && entity instanceof EntityLiving) {
            ((EntityLiving)entity).func_96094_a(this.customName);
        }
        if (!world.func_72838_d(entity)) {
            entity.func_184221_a(MathHelper.func_180182_a((Random)world.field_73012_v));
            if (!world.func_72838_d(entity)) {
                return false;
            }
        }
        if (entity instanceof EntityLiving) {
            ((EntityLiving)entity).func_70642_aH();
        }
        return true;
    }

    @Nullable
    public Entity getEntity(@Nullable World world, boolean clone) {
        return this.getEntity(world, null, null, clone);
    }

    @Nullable
    public Entity getEntity(@Nullable World world, @Nullable BlockPos pos, DifficultyInstance difficulty, boolean clone) {
        Entity entity = null;
        if (world != null) {
            if ((this.isStub || !clone) && this.entityId != null) {
                entity = EntityList.func_75620_a((String)this.entityId, (World)world);
            } else if (this.entityNbt != null) {
                if (clone) {
                    entity = EntityList.func_75615_a((NBTTagCompound)this.entityNbt, (World)world);
                    return entity;
                }
                entity = EntityList.func_75620_a((String)this.entityNbt.func_74779_i("id"), (World)world);
            }
            if (pos != null && entity != null) {
                entity.func_70107_b((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
            }
            if (entity instanceof EntityLiving) {
                if (pos != null && difficulty == null) {
                    difficulty = world.func_175649_E(pos);
                }
                if (difficulty != null) {
                    IEntityLivingData livingData = null;
                    if (this.variant != null && entity instanceof EntityZombie) {
                        livingData = new IEntityLivingData(){};
                    }
                    ((EntityLiving)entity).func_180482_a(difficulty, livingData);
                }
            }
            if (this.variant != null) {
                if (entity instanceof EntitySkeleton) {
                    EntitySkeleton skel = (EntitySkeleton)entity;
                    skel.func_189768_a((SkeletonType)this.variant);
                    if (this.variant == SkeletonType.WITHER) {
                        skel.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(Items.field_151052_q));
                        skel.func_184201_a(EntityEquipmentSlot.OFFHAND, null);
                        skel.func_184201_a(EntityEquipmentSlot.CHEST, null);
                        skel.func_184201_a(EntityEquipmentSlot.FEET, null);
                        skel.func_184201_a(EntityEquipmentSlot.HEAD, null);
                        skel.func_184201_a(EntityEquipmentSlot.LEGS, null);
                        skel.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(4.0);
                        skel.func_85036_m();
                        Calendar calendar = world.func_83015_S();
                        if (calendar.get(2) + 1 == 10 && calendar.get(5) == 31 && Math.random() < 0.25) {
                            skel.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack(Math.random() < 0.1 ? Blocks.field_150428_aP : Blocks.field_150423_aK));
                            skel.func_184642_a(EntityEquipmentSlot.HEAD, 0.0f);
                        } else if (calendar.get(2) + 1 == 12 && calendar.get(5) == 6 && Math.random() < 0.25) {
                            skel.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack((Item)(Math.random() < 0.25 ? Items.field_151021_T : Items.field_151055_y)));
                        } else if (Math.random() < 0.1) {
                            skel.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack((Item)DarkSteelItems.itemDarkSteelSword));
                            skel.func_184642_a(EntityEquipmentSlot.MAINHAND, 1.0E-5f);
                        }
                    }
                } else if (entity instanceof EntityZombie) {
                    boolean isChild = world.field_73012_v.nextFloat() < ForgeModContainer.zombieBabyChance;
                    ((EntityZombie)entity).func_189778_a((ZombieType)this.variant);
                    if (((ZombieType)this.variant).func_190154_b()) {
                        do {
                            VillagerRegistry.setRandomProfession((EntityZombie)((EntityZombie)entity), (Random)world.field_73012_v);
                        } while (((EntityZombie)entity).getVillagerTypeForge() == null && !((EntityZombie)entity).func_189777_di().func_190154_b());
                    }
                    if (isChild) {
                        ((EntityZombie)entity).func_82227_f(true);
                        if ((double)world.field_73012_v.nextFloat() < 0.05) {
                            EntityChicken entitychicken1 = new EntityChicken(world);
                            entitychicken1.func_70012_b(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, entity.field_70177_z, 0.0f);
                            entitychicken1.func_180482_a(difficulty, (IEntityLivingData)null);
                            entitychicken1.func_152117_i(true);
                            world.func_72838_d((Entity)entitychicken1);
                            entity.func_184220_m((Entity)entitychicken1);
                        }
                    }
                }
            }
        }
        return entity;
    }

    @Nonnull
    public String getDisplayName() {
        String baseName = null;
        if (this.variant != null && SKELETON_ENTITY_NAME.equals(this.entityId)) {
            String typeName = this.variant == SkeletonType.NORMAL ? this.entityId : (this.variant == SkeletonType.WITHER ? "WitherSkeleton" : "Stray");
            baseName = EntityUtil.getDisplayNameForEntity((String)typeName);
        } else if (this.variant != null && ZOMBIE_ENTITY_NAME.equals(this.entityId)) {
            baseName = ((ZombieType)this.variant).func_190154_b() ? EntityUtil.getDisplayNameForEntity((String)"ZombieVillager") : ((ZombieType)this.variant).func_190145_d().func_150260_c();
        } else if (this.entityId != null) {
            baseName = EntityUtil.getDisplayNameForEntity((String)this.entityId);
        } else if (this.entityNbt != null) {
            baseName = EntityUtil.getDisplayNameForEntity((String)this.entityNbt.func_74779_i("id"));
        }
        if (baseName == null || baseName.trim().isEmpty()) {
            if (this.customName != null) {
                return this.customName;
            }
            return "???";
        }
        if (this.customName != null) {
            return this.customName + " (" + baseName + ")";
        }
        return baseName;
    }

    public float getHealth() {
        if (this.entityNbt != null && this.entityNbt.func_74764_b("HealF")) {
            return this.entityNbt.func_74760_g("HealF");
        }
        return Float.NaN;
    }

    public float getMaxHealth() {
        NBTTagCompound maxHealthAttrib = this.getAttribute("generic.maxHealth");
        if (maxHealthAttrib != null && maxHealthAttrib.func_74764_b("Base")) {
            return maxHealthAttrib.func_74760_g("Base");
        }
        return Float.NaN;
    }

    @Nullable
    public NBTTagCompound getAttribute(@Nullable String name) {
        NBTBase tag;
        if (name != null && this.entityNbt != null && this.entityNbt.func_74764_b("Attributes") && (tag = this.entityNbt.func_74781_a("Attributes")) instanceof NBTTagList) {
            NBTTagList attributes = (NBTTagList)tag;
            for (int i = 0; i < attributes.func_74745_c(); ++i) {
                NBTTagCompound attrib = attributes.func_150305_b(i);
                if (!attrib.func_74764_b("Name") || !name.equals(attrib.func_74779_i("Name"))) continue;
                return attrib;
            }
        }
        return null;
    }

    @Nullable
    public DyeColor getColor() {
        int colorIdx;
        if (this.entityNbt != null && this.entityNbt.func_74764_b("Color") && (colorIdx = this.entityNbt.func_74762_e("Color")) >= 0 && colorIdx <= 15) {
            return DyeColor.values()[15 - colorIdx];
        }
        return null;
    }

    @Nullable
    public String getFluidName() {
        if (this.entityNbt != null && this.entityNbt.func_74764_b("FluidName")) {
            return this.entityNbt.func_74779_i("FluidName");
        }
        return null;
    }

    public static void addToBlackList(String entityName) {
        blacklist.add(entityName);
    }

    @Nullable
    public String getEntityName() {
        return this.entityId != null ? this.entityId : (this.entityNbt != null ? this.entityNbt.func_74779_i("id") : null);
    }

    public boolean isSameType(Entity entity) {
        return !(entity == null || EntityList.func_75621_b((Entity)entity) == null || !EntityList.func_75621_b((Entity)entity).equals(this.getEntityName()) || entity instanceof EntitySkeleton && !CapturedMob.isSameSkeleton(((EntitySkeleton)entity).func_189771_df(), this.variant) || entity instanceof EntityZombie && !CapturedMob.isSameZombie(((EntityZombie)entity).func_189777_di(), this.variant));
    }

    public String toString() {
        return "CapturedMob [" + (this.entityId != null ? "entityId=" + this.entityId + ", " : "") + (this.customName != null ? "customName=" + this.customName + ", " : "") + "isStub=" + this.isStub + ", variant=" + this.variant + ", " + (this.entityNbt != null ? "entityNbt=" + this.entityNbt + ", " : "") + "getDisplayName()=" + this.getDisplayName() + ", getHealth()=" + this.getHealth() + ", getMaxHealth()=" + this.getMaxHealth() + ", " + (this.getColor() != null ? "getColor()=" + this.getColor() + ", " : "") + (this.getFluidName() != null ? "getFluidName()=" + this.getFluidName() : "") + "]";
    }

    private static boolean isSameZombie(ZombieType a, Enum<?> b) {
        return a == b || a != ZombieType.HUSK && b != ZombieType.HUSK || b == null;
    }

    private static boolean isSameSkeleton(SkeletonType a, Enum<?> b) {
        return a == b || b == null;
    }

    @Nonnull
    public static List<CapturedMob> getSouls(List<String> mobs) {
        ArrayList<CapturedMob> result = new ArrayList<CapturedMob>(mobs.size());
        for (String mobName : mobs) {
            CapturedMob soul = CapturedMob.create(mobName, null);
            if (soul == null || "EnderDragon".equals(mobName)) continue;
            if (SKELETON_ENTITY_NAME.equals(mobName)) {
                for (SkeletonType type : SkeletonType.values()) {
                    result.add(CapturedMob.create(mobName, type));
                }
                continue;
            }
            if (ZOMBIE_ENTITY_NAME.equals(mobName)) {
                result.add(CapturedMob.create(mobName, ZombieType.NORMAL));
                result.add(CapturedMob.create(mobName, ZombieType.VILLAGER_BUTCHER));
                result.add(CapturedMob.create(mobName, ZombieType.HUSK));
                continue;
            }
            result.add(soul);
        }
        return result;
    }

    @Nonnull
    public static List<CapturedMob> getAllSouls() {
        return CapturedMob.getSouls(EntityUtil.getAllRegisteredMobNames());
    }

    private Enum<?> mkEnumForType(int ordinal) {
        String type = this.entityId;
        if (this.entityId == null && this.entityNbt != null) {
            type = this.entityNbt.func_74779_i("id");
        }
        if (this.entityId == null) {
            return null;
        }
        if (SKELETON_ENTITY_NAME.equals(type)) {
            return SkeletonType.values()[ordinal];
        }
        if (ZOMBIE_ENTITY_NAME.equals(type)) {
            return ZombieType.values()[ordinal];
        }
        return null;
    }
}

