/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.block.modeldata;

import com.jaquadro.minecraft.chameleon.model.ModelData;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawer;
import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.LockAttribute;
import com.jaquadro.minecraft.storagedrawers.block.tile.TileEntityDrawers;
import java.util.UUID;

public final class DrawerStateModelData
extends ModelData {
    private final boolean shroudedFlag;
    private final boolean lockedFlag;
    private final boolean voidFlag;
    private final UUID owner;
    private final boolean[] emptyFlags;

    public DrawerStateModelData(TileEntityDrawers tile) {
        if (tile != null) {
            this.shroudedFlag = tile.isShrouded();
            this.lockedFlag = tile.isItemLocked(LockAttribute.LOCK_POPULATED);
            this.voidFlag = tile.isVoid();
            this.owner = tile.getOwner();
            this.emptyFlags = new boolean[tile.getDrawerCount()];
            for (int i = 0; i < this.emptyFlags.length; ++i) {
                IDrawer drawer = tile.getDrawer(i);
                this.emptyFlags[i] = drawer == null || drawer.isEmpty();
            }
        } else {
            this.shroudedFlag = false;
            this.lockedFlag = false;
            this.voidFlag = false;
            this.owner = null;
            this.emptyFlags = new boolean[0];
        }
    }

    public boolean isShrouded() {
        return this.shroudedFlag;
    }

    public boolean isItemLocked() {
        return this.lockedFlag;
    }

    public boolean isVoid() {
        return this.voidFlag;
    }

    public UUID getOwner() {
        return this.owner;
    }

    public int getDrawerCount() {
        return this.emptyFlags.length;
    }

    public boolean isDrawerEmpty(int slot) {
        return slot < 0 || slot >= this.emptyFlags.length || this.emptyFlags[slot];
    }
}

