/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.client.model.dynamic;

import com.jaquadro.minecraft.chameleon.render.ChamRender;
import com.jaquadro.minecraft.chameleon.render.ChamRenderState;
import com.jaquadro.minecraft.chameleon.render.helpers.ModularBoxRenderer;
import com.jaquadro.minecraft.chameleon.render.helpers.PanelBoxRenderer;
import com.jaquadro.minecraft.storagedrawers.api.storage.EnumBasicDrawer;
import com.jaquadro.minecraft.storagedrawers.block.BlockDrawers;
import com.jaquadro.minecraft.storagedrawers.block.dynamic.StatusModelData;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public class CommonDrawerRenderer {
    private final ChamRender renderHelper;
    private final PanelBoxRenderer panelRenderer;
    private double depth;
    private double trimWidth;
    private double trimDepth;
    private EnumBasicDrawer blockInfo;
    private static double unit7 = 0.4375;
    private static double unit9 = 0.5625;

    public CommonDrawerRenderer(ChamRender renderer) {
        this.renderHelper = renderer;
        this.panelRenderer = new PanelBoxRenderer(renderer);
    }

    private void start(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing direction) {
        BlockDrawers block = (BlockDrawers)state.func_177230_c();
        StatusModelData status = block.getStatusInfo(state);
        this.blockInfo = (EnumBasicDrawer)((Object)state.func_177229_b(BlockDrawers.BLOCK));
        this.depth = this.blockInfo.isHalfDepth() ? 0.5 : 0.0;
        this.trimWidth = 0.0625;
        this.trimDepth = status.getFrontDepth() / 16.0;
        unit7 = 0.4375;
        unit9 = 0.5625;
        this.panelRenderer.setTrimWidth(this.trimWidth);
        this.panelRenderer.setTrimDepth(0.0);
        this.panelRenderer.setTrimColor(ModularBoxRenderer.COLOR_WHITE);
        this.panelRenderer.setPanelColor(ModularBoxRenderer.COLOR_WHITE);
        this.renderHelper.state.setRotateTransform(2, direction.func_176745_a());
        this.renderHelper.state.setUVRotation(1, ChamRenderState.ROTATION_BY_FACE_FACE[2][direction.func_176745_a()]);
    }

    private void end() {
        this.renderHelper.state.clearRotateTransform();
        this.renderHelper.state.clearUVRotation(1);
    }

    public void renderBasePass(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing direction, TextureAtlasSprite iconSide, TextureAtlasSprite iconTrim, TextureAtlasSprite iconFront) {
        this.start(world, state, pos, direction);
        this.panelRenderer.setTrimIcon(iconTrim);
        this.panelRenderer.setPanelIcon(iconSide);
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            if (dir != ChamRender.FACE_ZNEG) {
                this.renderHelper.targetFaceGroup(true);
                this.panelRenderer.renderFacePanel(dir, world, state, pos, 0.0, 0.0, this.depth, 1.0, 1.0, 1.0);
            } else if (dir == ChamRender.FACE_ZNEG && this.depth == 0.0) {
                this.renderHelper.targetFaceGroup(true);
            }
            this.panelRenderer.renderFaceTrim(dir, world, state, pos, 0.0, 0.0, this.depth, 1.0, 1.0, 1.0);
            this.renderHelper.targetFaceGroup(false);
        }
        this.panelRenderer.setTrimDepth(this.trimDepth);
        this.panelRenderer.renderInteriorTrim(ChamRender.FACE_ZNEG, world, state, pos, 0.0, 0.0, this.depth, 1.0, 1.0, 1.0);
        if (this.blockInfo.getDrawerCount() == 1) {
            this.renderHelper.setRenderBounds(this.trimWidth, this.trimWidth, this.depth + this.trimDepth, 1.0 - this.trimWidth, 1.0 - this.trimWidth, 1.0);
            this.renderHelper.renderFace(ChamRender.FACE_ZNEG, world, state, pos, iconFront);
        } else if (this.blockInfo.getDrawerCount() == 2) {
            this.renderHelper.setRenderBounds(this.trimWidth, this.trimWidth, this.depth + this.trimDepth, 1.0 - this.trimWidth, unit7, 1.0);
            this.renderHelper.renderFace(ChamRender.FACE_ZNEG, world, state, pos, iconFront);
            this.renderHelper.setRenderBounds(this.trimWidth, unit9, this.depth + this.trimDepth, 1.0 - this.trimWidth, 1.0 - this.trimWidth, 1.0);
            this.renderHelper.renderFace(ChamRender.FACE_ZNEG, world, state, pos, iconFront);
            this.renderHelper.setRenderBounds(this.trimWidth, unit7, this.depth + this.trimDepth, 1.0 - this.trimWidth, unit9, 1.0);
            this.renderHelper.renderFace(ChamRender.FACE_ZNEG, world, state, pos, iconTrim);
        } else if (this.blockInfo.getDrawerCount() == 4) {
            this.renderHelper.state.flipTexture = true;
            this.renderHelper.state.autoFlipTexture = true;
            this.renderHelper.setRenderBounds(this.trimWidth, this.trimWidth, this.depth + this.trimDepth, unit7, unit7, 1.0);
            this.renderHelper.renderFace(ChamRender.FACE_ZNEG, world, state, pos, iconFront);
            this.renderHelper.setRenderBounds(this.trimWidth, unit9, this.depth + this.trimDepth, unit7, 1.0 - this.trimWidth, 1.0);
            this.renderHelper.renderFace(ChamRender.FACE_ZNEG, world, state, pos, iconFront);
            this.renderHelper.setRenderBounds(unit9, this.trimWidth, this.depth + this.trimDepth, 1.0 - this.trimWidth, unit7, 1.0);
            this.renderHelper.renderFace(ChamRender.FACE_ZNEG, world, state, pos, iconFront);
            this.renderHelper.setRenderBounds(unit9, unit9, this.depth + this.trimDepth, 1.0 - this.trimWidth, 1.0 - this.trimWidth, 1.0);
            this.renderHelper.renderFace(ChamRender.FACE_ZNEG, world, state, pos, iconFront);
            this.renderHelper.setRenderBounds(this.trimWidth, unit7, this.depth + this.trimDepth, unit7, unit9, 1.0);
            this.renderHelper.renderFace(ChamRender.FACE_ZNEG, world, state, pos, iconTrim);
            this.renderHelper.setRenderBounds(unit9, unit7, this.depth + this.trimDepth, 1.0 - this.trimWidth, unit9, 1.0);
            this.renderHelper.renderFace(ChamRender.FACE_ZNEG, world, state, pos, iconTrim);
            this.renderHelper.setRenderBounds(unit7, this.trimWidth, this.depth + this.trimDepth, unit9, unit7, 1.0);
            this.renderHelper.renderFace(ChamRender.FACE_ZNEG, world, state, pos, iconTrim);
            this.renderHelper.setRenderBounds(unit7, unit9, this.depth + this.trimDepth, unit9, 1.0 - this.trimWidth, 1.0);
            this.renderHelper.renderFace(ChamRender.FACE_ZNEG, world, state, pos, iconTrim);
            this.renderHelper.setRenderBounds(unit7, unit7, this.depth + this.trimDepth, unit9, unit9, 1.0);
            this.renderHelper.renderFace(ChamRender.FACE_ZNEG, world, state, pos, iconTrim);
            this.renderHelper.state.autoFlipTexture = false;
            this.renderHelper.state.flipTexture = false;
        }
        this.end();
    }

    public void renderOverlayPass(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing direction, TextureAtlasSprite trimShadow, TextureAtlasSprite handle, TextureAtlasSprite faceShadow) {
        this.start(world, state, pos, direction);
        this.panelRenderer.setTrimIcon(trimShadow);
        if (this.depth == 0.0) {
            this.renderHelper.targetFaceGroup(true);
        }
        this.panelRenderer.renderFaceTrim(ChamRender.FACE_ZNEG, world, state, pos, 0.0, 0.0, this.depth, 1.0, 1.0, 1.0);
        this.renderHelper.targetFaceGroup(false);
        if (this.blockInfo.getDrawerCount() == 1) {
            this.renderHelper.setRenderBounds(this.trimWidth, this.trimWidth, this.depth + this.trimDepth, 1.0 - this.trimWidth, 1.0 - this.trimWidth, 1.0);
            this.renderHelper.renderFace(ChamRender.FACE_ZNEG, world, state, pos, handle);
            this.renderHelper.renderFace(ChamRender.FACE_ZNEG, world, state, pos, faceShadow);
        } else if (this.blockInfo.getDrawerCount() == 2) {
            this.renderHelper.setRenderBounds(this.trimWidth, this.trimWidth, this.depth + this.trimDepth, 1.0 - this.trimWidth, unit7, 1.0);
            this.renderHelper.renderFace(ChamRender.FACE_ZNEG, world, state, pos, handle);
            this.renderHelper.renderFace(ChamRender.FACE_ZNEG, world, state, pos, faceShadow);
            this.renderHelper.setRenderBounds(this.trimWidth, unit9, this.depth + this.trimDepth, 1.0 - this.trimWidth, 1.0 - this.trimWidth, 1.0);
            this.renderHelper.renderFace(ChamRender.FACE_ZNEG, world, state, pos, handle);
            this.renderHelper.renderFace(ChamRender.FACE_ZNEG, world, state, pos, faceShadow);
            this.renderHelper.setRenderBounds(this.trimWidth, unit7, this.depth + this.trimDepth, 1.0 - this.trimWidth, unit9, 1.0);
            this.renderHelper.renderFace(ChamRender.FACE_ZNEG, world, state, pos, trimShadow);
        } else if (this.blockInfo.getDrawerCount() == 4) {
            this.renderHelper.setRenderBounds(this.trimWidth, this.trimWidth, this.depth + this.trimDepth, unit7, unit7, 1.0);
            this.renderHelper.renderFace(ChamRender.FACE_ZNEG, world, state, pos, handle);
            this.renderHelper.renderFace(ChamRender.FACE_ZNEG, world, state, pos, faceShadow);
            this.renderHelper.setRenderBounds(this.trimWidth, unit9, this.depth + this.trimDepth, unit7, 1.0 - this.trimWidth, 1.0);
            this.renderHelper.renderFace(ChamRender.FACE_ZNEG, world, state, pos, handle);
            this.renderHelper.renderFace(ChamRender.FACE_ZNEG, world, state, pos, faceShadow);
            this.renderHelper.setRenderBounds(unit9, this.trimWidth, this.depth + this.trimDepth, 1.0 - this.trimWidth, unit7, 1.0);
            this.renderHelper.renderFace(ChamRender.FACE_ZNEG, world, state, pos, handle);
            this.renderHelper.renderFace(ChamRender.FACE_ZNEG, world, state, pos, faceShadow);
            this.renderHelper.setRenderBounds(unit9, unit9, this.depth + this.trimDepth, 1.0 - this.trimWidth, 1.0 - this.trimWidth, 1.0);
            this.renderHelper.renderFace(ChamRender.FACE_ZNEG, world, state, pos, handle);
            this.renderHelper.renderFace(ChamRender.FACE_ZNEG, world, state, pos, faceShadow);
            this.renderHelper.setRenderBounds(this.trimWidth, unit7, this.depth + this.trimDepth, unit7, unit9, 1.0);
            this.renderHelper.renderFace(ChamRender.FACE_ZNEG, world, state, pos, trimShadow);
            this.renderHelper.setRenderBounds(unit9, unit7, this.depth + this.trimDepth, 1.0 - this.trimWidth, unit9, 1.0);
            this.renderHelper.renderFace(ChamRender.FACE_ZNEG, world, state, pos, trimShadow);
            this.renderHelper.setRenderBounds(unit7, this.trimWidth, this.depth + this.trimDepth, unit9, unit7, 1.0);
            this.renderHelper.renderFace(ChamRender.FACE_ZNEG, world, state, pos, trimShadow);
            this.renderHelper.setRenderBounds(unit7, unit9, this.depth + this.trimDepth, unit9, 1.0 - this.trimWidth, 1.0);
            this.renderHelper.renderFace(ChamRender.FACE_ZNEG, world, state, pos, trimShadow);
            this.renderHelper.setRenderBounds(unit7, unit7, this.depth + this.trimDepth, unit9, unit9, 1.0);
            this.renderHelper.renderFace(ChamRender.FACE_ZNEG, world, state, pos, trimShadow);
        } else {
            this.renderHelper.renderEmptyPlane(pos);
        }
        this.end();
    }
}

