/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.config;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.Loader;

public class CompTierRegistry {
    private List<Record> records = new ArrayList<Record>();

    public CompTierRegistry() {
        this.register(new ItemStack(Blocks.field_150435_aG), new ItemStack(Items.field_151119_aD), 4);
        this.register(new ItemStack(Blocks.field_150433_aE), new ItemStack(Items.field_151126_ay), 4);
        this.register(new ItemStack(Blocks.field_150426_aN), new ItemStack(Items.field_151114_aO), 4);
        this.register(new ItemStack(Blocks.field_150336_V), new ItemStack(Items.field_151118_aC), 4);
        this.register(new ItemStack(Blocks.field_150385_bj), new ItemStack(Items.field_151130_bT), 4);
        this.register(new ItemStack(Blocks.field_150371_ca), new ItemStack(Items.field_151128_bU), 4);
        this.register(new ItemStack(Blocks.field_150440_ba), new ItemStack(Items.field_151127_ba), 9);
        if (!Loader.isModLoaded((String)"ExtraUtilities")) {
            this.register(new ItemStack(Blocks.field_150322_A), new ItemStack((Block)Blocks.field_150354_m), 4);
        }
    }

    public boolean register(ItemStack upper, ItemStack lower, int convRate) {
        if (upper == null || lower == null) {
            return false;
        }
        this.unregisterUpperTarget(upper);
        this.unregisterLowerTarget(lower);
        Record r = new Record();
        r.upper = upper.func_77946_l();
        r.lower = lower.func_77946_l();
        r.convRate = convRate;
        r.upper.field_77994_a = 1;
        r.lower.field_77994_a = 1;
        this.records.add(r);
        return true;
    }

    public boolean unregisterUpperTarget(ItemStack stack) {
        for (Record r : this.records) {
            if (!ItemStack.func_77989_b((ItemStack)stack, (ItemStack)r.upper)) continue;
            this.records.remove(r);
            return true;
        }
        return false;
    }

    public boolean unregisterLowerTarget(ItemStack stack) {
        for (Record r : this.records) {
            if (!ItemStack.func_77989_b((ItemStack)stack, (ItemStack)r.lower)) continue;
            this.records.remove(r);
            return true;
        }
        return false;
    }

    public Record findHigherTier(ItemStack stack) {
        if (stack == null || stack.func_77973_b() == null) {
            return null;
        }
        int n = this.records.size();
        for (int i = 0; i < n; ++i) {
            Record r = this.records.get(i);
            if (!stack.func_77969_a(r.lower) || !ItemStack.func_77970_a((ItemStack)stack, (ItemStack)r.lower)) continue;
            return r;
        }
        return null;
    }

    public Record findLowerTier(ItemStack stack) {
        if (stack == null || stack.func_77973_b() == null) {
            return null;
        }
        int n = this.records.size();
        for (int i = 0; i < n; ++i) {
            Record r = this.records.get(i);
            if (!stack.func_77969_a(r.upper) || !ItemStack.func_77970_a((ItemStack)stack, (ItemStack)r.upper)) continue;
            return r;
        }
        return null;
    }

    public class Record {
        public ItemStack upper;
        public ItemStack lower;
        public int convRate;
    }
}

