/*
 * Decompiled with CFR 0.152.
 */
package com.progwml6.natura.common;

import com.progwml6.natura.Natura;
import com.progwml6.natura.common.CommonProxy;
import com.progwml6.natura.library.Util;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.registry.GameData;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import slimeknights.mantle.item.ItemBlockMeta;

public class ClientProxy
extends CommonProxy {
    protected ResourceLocation registerModel(Item item, String ... customVariants) {
        return this.registerModel(item, 0, customVariants);
    }

    protected ResourceLocation registerModel(Item item, int meta, String ... customVariants) {
        ResourceLocation o = GameData.getItemRegistry().getNameForObject((IForgeRegistryEntry)item);
        if (o == null) {
            Natura.log.error("Trying to register a model for an unregistered item: %s" + item.func_77658_a());
            return null;
        }
        ResourceLocation location = o;
        location = new ResourceLocation(location.func_110624_b(), location.func_110623_a());
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)new ModelResourceLocation(location, "inventory"));
        if (customVariants.length > 0) {
            ModelLoader.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[]{location});
        }
        for (String customVariant : customVariants) {
            String custom = location.func_110624_b() + ":" + customVariant;
            ModelLoader.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[]{new ResourceLocation(custom)});
        }
        return location;
    }

    protected void registerItemModel(ItemStack item, String name) {
        if (!name.contains(":")) {
            name = Util.resource(name);
        }
        ModelLoader.registerItemVariants((Item)item.func_77973_b(), (ResourceLocation[])new ResourceLocation[]{new ResourceLocation(name)});
        ModelLoader.setCustomModelResourceLocation((Item)item.func_77973_b(), (int)item.func_77960_j(), (ModelResourceLocation)new ModelResourceLocation(name, "inventory"));
    }

    public ResourceLocation registerItemModel(Item item) {
        ResourceLocation itemLocation = ClientProxy.getItemLocation(item);
        if (itemLocation == null) {
            return null;
        }
        return ClientProxy.registerIt(item, itemLocation);
    }

    public ResourceLocation registerItemModel(Block block) {
        return this.registerItemModel(Item.func_150898_a((Block)block));
    }

    public void registerItemModel(Item item, int meta, String variant) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName(), variant));
    }

    private static ResourceLocation registerIt(Item item, final ResourceLocation location) {
        ModelLoader.setCustomMeshDefinition((Item)item, (ItemMeshDefinition)new ItemMeshDefinition(){

            @Nonnull
            public ModelResourceLocation func_178113_a(@Nonnull ItemStack stack) {
                return new ModelResourceLocation(location, "inventory");
            }
        });
        ModelLoader.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[]{location});
        return location;
    }

    protected void registerItemBlockMeta(Block block) {
        if (block != null) {
            ((ItemBlockMeta)Item.func_150898_a((Block)block)).registerItemModels();
        }
    }

    public static ResourceLocation getItemLocation(Item item) {
        return Util.getItemLocation(item);
    }

    @Override
    public boolean fancyGraphicsEnabled() {
        return Minecraft.func_71410_x().field_71474_y.field_74347_j;
    }
}

