/*
 * Decompiled with CFR 0.152.
 */
package squeek.appleskin.network;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;
import squeek.appleskin.helpers.HungerHelper;
import squeek.appleskin.network.MessageExhaustionSync;
import squeek.appleskin.network.MessageSaturationSync;

public class SyncHandler {
    public static final SimpleNetworkWrapper CHANNEL = NetworkRegistry.INSTANCE.newSimpleChannel("appleskin");
    private float lastSaturationLevel = 0.0f;
    private float lastExhaustionLevel = 0.0f;

    public static void init() {
        CHANNEL.registerMessage(MessageExhaustionSync.class, MessageExhaustionSync.class, 1, Side.CLIENT);
        CHANNEL.registerMessage(MessageSaturationSync.class, MessageSaturationSync.class, 2, Side.CLIENT);
        MinecraftForge.EVENT_BUS.register((Object)new SyncHandler());
    }

    @SubscribeEvent
    public void onLivingUpdateEvent(LivingEvent.LivingUpdateEvent event) {
        float exhaustionLevel;
        if (!(event.getEntity() instanceof EntityPlayerMP)) {
            return;
        }
        EntityPlayerMP player = (EntityPlayerMP)event.getEntity();
        if (this.lastSaturationLevel != player.func_71024_bL().func_75115_e()) {
            CHANNEL.sendTo((IMessage)new MessageSaturationSync(player.func_71024_bL().func_75115_e()), player);
            this.lastSaturationLevel = player.func_71024_bL().func_75115_e();
        }
        if (Math.abs(this.lastExhaustionLevel - (exhaustionLevel = HungerHelper.getExhaustion((EntityPlayer)player))) >= 0.01f) {
            CHANNEL.sendTo((IMessage)new MessageExhaustionSync(exhaustionLevel), player);
            this.lastExhaustionLevel = exhaustionLevel;
        }
    }
}

