/*
 * Decompiled with CFR 0.152.
 */
package sonar.calculator.mod.client.gui.misc;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import sonar.calculator.mod.common.containers.ContainerFabricationChamber;
import sonar.calculator.mod.common.recipes.machines.FabricationChamberRecipes;
import sonar.calculator.mod.common.tileentity.machines.TileEntityFabricationChamber;
import sonar.core.SonarCore;
import sonar.core.helpers.FontHelper;
import sonar.core.helpers.ItemStackHelper;
import sonar.core.network.PacketByteBuf;
import sonar.core.network.utils.ByteBufWritable;
import sonar.core.network.utils.IByteBufTile;

public class GuiFabricationChamber
extends GuiContainer {
    public static final ResourceLocation bground = new ResourceLocation("Calculator:textures/gui/fabrication_chamber.png");
    public TileEntityFabricationChamber chamber;
    public float currentScroll;
    private boolean isScrolling;
    private boolean wasClicking;
    public int scrollerLeft;
    public int scrollerStart;
    public int scrollerEnd;
    public int scrollerWidth;
    public int currentSlot = -1;
    public final LinkedHashMap<ItemStack, FabricationChamberRecipes.CircuitStack[]> recipes = FabricationChamberRecipes.getInstance().getRecipes();
    public final LinkedHashMap<FabricationChamberRecipes.CircuitStack[], ItemStack> recipes_reversed = FabricationChamberRecipes.getInstance().getRecipesReversed();

    public GuiFabricationChamber(InventoryPlayer player, TileEntityFabricationChamber chamber) {
        super((Container)new ContainerFabricationChamber(player, chamber));
        this.chamber = chamber;
        this.field_147000_g = 200;
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(bground);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        this.func_73729_b(this.scrollerLeft, this.scrollerStart + (int)((float)(this.scrollerEnd - this.scrollerStart - 17) * this.currentScroll), 176, 0, 8, 15);
        int pos = this.getDataPosition();
        int offsetTop = 6;
        for (int i = 0; i < this.getViewableSize(); ++i) {
            this.drawSelectionBackground(offsetTop, i, pos);
        }
        if (this.chamber.currentFabricateTime != 0) {
            int l = this.chamber.currentFabricateTime * 23 / this.chamber.fabricateTime;
            this.func_73729_b(this.field_147003_i + 84 + 10, this.field_147009_r + 89, 176, 16, l, 16);
        }
    }

    public void func_73866_w_() {
        Keyboard.enableRepeatEvents((boolean)true);
        this.field_146297_k.field_71439_g.field_71070_bA = this.field_147002_h;
        this.field_147003_i = (this.field_146294_l - this.field_146999_f) / 2;
        this.field_147009_r = (this.field_146295_m - this.field_147000_g) / 2;
        this.scrollerLeft = this.field_147003_i + 91;
        this.scrollerStart = this.field_147009_r + 6;
        this.scrollerEnd = this.scrollerStart + 74;
        this.scrollerWidth = 10;
        this.field_146292_n.add(new GuiButton(0, this.field_147003_i + 26, this.field_147009_r + 87, 60, 20, "Fabricate"));
    }

    public int getDataPosition() {
        if (this.chamber.selected == null) {
            return -1;
        }
        int start = (int)((float)this.recipes.size() * this.currentScroll);
        int finish = Math.min(start + this.getViewableSize(), this.recipes.size());
        for (int i = start; i < finish; ++i) {
            ItemStack stack = new ArrayList<ItemStack>(this.recipes_reversed.values()).get(i);
            if (stack == null || !ItemStackHelper.equalStacksRegular((ItemStack)this.chamber.selected, (ItemStack)stack)) continue;
            return i - start;
        }
        return -1;
    }

    public void func_146979_b(int x, int y) {
        super.func_146979_b(x, y);
        FontHelper.textOffsetCentre((String)"Required", (int)135, (int)8, (int)-1);
        int start = (int)((float)this.recipes.size() * this.currentScroll);
        int finish = Math.min(start + this.getViewableSize(), this.recipes.size());
        int pos = this.getDataPosition();
        for (int i = start; i < finish; ++i) {
            ItemStack stack = new ArrayList<ItemStack>(this.recipes_reversed.values()).get(i);
            if (stack == null) continue;
            this.field_146296_j.func_175042_a(stack, 7, 7 + (i - start) * 18);
            GL11.glPushMatrix();
            GL11.glScaled((double)0.7, (double)0.7, (double)0.7);
            String string = stack.func_82833_r();
            if (string.length() > 15) {
                string = string.substring(0, Math.min(15, string.length())) + "...";
            }
            FontHelper.text((String)(" " + string), (int)32, (int)(17 + (i - start) * 26), (int)-1);
            GL11.glPopMatrix();
        }
        if (this.chamber.selected != null) {
            FabricationChamberRecipes.CircuitStack[] requirements = FabricationChamberRecipes.getInstance().getRequirements(this.chamber.selected);
            if (requirements != null) {
                GL11.glPushMatrix();
                GL11.glScaled((double)0.8, (double)0.8, (double)0.8);
                int left = 124;
                int top = 24;
                int cPos = 0;
                for (FabricationChamberRecipes.CircuitStack circuit : requirements) {
                    int cLeft = left + (cPos - cPos / 5 * 5) * 18;
                    int cTop = top + cPos / 5 * 18;
                    ItemStack stack = circuit.buildItemStack();
                    this.field_146296_j.func_175042_a(stack, cLeft, cTop);
                    this.field_146296_j.func_180453_a(this.field_146289_q, stack, cLeft, cTop, "" + circuit.required);
                    ++cPos;
                }
                GL11.glPopMatrix();
            } else {
                FontHelper.textOffsetCentre((String)"INVALID RECIPE", (int)135, (int)18, (int)0);
            }
        } else {
            FontHelper.textOffsetCentre((String)"NO RECIPE", (int)135, (int)22, (int)-1);
        }
    }

    protected void func_146284_a(GuiButton button) {
        if (button != null && button.field_146127_k == 0) {
            SonarCore.network.sendToServer((IMessage)new PacketByteBuf((IByteBufTile)this.chamber, this.chamber.func_174877_v(), 1, new ByteBufWritable[0]));
        }
    }

    public void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        int x = mouseX - this.field_147003_i;
        int y = mouseY - this.field_147009_r;
        if (x > 3 && x < 90) {
            int start = (int)((float)this.recipes.size() * this.currentScroll);
            int finish = Math.min(start + this.getViewableSize(), this.recipes.size());
            for (int i = start; i < finish; ++i) {
                if (y <= 4 + (i - start) * 18 || y >= 4 + (i - start) * 18 + 18) continue;
                this.chamber.selected = new ArrayList<ItemStack>(this.recipes_reversed.values()).get(i).func_77946_l();
                SonarCore.network.sendToServer((IMessage)new PacketByteBuf((IByteBufTile)this.chamber, this.chamber.func_174877_v(), 0, new ByteBufWritable[0]));
            }
        }
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        float lastScroll = this.currentScroll;
        int i = Mouse.getEventDWheel();
        if (i != 0 && this.needsScrollBars()) {
            int j = this.recipes.size() + 1;
            if (i > 0) {
                i = 1;
            }
            if (i < 0) {
                i = -1;
            }
            this.currentScroll = (float)((double)this.currentScroll - (double)i / (double)j);
            if (this.currentScroll < 0.0f) {
                this.currentScroll = 0.0f;
            }
            if (this.currentScroll > 1.0f) {
                this.currentScroll = 1.0f;
            }
        }
    }

    public void func_73863_a(int x, int y, float var) {
        super.func_73863_a(x, y, var);
        float lastScroll = this.currentScroll;
        boolean flag = Mouse.isButtonDown((int)0);
        if (!this.wasClicking && flag && x >= this.scrollerLeft && y >= this.scrollerStart && x < this.scrollerLeft + this.scrollerWidth && y < this.scrollerEnd) {
            this.isScrolling = this.needsScrollBars();
        }
        if (!flag) {
            this.isScrolling = false;
        }
        this.wasClicking = flag;
        if (this.isScrolling) {
            this.currentScroll = ((float)(y - this.scrollerStart) - 7.5f) / ((float)(this.scrollerEnd - this.scrollerStart) - 1.0f);
            if (this.currentScroll < 0.0f) {
                this.currentScroll = 0.0f;
            }
            if (this.currentScroll > 1.0f) {
                this.currentScroll = 1.0f;
            }
        }
    }

    public void drawSelectionBackground(int offsetTop, int i, int pos) {
        this.func_73729_b(this.field_147003_i + 6, this.field_147009_r + offsetTop + this.getSelectionHeight() * i, 0, i == pos ? 220 + this.getSelectionHeight() : 220, 88, this.getSelectionHeight());
    }

    public int getViewableSize() {
        return 4;
    }

    public int getSelectionHeight() {
        return 18;
    }

    private boolean needsScrollBars() {
        return this.recipes.size() > this.getViewableSize();
    }
}

