/*
 * Decompiled with CFR 0.152.
 */
package sonar.calculator.mod.common.block;

import java.util.List;
import java.util.Random;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;
import sonar.calculator.mod.Calculator;
import sonar.calculator.mod.CalculatorConfig;
import sonar.calculator.mod.common.tileentity.TileEntityAbstractProcess;
import sonar.calculator.mod.common.tileentity.TileEntityMachine;
import sonar.calculator.mod.utils.helpers.CalculatorHelper;
import sonar.core.api.utils.BlockInteraction;
import sonar.core.common.block.SonarMaterials;
import sonar.core.common.block.SonarSidedBlock;
import sonar.core.helpers.FontHelper;
import sonar.core.upgrades.MachineUpgrade;

public class SmeltingBlock
extends SonarSidedBlock {
    public BlockTypes type;

    public SmeltingBlock(BlockTypes type) {
        super(SonarMaterials.machine, true, true);
        this.type = type;
    }

    public boolean func_149662_c(IBlockState state) {
        return this.type != null && this.type.isOpaqueCube();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        if (this.isAnimated(state, (IBlockAccess)world, pos)) {
            EnumFacing enumfacing = (EnumFacing)state.func_177229_b((IProperty)FACING);
            double d0 = (double)pos.func_177958_n() + 0.5;
            double d1 = (double)pos.func_177956_o() + rand.nextDouble() * 6.0 / 16.0;
            double d2 = (double)pos.func_177952_p() + 0.5;
            double d3 = 0.8;
            double d4 = rand.nextDouble() * 0.6 - 0.3;
            switch (enumfacing) {
                case WEST: {
                    world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0 - d3, d1, d2 + d4, 0.0, 0.0, 0.0, new int[0]);
                    break;
                }
                case EAST: {
                    world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0 + d3, d1, d2 + d4, 0.0, 0.0, 0.0, new int[0]);
                    break;
                }
                case NORTH: {
                    world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0 + d4, d1, d2 - d3, 0.0, 0.0, 0.0, new int[0]);
                    break;
                }
                case SOUTH: {
                    world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0 + d4, d1, d2 + d3, 0.0, 0.0, 0.0, new int[0]);
                }
            }
        }
    }

    public boolean operateBlock(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, BlockInteraction interact) {
        if (player != null) {
            if (player.func_184614_ca() != null && player.func_184614_ca().func_77973_b() instanceof MachineUpgrade) {
                return false;
            }
            if (player.func_184614_ca() != null && player.func_184614_ca().func_77973_b() == Calculator.wrench) {
                return false;
            }
            if (!world.field_72995_K) {
                player.openGui((Object)Calculator.instance, -2, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            }
            return true;
        }
        return false;
    }

    public TileEntity func_149915_a(World world, int i) {
        return this.type.getTile(world, i);
    }

    public boolean dropStandard(IBlockAccess world, BlockPos pos) {
        return false;
    }

    public void addSpecialToolTip(ItemStack stack, EntityPlayer player, List list) {
        CalculatorHelper.addEnergytoToolTip(stack, player, list);
    }

    public void standardInfo(ItemStack stack, EntityPlayer player, List list) {
        if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
            int energyUsage = 0;
            int speed = 0;
            switch (this.type.ordinal()) {
                case 0: {
                    energyUsage = CalculatorConfig.getInteger("Extraction ChamberEnergy Usage");
                    speed = CalculatorConfig.getInteger("Extraction ChamberBase Speed");
                    break;
                }
                case 1: {
                    energyUsage = CalculatorConfig.getInteger("Restoration ChamberEnergy Usage");
                    speed = CalculatorConfig.getInteger("Restoration ChamberBase Speed");
                    break;
                }
                case 2: {
                    energyUsage = CalculatorConfig.getInteger("Reassembly ChamberEnergy Usage");
                    speed = CalculatorConfig.getInteger("Reassembly ChamberBase Speed");
                    break;
                }
                case 3: {
                    energyUsage = CalculatorConfig.getInteger("Processing ChamberEnergy Usage");
                    speed = CalculatorConfig.getInteger("Processing ChamberBase Speed");
                    break;
                }
                case 4: {
                    energyUsage = CalculatorConfig.getInteger("Stone SeperatorEnergy Usage");
                    speed = CalculatorConfig.getInteger("Stone SeperatorBase Speed");
                    break;
                }
                case 5: {
                    energyUsage = CalculatorConfig.getInteger("Algorithm SeperatorEnergy Usage");
                    speed = CalculatorConfig.getInteger("Algorithm SeperatorBase Speed");
                    break;
                }
                case 6: {
                    energyUsage = CalculatorConfig.getInteger("Precision ChamberEnergy Usage");
                    speed = CalculatorConfig.getInteger("Precision ChamberBase Speed");
                    break;
                }
                case 7: {
                    energyUsage = CalculatorConfig.getInteger("Reinforced FurnaceEnergy Usage");
                    speed = CalculatorConfig.getInteger("Reinforced FurnaceBase Speed");
                }
            }
            list.add(FontHelper.translate((String)"Process Speed: ") + TextFormatting.WHITE + speed + " ticks");
            list.add(FontHelper.translate((String)"Energy Usage: ") + TextFormatting.WHITE + energyUsage + " RF per operation");
            list.add(FontHelper.translate((String)"Consumption: ") + TextFormatting.WHITE + energyUsage / speed + " RF/t");
        } else {
            list.add("Hold" + TextFormatting.YELLOW + " SHIFT " + TextFormatting.RESET + "for more info");
        }
    }

    public boolean isAnimated(IBlockState state, IBlockAccess w, BlockPos pos) {
        TileEntity target = w.func_175625_s(pos);
        if (target instanceof TileEntityAbstractProcess) {
            TileEntityAbstractProcess te = (TileEntityAbstractProcess)target;
            return te.isActive();
        }
        return false;
    }

    public BlockRenderLayer func_180664_k() {
        return !this.type.isOpaqueCube() ? BlockRenderLayer.CUTOUT_MIPPED : super.func_180664_k();
    }

    public static class ChamberBlock
    extends SmeltingBlock {
        public ChamberBlock(BlockTypes type) {
            super(type);
        }

        public boolean hasAnimatedFront() {
            return false;
        }
    }

    public static enum BlockTypes {
        EXTRACTION,
        RESTORATION,
        REASSEMBLY,
        PROCESSING,
        STONE,
        ALGORITHM,
        PRECISION,
        FURNACE;


        public boolean isOpaqueCube() {
            return this == STONE || this == ALGORITHM || this == FURNACE;
        }

        public TileEntity getTile(World world, int meta) {
            switch (this) {
                case EXTRACTION: {
                    return new TileEntityMachine.ExtractionChamber();
                }
                case RESTORATION: {
                    return new TileEntityMachine.RestorationChamber();
                }
                case REASSEMBLY: {
                    return new TileEntityMachine.ReassemblyChamber();
                }
                case PROCESSING: {
                    return new TileEntityMachine.ProcessingChamber();
                }
                case STONE: {
                    return new TileEntityMachine.StoneSeperator();
                }
                case ALGORITHM: {
                    return new TileEntityMachine.AlgorithmSeperator();
                }
                case PRECISION: {
                    return new TileEntityMachine.PrecisionChamber();
                }
                case FURNACE: {
                    return new TileEntityMachine.ReinforcedFurnace();
                }
            }
            return null;
        }
    }
}

