/*
 * Decompiled with CFR 0.152.
 */
package sonar.calculator.mod.common.block.generators;

import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import sonar.calculator.mod.Calculator;
import sonar.calculator.mod.CalculatorConfig;
import sonar.calculator.mod.common.tileentity.generators.TileEntityGenerator;
import sonar.calculator.mod.utils.helpers.CalculatorHelper;
import sonar.core.api.utils.BlockInteraction;
import sonar.core.common.block.SonarMachineBlock;
import sonar.core.common.block.SonarMaterials;
import sonar.core.helpers.FontHelper;

public class ExtractorBlock
extends SonarMachineBlock {
    public int type;

    public ExtractorBlock(int type) {
        super(SonarMaterials.machine, false, true);
        this.type = type;
        this.setBlockBounds(0.0625, 0.0625, 0.0625, 0.9375, 0.9375, 0.9375);
    }

    public boolean hasSpecialRenderer() {
        return true;
    }

    public boolean operateBlock(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, BlockInteraction interact) {
        if (player != null && !world.field_72995_K) {
            player.openGui((Object)Calculator.instance, -2, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
        return true;
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        super.func_176213_c(world, pos, state);
        TileEntity tileentity = world.func_175625_s(pos);
        if (tileentity != null && tileentity instanceof TileEntityGenerator) {
            TileEntityGenerator tileEntityGenerator = (TileEntityGenerator)world.func_175625_s(pos);
        }
    }

    public void onNeighborChange(IBlockAccess world, BlockPos pos, BlockPos neighbour) {
        TileEntity tileentity = world.func_175625_s(pos);
        if (tileentity != null && tileentity instanceof TileEntityGenerator) {
            TileEntityGenerator tileEntityGenerator = (TileEntityGenerator)world.func_175625_s(pos);
        }
    }

    public TileEntity func_149915_a(World world, int var) {
        switch (this.type) {
            case 0: {
                return new TileEntityGenerator.StarchExtractor();
            }
            case 1: {
                return new TileEntityGenerator.RedstoneExtractor();
            }
            case 2: {
                return new TileEntityGenerator.GlowstoneExtractor();
            }
        }
        return new TileEntityGenerator.StarchExtractor();
    }

    public void addSpecialToolTip(ItemStack stack, EntityPlayer player, List list) {
        CalculatorHelper.addEnergytoToolTip(stack, player, list);
        CalculatorHelper.addItemLevelToolTip(stack, player, list);
    }

    public void standardInfo(ItemStack stack, EntityPlayer player, List list) {
        switch (this.type) {
            case 0: {
                list.add(FontHelper.translate((String)"energy.generate") + ": " + CalculatorConfig.getInteger("Starch Extractor") + " RF/t");
                break;
            }
            case 1: {
                list.add(FontHelper.translate((String)"energy.generate") + ": " + CalculatorConfig.getInteger("Redstone Extractor") + " RF/t");
                break;
            }
            case 2: {
                list.add(FontHelper.translate((String)"energy.generate") + ": " + CalculatorConfig.getInteger("Glowstone Extractor") + " RF/t");
            }
        }
    }
}

