/*
 * Decompiled with CFR 0.152.
 */
package sonar.calculator.mod.common.item.calculators.modules;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import sonar.calculator.mod.CalculatorConfig;
import sonar.calculator.mod.api.modules.IModuleEnergy;
import sonar.core.api.utils.ActionType;

public class EnergyModule
implements IModuleEnergy {
    @Override
    public String getClientName() {
        return "Energy Module";
    }

    public boolean isLoadable() {
        return true;
    }

    public String getName() {
        return "Energy Module";
    }

    @Override
    public long receiveEnergy(ItemStack container, NBTTagCompound tag, long maxReceive, ActionType action) {
        long energy = tag.func_74763_f("Energy");
        long energyReceived = Math.min(this.getMaxEnergyStored(container, tag) - energy, Math.min(this.getMaxEnergyStored(container, tag) / 10L, maxReceive));
        if (!action.shouldSimulate()) {
            tag.func_74772_a("Energy", energy += energyReceived);
        }
        return energyReceived;
    }

    @Override
    public long extractEnergy(ItemStack container, NBTTagCompound tag, long maxExtract, ActionType action) {
        if (!tag.func_74764_b("Energy")) {
            return 0L;
        }
        long energy = tag.func_74763_f("Energy");
        long energyExtracted = Math.min(energy, Math.min(this.getMaxEnergyStored(container, tag) / 10L, maxExtract));
        if (!action.shouldSimulate()) {
            tag.func_74772_a("Energy", energy -= energyExtracted);
        }
        return energyExtracted;
    }

    @Override
    public long getEnergyStored(ItemStack container, NBTTagCompound tag) {
        return tag.func_74763_f("Energy");
    }

    @Override
    public long getMaxEnergyStored(ItemStack container, NBTTagCompound tag) {
        return CalculatorConfig.getInteger("Energy Module");
    }
}

