/*
 * Decompiled with CFR 0.152.
 */
package sonar.calculator.mod.common.item.modules;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import sonar.calculator.mod.Calculator;
import sonar.calculator.mod.api.machines.ProcessType;
import sonar.calculator.mod.api.nutrition.IHealthStore;
import sonar.calculator.mod.api.nutrition.IHungerStore;
import sonar.calculator.mod.utils.helpers.NutritionHelper;
import sonar.core.common.item.SonarItem;
import sonar.core.helpers.FontHelper;

public class NutritionModule
extends SonarItem
implements IHealthStore,
IHungerStore {
    public NutritionModule() {
        this.func_77637_a(Calculator.Calculator);
        this.field_77777_bU = 1;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int par, boolean bool) {
        if (!world.field_72995_K && entity instanceof EntityPlayer) {
            int ticks;
            NBTTagCompound nbtData;
            EntityPlayer player = (EntityPlayer)entity;
            if (!stack.func_77942_o()) {
                stack.func_77982_d(new NBTTagCompound());
            }
            if ((nbtData = stack.func_77978_p()) == null) {
                stack.func_77978_p().func_74768_a("health", 0);
                stack.func_77978_p().func_74768_a("hunger", 0);
                stack.func_77978_p().func_74768_a("ticks", 0);
            }
            if ((ticks = stack.func_77978_p().func_74762_e("ticks")) < 10) {
                stack.func_77978_p().func_74768_a("ticks", ticks + 1);
            } else {
                stack.func_77978_p().func_74768_a("ticks", 0);
                int points = stack.func_77978_p().func_74762_e("hunger");
                int hunger = player.func_71024_bL().func_75116_a();
                int maxpoints = 20 - hunger;
                int usedpoints = Math.min(maxpoints, 2);
                if (hunger < 20) {
                    if (points - usedpoints > 0) {
                        nbtData.func_74768_a("hunger", points -= usedpoints);
                        player.func_71024_bL().func_75122_a(hunger + usedpoints, 0.2f);
                    } else if (points - usedpoints <= 0) {
                        nbtData.func_74768_a("hunger", 0);
                        player.func_71024_bL().func_75122_a(points, 0.2f);
                    }
                }
                this.secondItemRightClick(stack, world, player);
            }
        }
    }

    public ItemStack secondItemRightClick(ItemStack stack, World world, EntityPlayer player) {
        int max;
        int current;
        NBTTagCompound nbtData = stack.func_77978_p();
        int points = stack.func_77978_p().func_74762_e("health");
        if (points != 0 && (current = (int)player.func_110143_aJ()) != (max = (int)player.func_110138_aP()) & current < max) {
            int maxpoints = max - current;
            int usedpoints = Math.min(maxpoints, 2);
            if (points - usedpoints >= 0) {
                nbtData.func_74768_a("health", points - usedpoints);
                player.func_70606_j(player.func_110143_aJ() + (float)usedpoints);
            } else if (points - usedpoints < 0) {
                nbtData.func_74768_a("health", 0);
                player.func_70606_j((float)(nbtData.func_74762_e("health") + current));
            }
        }
        return stack;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean par4) {
        super.func_77624_a(stack, player, list, par4);
        if (stack.func_77942_o()) {
            list.add(FontHelper.translate((String)"points.hunger") + ": " + this.getHungerPoints(stack));
            list.add(FontHelper.translate((String)"points.health") + ": " + this.getHealthPoints(stack));
        }
    }

    public EnumActionResult func_180614_a(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        NutritionHelper.useHunger(stack, player, world, pos, side, "hunger");
        NutritionHelper.useHealth(stack, player, world, pos, side, "health");
        return EnumActionResult.SUCCESS;
    }

    @Override
    public void transferHunger(int transfer, ItemStack stack, ProcessType process) {
        NBTTagCompound nbtData;
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if ((nbtData = stack.func_77978_p()) == null) {
            stack.func_77978_p().func_74768_a("hunger", 0);
        }
        int points = stack.func_77978_p().func_74762_e("hunger");
        if (process == ProcessType.REMOVE) {
            nbtData.func_74768_a("hunger", points - transfer);
        } else if (process == ProcessType.ADD) {
            nbtData.func_74768_a("hunger", points + transfer);
        }
    }

    @Override
    public int getHungerPoints(ItemStack stack) {
        return NutritionHelper.getIntegerTag(stack, "hunger");
    }

    @Override
    public int getMaxHungerPoints(ItemStack stack) {
        return -1;
    }

    @Override
    public void setHunger(ItemStack stack, int health) {
        if (health >= 0 && health <= this.getMaxHungerPoints(stack)) {
            NBTTagCompound nbtData;
            if (!stack.func_77942_o()) {
                stack.func_77982_d(new NBTTagCompound());
            }
            if ((nbtData = stack.func_77978_p()) == null) {
                stack.func_77978_p().func_74768_a("hunger", 0);
            }
            nbtData.func_74768_a("hunger", health);
        }
    }

    @Override
    public void transferHealth(int transfer, ItemStack stack, ProcessType process) {
        NBTTagCompound nbtData;
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if ((nbtData = stack.func_77978_p()) == null) {
            stack.func_77978_p().func_74768_a("health", 0);
        }
        int points = stack.func_77978_p().func_74762_e("health");
        if (process == ProcessType.REMOVE) {
            nbtData.func_74768_a("health", points - transfer);
        } else if (process == ProcessType.ADD) {
            nbtData.func_74768_a("health", points + transfer);
        }
    }

    @Override
    public int getHealthPoints(ItemStack stack) {
        return NutritionHelper.getIntegerTag(stack, "health");
    }

    @Override
    public int getMaxHealthPoints(ItemStack stack) {
        return -1;
    }

    @Override
    public void setHealth(ItemStack stack, int health) {
        if (health >= 0 && health <= this.getMaxHealthPoints(stack)) {
            NBTTagCompound nbtData;
            if (!stack.func_77942_o()) {
                stack.func_77982_d(new NBTTagCompound());
            }
            if ((nbtData = stack.func_77978_p()) == null) {
                stack.func_77978_p().func_74768_a("health", 0);
            }
            nbtData.func_74768_a("health", health);
        }
    }
}

