/*
 * Decompiled with CFR 0.152.
 */
package sonar.calculator.mod.common.recipes.machines;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import sonar.calculator.mod.Calculator;
import sonar.core.helpers.IRecipeHelper;
import sonar.core.helpers.ItemStackHelper;

public class FabricationChamberRecipes
implements IRecipeHelper {
    private static final FabricationChamberRecipes instance = new FabricationChamberRecipes();
    protected LinkedHashMap<ItemStack, CircuitStack[]> recipes = new LinkedHashMap();
    protected LinkedHashMap<CircuitStack[], ItemStack> recipes_reverse = new LinkedHashMap();

    public FabricationChamberRecipes() {
        this.addRecipes();
    }

    public static FabricationChamberRecipes getInstance() {
        return instance;
    }

    public LinkedHashMap<ItemStack, CircuitStack[]> getRecipes() {
        return this.recipes;
    }

    public LinkedHashMap<CircuitStack[], ItemStack> getRecipesReversed() {
        return this.recipes_reverse;
    }

    public void addRecipes() {
        this.createRecipe(new ItemStack(Calculator.atomic_module, 1), this.c(0, 1L, true), this.c(1, 1L, true), this.c(2, 1L, true), this.c(3, 1L, true), this.c(4, 1L, true), this.c(5, 1L, true), this.c(6, 1L, true), this.c(7, 1L, true), this.c(8, 1L, true), this.c(9, 1L, true), this.c(10, 1L, true), this.c(11, 1L, true), this.c(12, 1L, true), this.c(13, 1L, true));
        this.createRecipe(new ItemStack(Calculator.atomic_assembly, 1), this.c(0, 4L, false), this.c(1, 4L, false), this.c(2, 4L, false), this.c(3, 4L, false), this.c(4, 4L, false), this.c(5, 4L, false), this.c(6, 4L, false), this.c(7, 4L, false), this.c(8, 4L, false), this.c(9, 4L, false), this.c(10, 4L, false), this.c(11, 4L, false), this.c(12, 4L, false), this.c(13, 4L, false));
        this.createRecipe(new ItemStack(Calculator.calculator_screen, 1), this.c(0, 1L, false));
        this.createRecipe(new ItemStack(Calculator.itemCalculator, 1), this.c(0, 1L, false), this.c(1, 1L, false), this.c(2, 1L, false));
        this.createRecipe(new ItemStack(Calculator.itemScientificCalculator, 1), this.c(4, 1L, false), this.c(5, 1L, false), this.c(6, 1L, false));
        this.createRecipe(new ItemStack(Calculator.itemWarpModule, 1), this.c(5, 50L, false));
        this.createRecipe(new ItemStack(Calculator.speedUpgrade, 1), this.c(6, 1L, false));
        this.createRecipe(new ItemStack(Calculator.energyUpgrade, 1), this.c(7, 1L, false));
        this.createRecipe(new ItemStack(Calculator.voidUpgrade, 1), this.c(8, 1L, false));
        this.createRecipe(new ItemStack(Calculator.transferUpgrade, 1), this.c(9, 1L, false));
        this.createRecipe(new ItemStack(Calculator.calculator_assembly, 1), this.c(0, 3L, false));
    }

    public void createRecipe(ItemStack stack, CircuitStack ... circuits) {
        this.recipes.put(stack, circuits);
        this.recipes_reverse.put(circuits, stack);
    }

    public CircuitStack[] getRequirements(ItemStack stack) {
        for (Map.Entry<ItemStack, CircuitStack[]> entry : this.recipes.entrySet()) {
            if (entry.getKey() == null || !ItemStackHelper.equalStacksRegular((ItemStack)stack, (ItemStack)entry.getKey())) continue;
            return (CircuitStack[])entry.getValue().clone();
        }
        return null;
    }

    public static boolean canPerformRecipe(CircuitStack[] recipe, ArrayList<CircuitStack> stored) {
        for (CircuitStack stack : recipe) {
            if (FabricationChamberRecipes.containsCircuit(stored, stack)) continue;
            return false;
        }
        return true;
    }

    public static boolean containsCircuit(ArrayList<CircuitStack> storedStacks, CircuitStack stack) {
        for (CircuitStack stored : storedStacks) {
            if (stored.stable != stack.stable || stored.meta != stack.meta || stack.required > stored.required) continue;
            return true;
        }
        return false;
    }

    public CircuitStack c(int meta, long required, boolean stable) {
        return new CircuitStack(meta, required, stable);
    }

    public String getRecipeID() {
        return "FabricationChamber";
    }

    public static class CircuitStack {
        public int meta;
        public long required;
        public boolean stable;

        public CircuitStack(int meta, long required, boolean stable) {
            this.meta = meta;
            this.required = required;
            this.stable = stable;
        }

        public String toString() {
            return "C " + this.meta + ": " + this.required + " S: " + (this.stable ? "Y" : "N");
        }

        public CircuitStack clone() {
            return new CircuitStack(this.meta, this.required, this.stable);
        }

        public ItemStack buildItemStack() {
            ItemStack stack = new ItemStack(Calculator.circuitBoard, (int)this.required, this.meta);
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74768_a("Stable", this.stable ? 1 : 0);
            stack.func_77982_d(tag);
            return stack;
        }
    }
}

