/*
 * Decompiled with CFR 0.152.
 */
package sonar.calculator.mod.common.tileentity;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import sonar.calculator.mod.common.tileentity.TileEntityGreenhouse;
import sonar.calculator.mod.utils.helpers.GreenhouseHelper;
import sonar.core.api.SonarAPI;
import sonar.core.api.utils.BlockCoords;
import sonar.core.helpers.FontHelper;
import sonar.core.helpers.InventoryHelper;
import sonar.core.network.utils.IByteBufTile;
import sonar.core.utils.FailedCoords;

public abstract class TileEntityBuildingGreenhouse
extends TileEntityGreenhouse
implements IByteBufTile {
    public int requiredStairs = 183;
    public int requiredLogs = 30;
    public int requiredPlanks = 42;
    public int requiredGlass = 94;
    public int levelTicks;
    public int growTicks;
    public int growTick;
    public int requiredBuildEnergy = 0;

    public abstract int[] getSlotsForType(BlockType var1);

    public abstract ArrayList<BlockPlace> getStructure();

    public abstract void gasLevels();

    public abstract int getPlants();

    public abstract int getLanterns();

    public TileEntityBuildingGreenhouse(int requiredStairs, int requiredLogs, int requiredPlanks, int requiredGlass) {
        this.requiredStairs = requiredStairs;
        this.requiredLogs = requiredLogs;
        this.requiredPlanks = requiredPlanks;
        this.requiredGlass = requiredGlass;
        this.requiredBuildEnergy = (requiredStairs + requiredLogs + requiredPlanks + requiredGlass) * this.buildRF;
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.field_145850_b.func_175640_z(this.field_174879_c)) {
            return;
        }
        if (this.houseState.getObject() != TileEntityGreenhouse.State.BUILDING) {
            this.checkTile();
        }
        switch ((TileEntityGreenhouse.State)this.houseState.getObject()) {
            case COMPLETED: {
                if (!this.field_145850_b.field_72995_K) {
                    this.extraTicks();
                }
                this.plantCrops();
                this.growTicks();
                this.harvestCrops();
                break;
            }
            case BUILDING: {
                if (!this.checkStructure(TileEntityGreenhouse.GreenhouseAction.BUILD).getBoolean()) break;
                this.addFarmland();
                this.houseState.setObject((Enum)TileEntityGreenhouse.State.COMPLETED);
                break;
            }
            case DEMOLISHING: {
                this.checkStructure(TileEntityGreenhouse.GreenhouseAction.DEMOLISH);
                break;
            }
        }
    }

    public void growTicks() {
        if (this.growTicks == 0) {
            this.growTick = GreenhouseHelper.getGrowTicks(this.getOxygen(), 1);
            ++this.growTicks;
            return;
        }
        if (this.growTick != 0 && this.growTicks >= this.growTick) {
            if (this.storage.getEnergyStored() >= this.growthRF) {
                this.growTicks = 0;
                this.growCrops(1);
            }
        } else {
            ++this.growTicks;
        }
    }

    public void extraTicks() {
        if (this.levelTicks == 15) {
            this.getPlants();
            this.getLanterns();
        }
        if (this.levelTicks >= 0 && this.levelTicks != 20) {
            ++this.levelTicks;
        }
        if (this.levelTicks == 20) {
            this.levelTicks = 0;
            SonarAPI.getItemHelper().transferItems(this.func_145831_w().func_175625_s(this.field_174879_c.func_177972_a(this.forward.func_176734_d())), (TileEntity)this, EnumFacing.func_82600_a((int)0), EnumFacing.func_82600_a((int)0), (InventoryHelper.IInventoryFilter)new TileEntityGreenhouse.PlantableFilter());
            this.gasLevels();
        }
    }

    public void setBlockType(BlockPos pos, int[] slots, BlockType type, int meta) {
        boolean found = false;
        for (int i = 0; i < slots.length; ++i) {
            ItemStack target;
            int slot = slots[i];
            if (slot >= this.slots().length || (target = this.slots()[slot]) == null || !type.checkBlock(target.func_77973_b())) continue;
            found = true;
            Block block = Block.func_149634_a((Item)target.func_77973_b());
            --this.slots()[slot].field_77994_a;
            if (this.slots()[slot].field_77994_a == 1) {
                this.slots()[slot] = null;
            }
            if (meta == -1) {
                this.field_145850_b.func_180501_a(pos, block.func_176203_a(target.func_77952_i()), 2);
            } else {
                this.field_145850_b.func_180501_a(pos, block.func_176203_a(meta), 3);
            }
            this.storage.modifyEnergyStored(-this.buildRF);
            found = true;
            break;
        }
        if (!found) {
            this.houseState.setObject((Enum)TileEntityGreenhouse.State.INCOMPLETE);
        }
    }

    public boolean hasRequiredStacks() {
        int logs = 0;
        int stairs = 0;
        int planks = 0;
        int glass = 0;
        for (int i = 0; i < 7; ++i) {
            ItemStack stack = this.slots()[i];
            if (stack == null) {
                return false;
            }
            if (GreenhouseHelper.checkLog(Block.func_149634_a((Item)stack.func_77973_b()))) {
                logs += stack.field_77994_a;
                continue;
            }
            if (GreenhouseHelper.checkStairs(Block.func_149634_a((Item)stack.func_77973_b()))) {
                stairs += stack.field_77994_a;
                continue;
            }
            if (GreenhouseHelper.checkPlanks(Block.func_149634_a((Item)stack.func_77973_b()))) {
                planks += stack.field_77994_a;
                continue;
            }
            if (!GreenhouseHelper.checkGlass(Block.func_149634_a((Item)stack.func_77973_b()))) continue;
            glass += stack.field_77994_a;
        }
        return logs >= this.requiredLogs && stairs >= this.requiredStairs && planks >= this.requiredPlanks && glass >= this.requiredGlass;
    }

    public ArrayList<String> getRequiredStacks() {
        int logs = 0;
        int stairs = 0;
        int planks = 0;
        int glass = 0;
        for (int i = 0; i < 7; ++i) {
            ItemStack stack = this.slots()[i];
            if (stack == null) continue;
            if (GreenhouseHelper.checkLog(Block.func_149634_a((Item)stack.func_77973_b()))) {
                logs += stack.field_77994_a;
                continue;
            }
            if (GreenhouseHelper.checkStairs(Block.func_149634_a((Item)stack.func_77973_b()))) {
                stairs += stack.field_77994_a;
                continue;
            }
            if (GreenhouseHelper.checkPlanks(Block.func_149634_a((Item)stack.func_77973_b()))) {
                planks += stack.field_77994_a;
                continue;
            }
            if (!GreenhouseHelper.checkGlass(Block.func_149634_a((Item)stack.func_77973_b()))) continue;
            glass += stack.field_77994_a;
        }
        ArrayList<String> list = new ArrayList<String>();
        list.add("greenhouse.requires");
        if (logs < this.requiredLogs) {
            list.add(this.requiredLogs - logs + " " + FontHelper.translate((String)"greenhouse.logs"));
        }
        if (stairs < this.requiredStairs) {
            list.add(this.requiredStairs - stairs + " " + FontHelper.translate((String)"greenhouse.stairs"));
        }
        if (planks < this.requiredPlanks) {
            list.add(this.requiredPlanks - planks + " " + FontHelper.translate((String)"greenhouse.planks"));
        }
        if (glass < this.requiredGlass) {
            list.add(this.requiredGlass - glass + " " + FontHelper.translate((String)"greenhouse.glass"));
        }
        if (list.size() == 1) {
            return new ArrayList<String>();
        }
        return list;
    }

    public FailedCoords createBlock() {
        FailedCoords coords = this.checkStructure(TileEntityGreenhouse.GreenhouseAction.CAN_BUILD);
        if (this.houseState.getObject() != TileEntityGreenhouse.State.BUILDING && coords.getBoolean() && this.storage.getEnergyStored() >= this.requiredBuildEnergy && this.hasRequiredStacks()) {
            this.houseState.setObject((Enum)TileEntityGreenhouse.State.BUILDING);
        }
        return coords;
    }

    @Override
    public FailedCoords checkStructure(TileEntityGreenhouse.GreenhouseAction action) {
        FailedCoords current = null;
        ArrayList<BlockPlace> blocks = this.getStructure();
        for (BlockPlace block : blocks) {
            if (block.pos.equals((Object)this.func_174877_v()) || (current = this.checkBlock(action, block)) == null) continue;
            return current;
        }
        if (action == TileEntityGreenhouse.GreenhouseAction.DEMOLISH) {
            ArrayList coords = new ArrayList();
            for (int Z = -5; Z <= 5; ++Z) {
                for (int X = -5; X <= 5; ++X) {
                    BlockPos pos = this.field_174879_c.func_177982_a(this.forward.func_82601_c() * 4 + X, -1, this.forward.func_82599_e() * 4 + Z);
                    Block target = this.field_145850_b.func_180495_p(pos).func_177230_c();
                    if (target != Blocks.field_150346_d && target != Blocks.field_150458_ak && target != Blocks.field_150355_j && !target.func_176200_f((IBlockAccess)this.field_145850_b, pos)) continue;
                    this.field_145850_b.func_180501_a(pos, Blocks.field_150349_c.func_176223_P(), 2);
                }
            }
            if (this.houseState.getObject() == TileEntityGreenhouse.State.DEMOLISHING) {
                this.houseState.setObject((Enum)TileEntityGreenhouse.State.INCOMPLETE);
                this.wasBuilt.setObject((Object)false);
            }
        }
        return new FailedCoords(true, 0, 0, 0, FontHelper.translate((String)"locator.none"));
    }

    public FailedCoords checkBlock(TileEntityGreenhouse.GreenhouseAction action, BlockPlace place) {
        IBlockState state = this.field_145850_b.func_180495_p(place.pos);
        boolean checkBlock = false;
        switch (place.type) {
            case LOG: {
                checkBlock = this.checkLog(place.pos);
                break;
            }
            case STAIRS: {
                checkBlock = this.checkStairs(place.pos);
                break;
            }
            case PLANKS: {
                checkBlock = this.checkPlanks(place.pos);
                break;
            }
            case GLASS: {
                checkBlock = this.checkGlass(place.pos);
                break;
            }
        }
        switch (action) {
            case BUILD: {
                if (checkBlock) break;
                this.setBlockType(place.pos, this.getSlotsForType(place.type), place.type, place.meta);
                return new FailedCoords(false, place.pos, place.type.toString());
            }
            case CHECK: {
                if (checkBlock) break;
                return new FailedCoords(false, place.pos, place.type.toString());
            }
            case CAN_BUILD: {
                if (checkBlock || GreenhouseHelper.r(this.field_145850_b, place.pos) || state.func_177230_c().isAir(state, (IBlockAccess)this.field_145850_b, place.pos) || state.func_177230_c().func_176200_f((IBlockAccess)this.field_145850_b, place.pos)) break;
                return new FailedCoords(false, place.pos, "Can't Replace");
            }
            case DEMOLISH: {
                List stacks;
                if (!checkBlock || (stacks = state.func_177230_c().getDrops((IBlockAccess)this.field_145850_b, place.pos, state, 0)) == null) break;
                if (stacks.isEmpty() && place.type == BlockType.GLASS) {
                    stacks.add(new ItemStack(Item.func_150898_a((Block)state.func_177230_c()), 1, state.func_177230_c().func_176201_c(state)));
                }
                this.addHarvestedStacks(stacks, place.pos, false);
                return new FailedCoords(false, place.pos, place.type.toString());
            }
        }
        return null;
    }

    public int intValues(int par, BlockType block) {
        if (this.type == 2 && block == BlockType.STAIRS) {
            switch (par) {
                case 3: {
                    return 5;
                }
                case 4: {
                    return 4;
                }
                case 5: {
                    return 3;
                }
                case 6: {
                    return 2;
                }
                case 7: {
                    return 1;
                }
            }
        }
        if (this.type == 1 && block == BlockType.STAIRS) {
            switch (par) {
                case 2: {
                    return 3;
                }
                case 3: {
                    return 2;
                }
                case 4: {
                    return 1;
                }
            }
        }
        return 0;
    }

    public boolean checkLog(BlockPos pos) {
        Block block = this.field_145850_b.func_180495_p(pos).func_177230_c();
        return block != null && GreenhouseHelper.checkLog(block);
    }

    public boolean checkGlass(BlockPos pos) {
        Block block = this.field_145850_b.func_180495_p(pos).func_177230_c();
        return block != null && GreenhouseHelper.checkGlass(block);
    }

    public boolean checkPlanks(BlockPos pos) {
        Block block = this.field_145850_b.func_180495_p(pos).func_177230_c();
        return block != null && GreenhouseHelper.checkPlanks(block);
    }

    public boolean checkStairs(BlockPos pos) {
        Block block = this.field_145850_b.func_180495_p(pos).func_177230_c();
        return block != null && GreenhouseHelper.checkStairs(block);
    }

    public void writePacket(ByteBuf buf, int id) {
    }

    public void readPacket(ByteBuf buf, int id) {
        switch (id) {
            case 0: {
                this.createBlock();
                break;
            }
            case 1: {
                this.houseState.setObject((Enum)TileEntityGreenhouse.State.BUILDING);
                break;
            }
            case 2: {
                this.houseState.setObject((Enum)TileEntityGreenhouse.State.DEMOLISHING);
            }
        }
    }

    public static class BlockPlace {
        public BlockType type;
        public BlockPos pos;
        public int meta;

        public BlockPlace(BlockType block, BlockCoords coords, int meta) {
            this(block, coords.getBlockPos(), meta);
        }

        public BlockPlace(BlockType block, int x, int y, int z, int meta) {
            this(block, new BlockPos(x, y, z), meta);
        }

        public BlockPlace(BlockType block, BlockPos pos, int meta) {
            this.type = block;
            this.pos = pos;
            this.meta = meta;
        }
    }

    public static enum BlockType {
        LOG,
        GLASS,
        PLANKS,
        STAIRS,
        NONE;


        public boolean checkBlock(Item item) {
            Block block = Block.func_149634_a((Item)item);
            if (block == null) {
                return false;
            }
            switch (this) {
                case LOG: {
                    return GreenhouseHelper.checkLog(block);
                }
                case GLASS: {
                    return GreenhouseHelper.checkGlass(block);
                }
                case PLANKS: {
                    return GreenhouseHelper.checkPlanks(block);
                }
                case STAIRS: {
                    return GreenhouseHelper.checkStairs(block);
                }
            }
            return false;
        }

        public static BlockType getTypeForItem(Item item) {
            for (BlockType type : BlockType.values()) {
                if (!type.checkBlock(item)) continue;
                return type;
            }
            return NONE;
        }
    }
}

